/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.gen.business.core.task;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.ftask.producer.context.ITaskProductionContext;
import org.eclipse.egf.ftask.producer.invocation.ITaskProduction;
import org.polarsys.kitalpha.doc.gen.business.core.Activator;
import org.polarsys.kitalpha.doc.gen.business.core.services.IndexItem;
import org.polarsys.kitalpha.doc.gen.business.core.util.DocGenHtmlUtil;
import org.polarsys.kitalpha.doc.gen.business.core.util.MonitorServices;

public class IndexingConceptsTask
implements ITaskProduction {
    private static final String LOG_PROPERTY = "org.polarsys.kitalpha.doc.gen.business.core/debug";
    private static final boolean DO_TRACE = IndexingConceptsTask.isLogFeatureSetted();
    private static final Logger logger = Logger.getLogger(IndexingConceptsTask.class.getName());
    private static final String INDEXING_PREF = "[INDEXING] ";
    private Map<IndexItem, List<String>> conceptsToPageTitle = new HashMap<IndexItem, List<String>>();
    private Map<IndexItem, List<String>> conceptsToPageParagraph = new HashMap<IndexItem, List<String>>();
    private Map<IndexItem, List<String>> conceptsToPageList = new HashMap<IndexItem, List<String>>();
    private Map<IndexItem, List<String>> conceptsToPageTable = new HashMap<IndexItem, List<String>>();
    @Deprecated
    private Map<String, String> fileNameToTitle = new HashMap<String, String>();
    private static final Pattern pTable = Pattern.compile("<table>(.*?)</table>", 32);
    private static final Pattern pTitle = Pattern.compile(".*<title>(.*?)</title>.*", 32);
    private static final Pattern pHeaderOne = Pattern.compile(".*<h1>(.*?)</h1>.*", 32);
    private static final Pattern pParagraphe = Pattern.compile("<p>(.*?)</p>", 32);
    private static final Pattern pListStartEnd = Pattern.compile("((<ul.*?>)|(</ul>))", 32);
    private static Matcher mTable = pTable.matcher("");
    private static Matcher mTitle = pTitle.matcher("");
    private static Matcher mPHeaderOne = pHeaderOne.matcher("");
    private static Matcher mParagraphe = pParagraphe.matcher("");
    private static Matcher mListStartEnd = pListStartEnd.matcher("");
    private static final String HEADER = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\"><head><meta http-equiv=\"content-type\" content=\"text/html;charset=ISO-8859-1\" /><meta http-equiv=\"Content-Style-Type\" content=\"text/css\" /><title>Index</title>\t\t<link title=\"default\" rel=\"stylesheet\" type=\"text/css\" media=\"screen, projection\" href=\"../../../css/content.css\"></link></head><body><div id=\"content\">";
    private static final String FOOTER = "</div></body></html>";

    public void preExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
    }

    public boolean isFileAModelHtmlPage(String fileName) {
        return !this.isFooterOrHeaderPage(fileName) && !this.isIndexPage(fileName);
    }

    private boolean isFooterOrHeaderPage(String fileName) {
        return fileName.equals("footer.html") || fileName.equals("header.html");
    }

    private boolean isIndexPage(String fileName) {
        return fileName.equals("index.html") || fileName.equals("searchIndex.html") || fileName.equals("sidebar.html");
    }

    public void doExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
        String projectName = (String)productionContext.getInputValue((Object)"projectName", String.class);
        String outputFolder = (String)productionContext.getInputValue((Object)"outputFolder", String.class);
        Map indexItems = (Map)productionContext.getInputValue((Object)"indexItems", Map.class);
        if (DO_TRACE) {
            logger.info("[INDEXING] Start indexing at: " + Calendar.getInstance().get(12));
            logger.info("[INDEXING] Project: " + projectName);
            logger.info("[INDEXING] Output folder: " + outputFolder);
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        IFolder folder = project.getFolder((IPath)new Path(outputFolder));
        try {
            IResource[] content = folder.members();
            MonitorServices.init(content.length);
            this.indexResources(indexItems, content);
            if (DO_TRACE) {
                logger.info("[INDEXING] Starting generating index pages");
            }
            MonitorServices.init(indexItems.size());
            this.generatingConceptsPages(projectName, outputFolder, indexItems, monitor);
            if (DO_TRACE) {
                logger.info("[INDEXING] End generating index pages");
            }
        }
        catch (CoreException e) {
            Status status = new Status(4, "org.polarsys.kitalpha.doc.gen.business.core", e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
    }

    private void indexResources(Map<String, IndexItem> indexItems, IResource[] content) throws CoreException {
        IResource[] iResourceArray = content;
        int n = content.length;
        int n2 = 0;
        while (n2 < n) {
            IResource currentResource = iResourceArray[n2];
            if (currentResource instanceof IFile) {
                this.indexFile(indexItems, currentResource);
            }
            MonitorServices.workSubMonitor("Computing index pages content");
            ++n2;
        }
    }

    private void indexFile(Map<String, IndexItem> indexItems, IResource currentResource) throws CoreException {
        IFile file = (IFile)currentResource;
        if (file.getName().endsWith(".html") && this.isFileAModelHtmlPage(file.getName())) {
            if (DO_TRACE) {
                logger.info("[INDEXING] Starting indexing page: " + file.getName());
            }
            this.indexPage(indexItems, file);
            if (DO_TRACE) {
                logger.info("[INDEXING] Ending indexing page: " + file.getName());
            }
        }
    }

    private void generatingConceptsPages(String projectName, String outputFolder, Map<String, IndexItem> indexItems, IProgressMonitor monitor) {
        int i = 0;
        ArrayList<String> indexItemsToRemove = new ArrayList<String>();
        for (Map.Entry<String, IndexItem> currentConcept : indexItems.entrySet()) {
            if (!this.isToRemoveIndexItem(currentConcept.getValue())) {
                ++i;
                StringBuffer buffer = new StringBuffer();
                buffer.append(HEADER);
                buffer.append("<h1>" + currentConcept.getValue().getConceptName() + "</h1>");
                this.generateLinkTowardConcept(indexItems, currentConcept.getValue(), buffer);
                List<String> currentConceptPages = this.conceptsToPageTitle.get(currentConcept.getValue());
                this.generateTitle(currentConcept.getValue(), indexItems, buffer, currentConceptPages);
                currentConceptPages = this.conceptsToPageParagraph.get(currentConcept.getValue());
                this.generateParagraph(currentConcept.getValue(), indexItems, buffer, currentConceptPages);
                currentConceptPages = this.conceptsToPageList.get(currentConcept.getValue());
                this.generateList(currentConcept.getValue(), indexItems, buffer, currentConceptPages);
                currentConceptPages = this.conceptsToPageTable.get(currentConcept.getValue());
                this.generateTable(currentConcept.getValue(), indexItems, buffer, currentConceptPages);
                buffer.append(FOOTER);
                DocGenHtmlUtil.writeFilePatternContent(String.valueOf(i) + "_" + currentConcept.getValue().getFileName(), projectName, String.valueOf(outputFolder) + "/concepts", buffer.toString());
            } else {
                indexItemsToRemove.add(currentConcept.getKey());
            }
            MonitorServices.workSubMonitor("Generating index pages");
        }
        this.doClean(indexItems, indexItemsToRemove);
    }

    private boolean isToRemoveIndexItem(IndexItem item) {
        boolean noPage = true;
        List<String> inPages = this.conceptsToPageTitle.get(item);
        noPage = inPages == null || inPages.isEmpty();
        boolean noPageParagraph = true;
        List<String> inPageParagraph = this.conceptsToPageParagraph.get(item);
        noPageParagraph = inPageParagraph == null || inPageParagraph.isEmpty();
        boolean noPageList = true;
        List<String> inList = this.conceptsToPageList.get(item);
        noPageList = inList == null || inList.isEmpty();
        boolean noPageTable = true;
        List<String> inTable = this.conceptsToPageTable.get(item);
        boolean bl = noPageTable = inTable == null || inTable.isEmpty();
        return noPage && noPageParagraph && noPageList && noPageTable;
    }

    private void doClean(Map<String, IndexItem> indexItems, List<String> indexItemsToRemove) {
        if (!indexItemsToRemove.isEmpty()) {
            for (String item : indexItemsToRemove) {
                indexItems.remove(item);
            }
        }
    }

    private void generateLinkTowardConcept(Map<String, IndexItem> indexItems, IndexItem indexItem, StringBuffer buffer) {
        String iconTag = indexItem.getIconTag();
        String linkTagTowardPageElement = indexItem.getLinkTagTowardPageElement();
        if (linkTagTowardPageElement != null && !linkTagTowardPageElement.isEmpty()) {
            buffer.append("<h2>Direct link toward element page</h2>");
            buffer.append("<ul class=\"generatedList\"><li>");
            if (iconTag != null) {
                buffer.append(iconTag).append(" ");
            }
            buffer.append(linkTagTowardPageElement);
            buffer.append("</li></ul>");
        }
    }

    private void generateTable(IndexItem indexItem, Map<String, IndexItem> indexItems, StringBuffer buffer, List<String> currentConceptPages) {
        if (currentConceptPages != null) {
            this.doGenerateTables(indexItem, indexItems, buffer, currentConceptPages);
        }
    }

    private void generateList(IndexItem indexItem, Map<String, IndexItem> indexItems, StringBuffer buffer, List<String> currentConceptPages) {
        if (currentConceptPages != null) {
            this.doGenerateLists(indexItem, buffer, indexItems, currentConceptPages);
        }
    }

    private void generateParagraph(IndexItem indexItem, Map<String, IndexItem> indexItems, StringBuffer buffer, List<String> currentConceptPages) {
        if (currentConceptPages != null) {
            this.doGenerateParagraphs(indexItem, indexItems, buffer);
        }
    }

    private void generateTitle(IndexItem indexItem, Map<String, IndexItem> indexItems, StringBuffer buffer, List<String> currentConceptPages) {
        if (currentConceptPages != null) {
            this.doGenerateTitles(indexItem, indexItems, buffer);
        }
    }

    private Optional<IndexItem> generateImageTag(String fileName, Map<String, IndexItem> indexItems, StringBuffer buffer) {
        IndexItem matchingItem = indexItems.get(fileName.substring(0, fileName.indexOf(".")));
        if (matchingItem != null) {
            String iconTag = matchingItem.getIconTag();
            if (iconTag != null && !iconTag.isEmpty()) {
                buffer.append(iconTag).append(" ");
            }
            return Optional.of(matchingItem);
        }
        return Optional.empty();
    }

    private void doGenerateTables(IndexItem indexItem, Map<String, IndexItem> indexItems, StringBuffer buffer, List<String> currentConceptPages) {
        buffer.append("<h2>Tables referencing the Element</h2>");
        buffer.append("<ul class=\"generatedList\">");
        for (String fileName : currentConceptPages) {
            this.doGenerateHtmlListItem(indexItems, buffer, fileName);
        }
        buffer.append("</ul>");
    }

    private void doGenerateLists(IndexItem indexItem, StringBuffer buffer, Map<String, IndexItem> indexItems, List<String> currentConceptPages) {
        buffer.append("<h2>Lists referencing the Element</h2>");
        buffer.append("<ul class=\"generatedList\">");
        for (String fileName : currentConceptPages) {
            this.doGenerateHtmlListItem(indexItems, buffer, fileName);
        }
        buffer.append("</ul>");
    }

    private void doGenerateParagraphs(IndexItem indexItem, Map<String, IndexItem> indexItems, StringBuffer buffer) {
        buffer.append("<h2>Paragraphs referencing the Element</h2>");
        buffer.append("<ul class=\"generatedList\">");
        for (String fileName : this.conceptsToPageParagraph.get(indexItem)) {
            this.doGenerateHtmlListItem(indexItems, buffer, fileName);
        }
        buffer.append("</ul>");
    }

    private void doGenerateTitles(IndexItem indexItem, Map<String, IndexItem> indexItems, StringBuffer buffer) {
        buffer.append("<h2>Titles referencing the Element</h2>");
        buffer.append("<ul class=\"generatedList\">");
        for (String fileName : this.conceptsToPageTitle.get(indexItem)) {
            this.doGenerateHtmlListItem(indexItems, buffer, fileName);
        }
        buffer.append("</ul>");
    }

    private void doGenerateHtmlListItem(Map<String, IndexItem> indexItems, StringBuffer buffer, String fileName) {
        buffer.append("<li>");
        Optional<IndexItem> findedItem = this.generateImageTag(fileName, indexItems, buffer);
        if (findedItem.isPresent()) {
            IndexItem item = findedItem.get();
            buffer.append("<a href=\"../" + fileName + "\">" + item.getConceptType() + " - " + item.getConceptName() + "</a>");
        } else {
            buffer.append("<a href=\"../" + fileName + "\">" + this.fileNameToTitle.get(fileName) + "</a>");
        }
        buffer.append("</li>");
    }

    private String getPageContent(IFile file) throws CoreException {
        StringBuffer buffer = new StringBuffer();
        InputStream inputStream = null;
        try {
            String line;
            inputStream = file.getContents();
            InputStreamReader reader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(reader);
            while ((line = bufferedReader.readLine()) != null) {
                buffer.append(line);
            }
            inputStream.close();
        }
        catch (IOException | CoreException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.kitalpha.doc.gen.business.core", e.getMessage(), e));
        }
        return buffer.toString();
    }

    private void indexPage(Map<String, IndexItem> indexItems, IFile file) throws CoreException {
        String fileName = file.getName();
        String pageContent = this.getPageContent(file);
        if ((mTitle = mTitle.reset(pageContent)).matches()) {
            String title = mTitle.group(1);
            this.fileNameToTitle.put(fileName, title);
            if (DO_TRACE) {
                logger.info("[INDEXING] Title index: " + title + " in file: " + fileName);
            }
        }
        if ((mPHeaderOne = mPHeaderOne.reset(pageContent)).matches()) {
            for (Map.Entry<String, IndexItem> entry : indexItems.entrySet()) {
                String currentConcept_html;
                String title = mPHeaderOne.group(1);
                if (!title.contains(currentConcept_html = entry.getValue().getEscapedForHTMLConceptName())) continue;
                this.indexTitle(fileName, entry.getValue());
            }
        }
        if (DO_TRACE) {
            logger.info("[INDEXING] Starting indexing paragraphs of file: " + fileName);
        }
        mParagraphe = mParagraphe.reset(pageContent);
        while (mParagraphe.find()) {
            block2: for (Map.Entry<String, IndexItem> entry : indexItems.entrySet()) {
                String currentConcept_html = entry.getValue().getEscapedForHTMLConceptName();
                int i = 1;
                while (i <= mParagraphe.groupCount()) {
                    String paragraph = mParagraphe.group(i);
                    if (paragraph.contains(currentConcept_html)) {
                        this.indexParagraph(fileName, entry.getValue());
                        continue block2;
                    }
                    ++i;
                }
            }
        }
        if (DO_TRACE) {
            logger.info("[INDEXING] End indexing paragraphs of file: " + fileName);
        }
        if (DO_TRACE) {
            logger.info("[INDEXING] Start indexing Lists of file: " + fileName);
        }
        mListStartEnd = mListStartEnd.reset(pageContent);
        int level = 0;
        int listStartIndex = -1;
        while (mListStartEnd.find()) {
            if (mListStartEnd.groupCount() > 1 && mListStartEnd.group(2) != null) {
                if (++level != 1) continue;
                listStartIndex = mListStartEnd.start(2);
                continue;
            }
            if (--level != 0) continue;
            int listEndIndex = mListStartEnd.end(3);
            String listText = pageContent.substring(listStartIndex, listEndIndex);
            for (Map.Entry<String, IndexItem> entry : indexItems.entrySet()) {
                String currentConcept_html = entry.getValue().getEscapedForHTMLConceptName();
                if (!listText.contains(currentConcept_html)) continue;
                this.indexList(fileName, entry.getValue());
            }
        }
        if (DO_TRACE) {
            logger.info("[INDEXING] End indexing Lists of file: " + fileName);
        }
        if (DO_TRACE) {
            logger.info("[INDEXING] Start indexing Table of file: " + fileName);
        }
        mTable = mTable.reset(pageContent);
        while (mTable.find()) {
            block7: for (Map.Entry<String, IndexItem> entry : indexItems.entrySet()) {
                String currentConcept_html = entry.getValue().getEscapedForHTMLConceptName();
                int i = 1;
                while (i <= mTable.groupCount()) {
                    String listGroup = mTable.group(i);
                    if (listGroup.contains(currentConcept_html)) {
                        this.indexTable(fileName, entry.getValue());
                        continue block7;
                    }
                    ++i;
                }
            }
        }
        if (DO_TRACE) {
            logger.info("[INDEXING] End indexing Table of file: " + fileName);
        }
    }

    private void indexList(String fileName, IndexItem indexItem) {
        List<String> list = this.conceptsToPageList.get(indexItem);
        if (list != null && !list.contains(fileName)) {
            list.add(fileName);
        } else {
            ArrayList<String> localList = new ArrayList<String>();
            localList.add(fileName);
            this.conceptsToPageList.put(indexItem, localList);
        }
        if (DO_TRACE) {
            logger.info("[INDEXING] Concept: " + indexItem + " is indexed in file: " + fileName);
        }
    }

    private void indexParagraph(String fileName, IndexItem indexItem) {
        List<String> list = this.conceptsToPageParagraph.get(indexItem);
        if (list != null && !list.contains(fileName)) {
            list.add(fileName);
        } else {
            ArrayList<String> localList = new ArrayList<String>();
            localList.add(fileName);
            this.conceptsToPageParagraph.put(indexItem, localList);
        }
        if (DO_TRACE) {
            logger.info("[INDEXING] Concept: " + indexItem.getConceptName() + " is indexed in file: " + fileName);
        }
    }

    private void indexTitle(String fileName, IndexItem currentConcept) {
        List<String> list = this.conceptsToPageTitle.get(currentConcept);
        if (list != null && !list.contains(fileName)) {
            list.add(fileName);
        } else {
            ArrayList<String> localList = new ArrayList<String>();
            localList.add(fileName);
            this.conceptsToPageTitle.put(currentConcept, localList);
        }
        if (DO_TRACE) {
            logger.info("[INDEXING] Concept: " + currentConcept + " is indexed in file: " + fileName);
        }
    }

    private void indexTable(String fileName, IndexItem indexItem) {
        List<String> list = this.conceptsToPageTable.get(indexItem);
        if (list != null && !list.contains(fileName)) {
            list.add(fileName);
        } else {
            ArrayList<String> localList = new ArrayList<String>();
            localList.add(fileName);
            this.conceptsToPageTable.put(indexItem, localList);
        }
        if (DO_TRACE) {
            logger.info("[INDEXING] Concept: " + indexItem + " is indexed in file: " + fileName);
        }
    }

    public void postExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
    }

    private static boolean isLogFeatureSetted() {
        String property = Platform.getDebugOption((String)LOG_PROPERTY);
        return property != null && property.equalsIgnoreCase("true");
    }
}

