/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.diffmerge.bridge.integration.transposer;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.diffmerge.api.scopes.IEditableModelScope;
import org.eclipse.emf.diffmerge.api.scopes.IPersistentModelScope;
import org.eclipse.emf.diffmerge.bridge.api.IBridgeExecution;
import org.eclipse.emf.diffmerge.bridge.operations.AbstractBridgeOperation;
import org.eclipse.emf.diffmerge.bridge.util.INormalizableModelScope;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.polarsys.kitalpha.diffmerge.bridge.integration.transposer.Messages;
import org.polarsys.kitalpha.diffmerge.bridge.integration.transposer.TransposerBridge;
import org.polarsys.kitalpha.diffmerge.bridge.integration.transposer.TransposerBridgeContext;
import org.polarsys.kitalpha.diffmerge.bridge.integration.transposer.TransposerBridgeExecution;
import org.polarsys.kitalpha.transposer.api.ITransposer;
import org.polarsys.kitalpha.transposer.api.TransposerConfiguration;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class TransposerBridgeOperation
extends AbstractBridgeOperation {
    private final TransposerConfiguration _configuration;

    public TransposerBridgeOperation(Object sourceDataSet_p, IEditableModelScope targetDataSet_p, TransposerBridge<?> bridge_p, TransposerConfiguration configuration_p, TransposerBridgeExecution execution_p) {
        super(sourceDataSet_p instanceof Collection ? (Set<Object>)sourceDataSet_p : Collections.singleton(sourceDataSet_p), (Object)targetDataSet_p, bridge_p, (IBridgeExecution)execution_p);
        this._configuration = configuration_p;
    }

    public IStatus run() {
        IStatus result;
        TransposerBridge<Collection<Object>> bridge = this.getBridge();
        ITransposer transposer = bridge.getTransposer();
        TransposerConfiguration configuration = this.getTransposerConfiguration();
        if (configuration == null) {
            configuration = new TransposerConfiguration();
        }
        try {
            Object sourceElements = this.getSourceDataSet();
            IContext context = transposer.getRulesHandler().getContext();
            TransposerBridgeContext contextWrapper = new TransposerBridgeContext(context, this.getBridgeExecution());
            this.getBridgeExecution().setup(this.getTargetDataSet(), contextWrapper);
            this.initializeContext(contextWrapper);
            transposer.getRulesHandler().setContext((IContext)contextWrapper);
            this.getLogger().info((Object)Messages.bridgeLoggerTransposerRunStepMessage);
            transposer.transpose((Collection)sourceElements, configuration, null, (IProgressMonitor)this.getMonitor());
            if (this.getTargetDataSet() instanceof INormalizableModelScope) {
                ((INormalizableModelScope)this.getTargetDataSet()).normalize();
            }
            transposer.dispose();
            this.getMonitor().worked(1);
            result = Status.OK_STATUS;
        }
        catch (OperationCanceledException operationCanceledException) {
            result = Status.CANCEL_STATUS;
        }
        return result;
    }

    public TransposerBridge<Collection<Object>> getBridge() {
        return (TransposerBridge)super.getBridge();
    }

    public TransposerBridgeExecution getBridgeExecution() {
        return (TransposerBridgeExecution)super.getBridgeExecution();
    }

    public Collection<Object> getSourceDataSet() {
        return (Collection)super.getSourceDataSet();
    }

    public IEditableModelScope getTargetDataSet() {
        return (IEditableModelScope)super.getTargetDataSet();
    }

    protected TransposerConfiguration getTransposerConfiguration() {
        return this._configuration;
    }

    protected int getWorkAmount() {
        return this.getBridge().getWorkAmount((Collection<Object>)this.getSourceDataSet(), this.getTargetDataSet());
    }

    protected void initializeContext(TransposerBridgeContext context_p) {
        Resource resource;
        IEditableModelScope targetScope = this.getTargetDataSet();
        if (targetScope instanceof IPersistentModelScope && (resource = ((IPersistentModelScope)targetScope).getHoldingResource()) != null) {
            ResourceSet rs = resource.getResourceSet();
            context_p.put("TransposerResourceSet", rs);
        }
    }
}

