/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.resourcereuse.emfscheme;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.polarsys.kitalpha.resourcereuse.helper.ResourceReuse;
import org.polarsys.kitalpha.resourcereuse.model.Location;
import org.polarsys.kitalpha.resourcereuse.model.Resource;
import org.polarsys.kitalpha.resourcereuse.model.SearchCriteria;

public class ModelReuseURIConverter
extends ExtensibleURIConverterImpl {
    private static final Logger logger = Logger.getLogger(ModelReuseURIConverter.class);

    public URI normalize(URI uri) {
        String scheme = uri.scheme();
        if (scheme != null && scheme.equals("modelreuse")) {
            try {
                String decodedURI = URLDecoder.decode(uri.toString(), "UTF-8");
                return this.translateReuseURIToPhysicalURI(URI.createURI((String)decodedURI));
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)new Status(4, "org.polarsys.kitalpha.resourcereuse.emfscheme", e.getMessage(), (Throwable)e));
            }
        }
        return super.normalize(uri);
    }

    private SearchCriteria extractCriteria(URI uri) {
        SearchCriteria criteria = new SearchCriteria();
        String[] stringArray = uri.segments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if (segment.startsWith("id=")) {
                criteria.setId(segment.substring(3));
            } else if (segment.startsWith("name=")) {
                criteria.setName(segment.substring(5));
            } else if (segment.startsWith("domain=")) {
                criteria.setDomain(segment.substring(7));
            } else if (segment.startsWith("version=")) {
                criteria.setVersion(segment.substring(7));
            } else if (segment.startsWith("tags=")) {
                String tags = segment.substring(5);
                criteria.getTags().addAll(Arrays.asList(tags.split(",")));
            }
            ++n2;
        }
        return criteria;
    }

    private URI translateReuseURIToPhysicalURI(URI uri) {
        String pathString;
        SearchCriteria criteria = this.extractCriteria(uri);
        Resource[] resources = ResourceReuse.createHelper().getResources(criteria);
        if (resources.length == 0) {
            throw new IllegalStateException("The uri '" + uri.toString() + "' does not matche any resource");
        }
        if (resources.length > 1) {
            logger.warn((Object)new Status(2, "org.polarsys.kitalpha.resourcereuse.emfscheme", "The uri '" + uri.toString() + "' matches several resources, using the first one."));
        }
        Resource resource = resources[0];
        Location location = resource.getProviderLocation();
        boolean useMetadata = this.useMetadata(uri);
        if (useMetadata && resource.getMetadataPath() == null) {
            throw new IllegalStateException("Warning. The resource has no metadata");
        }
        String string = pathString = useMetadata ? resource.getMetadataPath() : resource.getPath();
        if (pathString == null) {
            throw new IllegalStateException("The resource has no path");
        }
        switch (location) {
            case PLATFORM: 
            case TARGET: {
                return URI.createPlatformPluginURI((String)pathString, (boolean)true);
            }
            case WORSPACE: {
                return URI.createPlatformResourceURI((String)pathString, (boolean)true);
            }
        }
        throw new IllegalStateException("Cannot find provider location for resource: " + resource);
    }

    private boolean useMetadata(URI uri) {
        String[] stringArray = uri.segments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String seg = stringArray[n2];
            if ("useMetadata".equals(seg)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

