/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.composer.ui.launch.tabs.widgets.library;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.polarsys.kitalpha.composer.metamodel.allocation.base.File;
import org.polarsys.kitalpha.composer.metamodel.allocation.base.Type;
import org.polarsys.kitalpha.composer.ui.launch.tabs.widgets.library.providers.LibraryItem;
import org.polarsys.kitalpha.resourcereuse.model.Resource;

public class ConflictValidator {
    Iterator<Object> iterator;
    boolean value = true;
    private Text description;
    private List<Resource> resources;
    private ResourceSet set = new ResourceSetImpl();
    private static ConflictValidator instance;

    public static ConflictValidator getInstance() {
        if (instance == null) {
            instance = new ConflictValidator();
        }
        return instance;
    }

    private ConflictValidator() {
    }

    public Text getWidget(Composite container) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        Group group = new Group(container, 0);
        group.setText("Selection validation");
        group.setLayout((Layout)new GridLayout(1, true));
        group.setLayoutData((Object)gd);
        this.description = new Text((Composite)group, 586);
        this.description.setEditable(false);
        gd = new GridData(272);
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        gd.minimumHeight = 100;
        this.description.setLayoutData((Object)gd);
        return this.description;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public void setResources(List<Resource> resources) {
        this.resources = resources;
        this.loadResources(resources, true);
    }

    private boolean internalConflict(Object e1, Object e2) {
        boolean result = false;
        if (e1 instanceof LibraryItem && e2 instanceof LibraryItem) {
            LibraryItem i1 = (LibraryItem)e1;
            Resource r1 = i1.getItem();
            ResourceSetImpl set1 = new ResourceSetImpl();
            this.loadResource(r1, (ResourceSet)set1);
            EcoreUtil.resolveAll((ResourceSet)set1);
            LibraryItem i2 = (LibraryItem)e2;
            Resource r2 = i2.getItem();
            ResourceSetImpl set2 = new ResourceSetImpl();
            this.loadResource(r2, (ResourceSet)set2);
            EcoreUtil.resolveAll((ResourceSet)set2);
            result = this.simpleResourceComparison((ResourceSet)set1, (ResourceSet)set2);
            set1.getResources().clear();
            set2.getResources().clear();
        }
        return result;
    }

    private boolean simpleResourceComparison(ResourceSet set1, ResourceSet set2) {
        boolean result = false;
        if (!set1.getResources().isEmpty()) {
            for (org.eclipse.emf.ecore.resource.Resource r0 : set1.getResources()) {
                for (org.eclipse.emf.ecore.resource.Resource r1 : set2.getResources()) {
                    URI uri0 = r0.getURI();
                    URI uri1 = r1.getURI();
                    boolean bl = result = result || uri0.equals(uri1);
                }
            }
        } else {
            result = false;
        }
        return result;
    }

    public void isConflictReverse(LibraryItem item, List<LibraryItem> items) {
        for (LibraryItem i : items) {
            if (i.equals(item) || !i.isConflictWith(item.getItem())) continue;
            i.removeWith(item.getItem());
        }
    }

    public void isConflict(List<LibraryItem> items, LibraryItem item) {
        for (LibraryItem i : items) {
            if (i.equals(item)) continue;
            boolean value = false;
            value = this.internalConflict(i, item);
            if (!value) continue;
            this.searchConflictElements(i, item);
        }
        if (item.isValid()) {
            item.clearErrorsMsg();
        }
    }

    private void searchConflictElements(LibraryItem item1, LibraryItem item2) {
        ResourceSetImpl set = new ResourceSetImpl();
        Resource reuse1 = item1.getItem();
        Resource reuse2 = item2.getItem();
        org.eclipse.emf.ecore.resource.Resource res1 = this.loadResource(reuse1, (ResourceSet)set);
        org.eclipse.emf.ecore.resource.Resource res2 = this.loadResource(reuse2, (ResourceSet)set);
        TreeIterator it1 = res1.getAllContents();
        while (it1.hasNext()) {
            EObject eObj1 = (EObject)it1.next();
            if (!(eObj1 instanceof Type)) continue;
            EObject ref1 = ((Type)eObj1).getReferencedElement();
            TreeIterator it2 = res2.getAllContents();
            while (it2.hasNext()) {
                EObject ref2;
                EObject eObj2 = (EObject)it2.next();
                if (!(eObj2 instanceof Type) || !(ref2 = ((Type)eObj2).getReferencedElement()).equals(ref1)) continue;
                item2.addErrorsMsg(reuse1, "Library :" + reuse2.getName() + "=> The file " + ((File)eObj2.eContainer()).getName() + " reference the same element(s) than the file " + ((File)eObj1.eContainer()).getName() + " in the library " + reuse1.getName());
            }
        }
        set.getResources().clear();
    }

    private List<org.eclipse.emf.ecore.resource.Resource> loadResources(List<Resource> resources_p, boolean clear) {
        if (clear) {
            this.set.getResources().clear();
        }
        for (Resource res : resources_p) {
            this.loadResource(res, this.set);
        }
        return this.set.getResources();
    }

    private org.eclipse.emf.ecore.resource.Resource loadResource(Object resource_p, ResourceSet tempory) {
        Resource resource;
        String path;
        org.eclipse.emf.ecore.resource.Resource res = null;
        if (resource_p instanceof Resource && (path = (resource = (Resource)resource_p).getPath()) != null) {
            IResource wr = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(path));
            URI uri = null;
            uri = wr != null ? URI.createPlatformResourceURI((String)path, (boolean)false) : URI.createPlatformPluginURI((String)path, (boolean)false);
            res = tempory.getResource(uri, true);
        }
        return res;
    }
}

