/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.model.attachment.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.kitalpha.model.attachment.ui.Messages;
import org.polarsys.kitalpha.model.attachment.ui.wizard.AbstractWizardPage;
import org.polarsys.kitalpha.model.attachment.ui.wizard.ModelPage;
import org.polarsys.kitalpha.model.common.scrutiny.analyzer.ModelScrutinyException;
import org.polarsys.kitalpha.model.common.scrutiny.analyzer.Scrutineer;
import org.polarsys.kitalpha.model.common.scrutiny.interfaces.IScrutinize;
import org.polarsys.kitalpha.model.common.scrutiny.registry.ModelScrutinyRegistry;
import org.polarsys.kitalpha.model.common.share.resource.loading.LoadResource;
import org.polarsys.kitalpha.model.common.share.ui.utilities.ExtensionTreeViewer;
import org.polarsys.kitalpha.model.common.share.ui.utilities.vp.providers.ViewpointTreeLabelProvider;
import org.polarsys.kitalpha.model.common.share.ui.utilities.vp.providers.ViewpointTreeProvider;
import org.polarsys.kitalpha.model.common.share.ui.utilities.vp.tree.IViewpointTreeDescription;
import org.polarsys.kitalpha.model.common.share.ui.utilities.vp.tree.ViewpointTreeContainer;

public class ViewpointPage
extends AbstractWizardPage {
    public static final String NAME = "vppage";
    private Label label;
    private ExtensionTreeViewer treeViewer;
    public ViewpointTreeContainer analysisResult;

    protected ViewpointPage() {
        super(NAME);
        this.setTitle(Messages.wizard_page_title1);
        this.setDescription(Messages.wizard_page_description1);
        this.setPageComplete(false);
    }

    @Override
    protected void createControls(Composite parent) {
        this.label = new Label(parent, 0);
        GridData ld = new GridData(768);
        ld.horizontalSpan = 3;
        this.label.setLayoutData((Object)ld);
        Label label = new Label(parent, 0);
        label.setText(Messages.wizard_page_label2);
        ld = new GridData(768);
        ld.horizontalSpan = 3;
        label.setLayoutData((Object)ld);
        this.treeViewer = new ExtensionTreeViewer(parent, 2818);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 3;
        this.treeViewer.getControl().setLayoutData((Object)gd);
        this.treeViewer.setContentProvider((IContentProvider)new ViewpointTreeProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ViewpointTreeLabelProvider());
        this.treeViewer.setComparator(new ViewerComparator());
        this.treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ViewpointPage.this.setPageComplete(ViewpointPage.this.analysisResult != null && !ViewpointPage.this.analysisResult.getSelectedUris().isEmpty());
            }
        });
    }

    public void setVisible(boolean visible) {
        ModelPage page = (ModelPage)this.getWizard().getPage("modelpage");
        this.label.setText(NLS.bind((String)Messages.wizard_page_label3, (Object)page.getSourceFile().getFullPath().toString()));
        if (visible) {
            final IFile targetFile = page.getTargetFile();
            final IFile sourceFile = page.getSourceFile();
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        try {
                            monitor.beginTask(Messages.wizard_page_label4, 10);
                            monitor.worked(1);
                            Set targetViewpointIds = ViewpointPage.this.getViewpointIds(targetFile);
                            monitor.worked(3);
                            ModelScrutinyRegistry.RegistryElement registry = ViewpointPage.this.getRegistry(sourceFile);
                            IScrutinize next = (IScrutinize)registry.getFinders().iterator().next();
                            ViewpointPage.this.analysisResult = (ViewpointTreeContainer)next.getAnalysisResult();
                            monitor.worked(3);
                            ViewpointPage.this.removeDescriptions(ViewpointPage.this.analysisResult.getRoots(), targetViewpointIds);
                            monitor.worked(3);
                            Thread.sleep(2000L);
                        }
                        catch (Throwable e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            try {
                this.getContainer().run(false, false, op);
                this.treeViewer.setInput((Object)this.analysisResult);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                Throwable realException = e.getTargetException();
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.error_dialog_title, (String)realException.getMessage());
            }
        }
        super.setVisible(visible);
    }

    private void removeDescriptions(Collection<IViewpointTreeDescription> elts, Set<String> ids) {
        for (IViewpointTreeDescription child : new ArrayList<IViewpointTreeDescription>(elts)) {
            if (ids.contains(child.getViewpointId())) {
                elts.remove(child);
                continue;
            }
            this.removeDescriptions(child.getChildren(), ids);
        }
    }

    private Set<String> getViewpointIds(IFile airdResource) throws ModelScrutinyException {
        ModelScrutinyRegistry.RegistryElement registryElement = this.getRegistry(airdResource);
        return this.getViewpointIds(registryElement);
    }

    private ModelScrutinyRegistry.RegistryElement getRegistry(IFile airdResource) throws ModelScrutinyException {
        Resource resource = new LoadResource(airdResource).getResource();
        ModelScrutinyRegistry analysis = Scrutineer.startScrutiny((Resource)resource);
        ModelScrutinyRegistry.RegistryElement registryElement = analysis.getRegistryElement("org.polarsys.kitalpha.model.common.scrutiny.contrib.scrutiny.viewpoints");
        return registryElement;
    }

    private Set<String> getViewpointIds(ModelScrutinyRegistry.RegistryElement registryElement) {
        HashSet<String> ids = new HashSet<String>();
        IScrutinize next = (IScrutinize)registryElement.getFinders().iterator().next();
        ViewpointTreeContainer analysisResult = (ViewpointTreeContainer)next.getAnalysisResult();
        this.collectViewpointIds(ids, analysisResult.getRoots());
        return ids;
    }

    private void collectViewpointIds(HashSet<String> ids, Collection<IViewpointTreeDescription> elts) {
        for (IViewpointTreeDescription desc : elts) {
            ids.add(desc.getViewpointId());
            this.collectViewpointIds(ids, desc.getChildren());
        }
    }
}

