/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.gen.business.core.sirius.util.diagram;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.image.ImageFileFormat;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.util.EclipseUtil;
import org.eclipse.sirius.common.tools.api.util.FileUtil;
import org.eclipse.sirius.diagram.business.api.refresh.CanonicalSynchronizer;
import org.eclipse.sirius.diagram.business.api.refresh.CanonicalSynchronizerFactory;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.internal.decoration.SiriusDecoratorProvider;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.dialect.ExportFormat;
import org.eclipse.sirius.ui.tools.api.actions.export.ExportAction;
import org.eclipse.sirius.ui.tools.api.actions.export.IAfterExport;
import org.eclipse.sirius.ui.tools.api.actions.export.IAroundExport;
import org.eclipse.sirius.ui.tools.api.actions.export.IBeforeExport;
import org.eclipse.sirius.ui.tools.api.actions.export.SizeTooLargeException;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.kitalpha.doc.gen.business.core.internal.GenDocDiagramEditPartService;
import org.polarsys.kitalpha.doc.gen.business.core.util.DocGenHtmlUtil;
import org.polarsys.kitalpha.doc.gen.business.core.util.SiriusHelper;

public class GenDocDiagramExportAction
extends ExportAction {
    private static final String EXPORT_DIAGRAMS_AS_IMAGES_ACTION_DEFAULT_DIAGRAM_NAME = "DiagramWithoutName";
    private boolean exportToHtml;
    private Collection<DRepresentation> dRepresentationsToExportAsImage;
    private org.eclipse.sirius.common.tools.api.resource.ImageFileFormat imageFormat;
    private IPath outputPath;
    private Session session;

    public GenDocDiagramExportAction(Session session, Collection<DRepresentation> dRepresentationsToExportAsImage, IPath outputPath, org.eclipse.sirius.common.tools.api.resource.ImageFileFormat imageFormat, boolean exportToHtml) {
        super(session, dRepresentationsToExportAsImage, outputPath, imageFormat, exportToHtml, true);
        this.exportToHtml = exportToHtml;
        this.dRepresentationsToExportAsImage = dRepresentationsToExportAsImage;
        this.imageFormat = imageFormat;
        this.outputPath = outputPath;
        this.session = session;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    protected void createImageFiles(IProgressMonitor monitor) {
        block20: {
            beforeContributors = EclipseUtil.getExtensionPlugins(IBeforeExport.class, (String)"org.eclipse.sirius.ui.exportRepresentationsAsImagesExtension", (String)"class");
            aroundContributors = EclipseUtil.getExtensionPlugins(IAroundExport.class, (String)"org.eclipse.sirius.ui.exportRepresentationsAsImagesExtension", (String)"class");
            afterContributors = EclipseUtil.getExtensionPlugins(IAfterExport.class, (String)"org.eclipse.sirius.ui.exportRepresentationsAsImagesExtension", (String)"class");
            exportFormat = new ExportFormat(this.exportToHtml != false ? ExportFormat.ExportDocumentFormat.HTML : ExportFormat.ExportDocumentFormat.NONE, this.imageFormat);
            imageFileExtension = exportFormat.getImageFormat().getName().toLowerCase();
            for (IBeforeExport iBeforeExport : beforeContributors) {
                iBeforeExport.beforeExportAction(this.dRepresentationsToExportAsImage, this.outputPath, imageFileExtension);
            }
            if (!aroundContributors.isEmpty()) {
                for (IAroundExport iAroundExport : aroundContributors) {
                    iAroundExport.aroundExportAction(this.dRepresentationsToExportAsImage, this.outputPath, imageFileExtension);
                }
            } else {
                errorDuringExport = false;
                messageException = new ArrayList<CoreException>();
                shell = Display.getCurrent().getActiveShell();
                try {
                    for (DRepresentation representation : this.dRepresentationsToExportAsImage) {
                        block19: {
                            if (this.outputPath.toFile().isDirectory()) {
                                representationName = DocGenHtmlUtil.getValidFileName(representation.getName());
                                filePath = this.getFilePath(this.outputPath, representationName, imageFileExtension);
                            } else if (this.outputPath.getFileExtension() != null) {
                                imageFileExtensionLowerCase = this.outputPath.getFileExtension().toLowerCase();
                                filePath = this.outputPath.removeFileExtension().addFileExtension(imageFileExtensionLowerCase);
                            } else {
                                filePath = this.outputPath;
                            }
                            for (IBeforeExport contributor : beforeContributors) {
                                contributor.beforeExportRepresentationAsImage((EObject)representation, filePath);
                            }
                            if (DialectUIManager.INSTANCE.canHandle(representation)) {
                                try {
                                    this.export(representation, this.session, filePath, exportFormat, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)7));
                                }
                                catch (CoreException exception) {
                                    if (!(exception instanceof SizeTooLargeException)) break block19;
                                    errorDuringExport = true;
                                    messageException.add(exception);
                                }
                            }
                        }
                        for (IBeforeExport contributor : afterContributors) {
                            contributor.afterExportRepresentationAsImage((EObject)representation, filePath);
                        }
                    }
                }
                finally {
                    if (!errorDuringExport) break block20;
                    messageExceptionForDialog = new StringBuilder();
                    messageExceptionForDialog.append("One or more representations could not be exported because they are too large: ");
                    ** for (thr : messageException)
                }
lbl-1000:
                // 1 sources

                {
                    messageExceptionForDialog.append("\n");
                    messageExceptionForDialog.append(" - ");
                    messageExceptionForDialog.append(thr.getMessage());
                    continue;
                }
lbl59:
                // 1 sources

                MessageDialog.openError((Shell)shell, (String)"Image export impossible", (String)messageExceptionForDialog.toString());
                SiriusPlugin.getDefault().error("Error while export representation to image", (Throwable)new SizeTooLargeException((IStatus)new Status(4, "org.eclipse.sirius", messageExceptionForDialog.toString())));
            }
        }
        for (IAfterExport iAfterExport : afterContributors) {
            iAfterExport.afterExportAction();
        }
    }

    private void export(DRepresentation representation, Session session, IPath path, ExportFormat format, IProgressMonitor monitor) throws SizeTooLargeException {
        boolean exportToHtml = format.getDocumentFormat().equals((Object)ExportFormat.ExportDocumentFormat.HTML);
        String imageFileExtension = format.getImageFormat().getName();
        IPath correctPath = this.getRealPath(path, exportToHtml);
        Shell shell = new Shell();
        try {
            Collection data = session.getServices().getCustomData("GMF_DIAGRAMS", (EObject)representation);
            for (EObject dataElement : data) {
                if (!(dataElement instanceof Diagram)) continue;
                Diagram diagram = (Diagram)dataElement;
                CanonicalSynchronizer canonicalSynchronizer = CanonicalSynchronizerFactory.INSTANCE.createCanonicalSynchronizer(diagram);
                canonicalSynchronizer.storeViewsToArrange(false);
                canonicalSynchronizer.synchronize();
                GenDocDiagramEditPartService tool = new GenDocDiagramEditPartService();
                if (exportToHtml) {
                    tool.exportToHtml();
                }
                boolean isActivateSiriusDecorationPrevious = SiriusDecoratorProvider.isActivateSiriusDecoration();
                SiriusDecoratorProvider.setActivateSiriusDecoration((boolean)true);
                DiagramEditPart diagramEditPart = tool.createDiagramEditPart(diagram, shell, PreferencesHint.USE_DEFAULTS);
                ImageFileFormat resolveImageFormat = ImageFileFormat.resolveImageFormat((String)imageFileExtension);
                SiriusHelper.initAutoScaling(tool, diagramEditPart);
                try {
                    diagramEditPart.getRoot().refresh();
                    diagramEditPart.getFigure().validate();
                    diagramEditPart.getRoot().refresh();
                    diagramEditPart.getRoot().getViewer().flush();
                    tool.copyToImage(diagramEditPart, correctPath, resolveImageFormat, monitor);
                    if (!new File(correctPath.toOSString()).exists()) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.sirius", MessageFormat.format(Messages.DiagramDialectUIServices_exportedDiagramImageCreationError, correctPath)));
                    }
                }
                catch (CoreException exception) {
                    if (exception instanceof SizeTooLargeException) {
                        throw (SizeTooLargeException)exception;
                    }
                    if (exception.getStatus() != null && exception.getStatus().getException() instanceof SWTException) {
                        throw new SizeTooLargeException((IStatus)new Status(4, "org.eclipse.sirius", representation.getName()));
                    }
                    SiriusPlugin.getDefault().error(MessageFormat.format(Messages.DiagramDialectUIServices_exportedDiagramImageCreationError, correctPath), (Throwable)exception);
                    SiriusDecoratorProvider.setActivateSiriusDecoration((boolean)isActivateSiriusDecorationPrevious);
                    diagramEditPart.deactivate();
                    diagramEditPart.getViewer().flush();
                    diagramEditPart.getViewer().getEditDomain().getCommandStack().flush();
                    diagramEditPart.getViewer().getControl().dispose();
                    ((DiagramEditDomain)diagramEditPart.getViewer().getEditDomain()).removeViewer(diagramEditPart.getViewer());
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    try {
                        throw new SizeTooLargeException((IStatus)new Status(4, "org.eclipse.sirius", representation.getName()));
                    }
                    catch (Throwable throwable) {
                        SiriusDecoratorProvider.setActivateSiriusDecoration((boolean)isActivateSiriusDecorationPrevious);
                        diagramEditPart.deactivate();
                        diagramEditPart.getViewer().flush();
                        diagramEditPart.getViewer().getEditDomain().getCommandStack().flush();
                        diagramEditPart.getViewer().getControl().dispose();
                        ((DiagramEditDomain)diagramEditPart.getViewer().getEditDomain()).removeViewer(diagramEditPart.getViewer());
                        throw throwable;
                    }
                }
                SiriusDecoratorProvider.setActivateSiriusDecoration((boolean)isActivateSiriusDecorationPrevious);
                diagramEditPart.deactivate();
                diagramEditPart.getViewer().flush();
                diagramEditPart.getViewer().getEditDomain().getCommandStack().flush();
                diagramEditPart.getViewer().getControl().dispose();
                ((DiagramEditDomain)diagramEditPart.getViewer().getEditDomain()).removeViewer(diagramEditPart.getViewer());
            }
        }
        catch (Throwable throwable) {
            Display.getCurrent().asyncExec(new Runnable(shell){
                private final /* synthetic */ Shell val$shell;
                {
                    this.val$shell = shell;
                }

                @Override
                public void run() {
                    this.val$shell.dispose();
                }
            });
            throw throwable;
        }
        Display.getCurrent().asyncExec(new /* invalid duplicate definition of identical inner class */);
    }

    private IPath getRealPath(IPath path, boolean exportToHtml) {
        if (exportToHtml) {
            return path.removeFileExtension().addFileExtension("html");
        }
        return path;
    }

    private IPath getFilePath(IPath destinationFolder, String providedFilename, String extension) {
        String filename = null;
        filename = providedFilename.length() == 0 ? new String(EXPORT_DIAGRAMS_AS_IMAGES_ACTION_DEFAULT_DIAGRAM_NAME) : providedFilename;
        StringBuffer file = new StringBuffer(filename).append(".").append(extension);
        String filenameWithExtension = this.validFilename(file.toString());
        IPath filePath = destinationFolder.append(filenameWithExtension);
        return filePath;
    }

    private String validFilename(String filename) {
        FileUtil util = new FileUtil(filename);
        if (util.isValid()) {
            return filename;
        }
        return util.getValidFilename();
    }
}

