/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.transposer.transformation.emf.resource;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.polarsys.kitalpha.transposer.TransposerCorePlugin;
import org.polarsys.kitalpha.transposer.transformation.emf.TransposerEMFPlugin;

public class ResourceUtil {
    public static final String TRANSPOSER_RESOURCE_SET = "TransposerResourceSet";

    public static List<EObject> loadURI(URI uri_p, ResourceSet resourceSet_p) {
        Resource resource = resourceSet_p.getResource(uri_p, true);
        if (resource.isLoaded() && resource.getContents().size() > 0) {
            return resource.getContents();
        }
        return Collections.emptyList();
    }

    public static List<EObject> loadURI(String uriPath_p, ResourceSet resourceSet_p) {
        URI uri = URI.createURI((String)uriPath_p);
        return ResourceUtil.loadURI(uri, resourceSet_p);
    }

    public static List<EObject> loadPlatformResourceURI(String uriPath_p, ResourceSet resourceSet_p) {
        URI uri = URI.createPlatformResourceURI((String)uriPath_p, (boolean)true);
        return ResourceUtil.loadURI(uri, resourceSet_p);
    }

    public static List<EObject> loadPlatformPluginURI(String uriPath_p, ResourceSet resourceSet_p) {
        URI uri = URI.createPlatformPluginURI((String)uriPath_p, (boolean)true);
        return ResourceUtil.loadURI(uri, resourceSet_p);
    }

    public static void saveURI(EObject modelTop, String uriPath_p, ResourceSet resourceSet_p) {
        URI uri = URI.createURI((String)uriPath_p);
        ResourceUtil.saveURI(modelTop, uri, resourceSet_p);
    }

    public static void saveResource(Resource res_p) {
        try {
            res_p.save(null);
        }
        catch (Exception e) {
            String message = "Error happens when saving " + res_p.getURI().toString();
            TransposerEMFPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.kitalpha.transposer.transformation.emf", message, (Throwable)e));
        }
    }

    public static void saveURI(EObject modelTop, URI uri_p, ResourceSet resourceSet_p) {
        Resource outputResource = resourceSet_p.createResource(uri_p);
        outputResource.getContents().add((Object)modelTop);
        ResourceUtil.saveResource(outputResource);
    }

    public static void createResource(ResourceSet resourceSet_p, String resourcePath_p, EObject root_p, boolean saveOnCreation_p) {
        Resource res = resourceSet_p.createResource(URI.createURI((String)resourcePath_p));
        if (root_p != null) {
            res.getContents().add((Object)root_p);
        }
        if (saveOnCreation_p) {
            try {
                res.save(new HashMap());
            }
            catch (Exception e) {
                TransposerCorePlugin.getDefault().logError("org.polarsys.kitalpha.transposer.transformation.emf", "Error during save of : " + resourcePath_p, (Throwable)e);
            }
        }
    }
}

