/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.richtext.nebula.widget;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.nebula.widgets.richtext.RichTextEditorConfiguration;
import org.polarsys.kitalpha.richtext.nebula.widget.MDERichTextConstants;

public class MDENebulaRichTextConfiguration
extends RichTextEditorConfiguration {
    private final Map<String, List<String>> allItems = new LinkedHashMap<String, List<String>>();
    private final Collection<String> removedItems = new HashSet<String>();
    private final StringBuffer toolbarGroup = new StringBuffer();

    public MDENebulaRichTextConfiguration() {
        this.setOption("customConfig", MDERichTextConstants.DEFAUTL_CUSTOM_CONFIG);
        this.setOption("removeButtons", "");
    }

    public void createToolbar() {
        this.initializeMDEToolbarGroups();
    }

    private void initializeMDEToolbarGroups() {
        this.setOption("toolbarGroups", "[" + this.buildToolbarConfiguration() + "]");
    }

    private String buildToolbarConfiguration() {
        this.toolbarGroup.setLength(0);
        for (Map.Entry<String, List<String>> e : this.allItems.entrySet()) {
            String group = e.getKey();
            List<String> groupItems = e.getValue();
            this.toolbarGroup.append("{ ").append("name:'").append(group).append("'");
            if (!groupItems.isEmpty()) {
                int size = groupItems.size();
                this.toolbarGroup.append(", groups: [ ");
                for (String gi : groupItems) {
                    this.toolbarGroup.append("'").append(gi).append("'");
                    if (groupItems.indexOf(gi) == size - 1) continue;
                    this.toolbarGroup.append(",");
                }
                this.toolbarGroup.append("]");
            }
            this.toolbarGroup.append("},");
        }
        return this.toolbarGroup.toString();
    }

    public void initializeToolbarItem(String toolbar, String ... items) {
        if (!this.allItems.containsKey(toolbar)) {
            this.allItems.put(toolbar, new ArrayList());
            this.doAddItems(toolbar, items);
        } else {
            this.doAddItems(toolbar, items);
        }
    }

    private void doAddItems(String toolbar, String ... items) {
        String[] stringArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            this.allItems.get(toolbar).add(item);
            ++n2;
        }
    }

    public void removeToolbarItems(String ... itemNames) {
        String[] stringArray = itemNames;
        int n = itemNames.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            this.removedItems.add(item);
            ++n2;
        }
        StringBuilder builder = new StringBuilder("'");
        int size = this.removedItems.size();
        int i = 0;
        for (String removed : this.removedItems) {
            builder.append(removed);
            if (i != size - 1) {
                builder.append(",");
            }
            ++i;
        }
        builder.append("'");
        this.setOption("removeButtons", builder.toString());
    }

    public void setToolbarPosition(String postion) {
        Assert.isNotNull((Object)postion);
        Assert.isLegal((postion.equals("top") || postion.equals("bottom") ? 1 : 0) != 0);
        this.setOption("toolbarLocation", postion);
    }
}

