/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.vp.componentsample.wizard.project.wizard;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ui.tools.internal.operations.SemanticResourceAdditionOperation;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.polarsys.kitalpha.ad.integration.sirius.listeners.SiriusHelper;
import org.polarsys.kitalpha.ad.services.manager.ViewpointActivationException;
import org.polarsys.kitalpha.ad.services.manager.ViewpointManager;
import org.polarsys.kitalpha.ad.viewpoint.predicate.exceptions.EvaluationException;
import org.polarsys.kitalpha.vp.componentsample.ComponentSample.ComponentModel;
import org.polarsys.kitalpha.vp.componentsample.ComponentSample.ComponentSampleFactory;
import org.polarsys.kitalpha.vp.componentsample.wizard.project.Activator;
import org.polarsys.kitalpha.vp.componentsample.wizard.project.wizard.NewProjectPage;

public class NewComponentsampleProject
extends Wizard
implements INewWizard {
    private static final ILog LOGGER = Activator.getDefault().getLog();
    private IWizardPage page;

    public NewComponentsampleProject() {
        this.setNeedsProgressMonitor(true);
        this.setDefaultPageImageDescriptor(Activator.getDefault().getImageRegistry().getDescriptor("componentsample.icon"));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public String getWindowTitle() {
        return "New Component sample Project";
    }

    public void addPages() {
        this.page = new NewProjectPage("New Component sample Project");
        this.addPage(this.page);
    }

    public boolean performFinish() {
        return this.createProject();
    }

    private boolean createProject() {
        NewProjectPage _page = (NewProjectPage)this.page;
        final String projectName = _page.getProjectName();
        final String modelName = _page.getModelName();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        final IProject csProject = root.getProject(projectName);
        if (csProject != null && !csProject.exists()) {
            try {
                WorkspaceModifyOperation projectCreation = new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                        monitor.beginTask("Project Creation", 1);
                        csProject.create(monitor);
                        csProject.open(monitor);
                    }
                };
                this.getContainer().run(false, false, (IRunnableWithProgress)projectCreation);
                WorkspaceModifyOperation createModels = new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                        ResourceSetImpl resourceSet = new ResourceSetImpl();
                        URI fileURI = NewComponentsampleProject.this.buildPlatformResourceURI(projectName, modelName, "componentsample");
                        Resource resource = resourceSet.createResource(fileURI);
                        ComponentModel componentModel = ComponentSampleFactory.eINSTANCE.createComponentModel();
                        componentModel.setName(modelName);
                        resource.getContents().add((Object)componentModel);
                        try {
                            resource.save(Collections.emptyMap());
                            URI representationURI = NewComponentsampleProject.this.buildPlatformResourceURI(projectName, modelName, "aird");
                            Session session = SessionManager.INSTANCE.getSession(representationURI, (IProgressMonitor)new NullProgressMonitor());
                            HashSet<URI> uris = new HashSet<URI>();
                            uris.add(fileURI);
                            HashSet<Session> sessions = new HashSet<Session>();
                            sessions.add(session);
                            SemanticResourceAdditionOperation addModelSession = new SemanticResourceAdditionOperation(sessions, uris);
                            NewComponentsampleProject.this.getContainer().run(false, false, (IRunnableWithProgress)addModelSession);
                            if (session != null && !session.isOpen()) {
                                session.save((IProgressMonitor)new NullProgressMonitor());
                                session.open(monitor);
                            }
                            NewComponentsampleProject.this.referenceComponentSample(session);
                        }
                        catch (IOException e) {
                            LOGGER.log((IStatus)new Status(4, "org.polarsys.kitalpha.vp.componentsample.wizard.project", e.getMessage(), (Throwable)e));
                        }
                    }
                };
                this.getContainer().run(false, false, (IRunnableWithProgress)createModels);
            }
            catch (InvocationTargetException invocationTargetException) {
                return false;
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        return true;
    }

    private URI buildPlatformResourceURI(String projectName, String modelName, String extension) {
        StringBuilder tmp = new StringBuilder();
        tmp.append(projectName).append("/").append(modelName).append(".").append(extension);
        return URI.createPlatformResourceURI((String)tmp.toString(), (boolean)false);
    }

    private void referenceComponentSample(Session session) {
        if (session != null) {
            final ViewpointManager viewpointManager = SiriusHelper.getViewpointManager((Session)session);
            RecordingCommand ref = new RecordingCommand(session.getTransactionalEditingDomain()){

                protected void doExecute() {
                    try {
                        if (!viewpointManager.isReferenced("org.polarsys.kitalpha.vp.componentsample")) {
                            viewpointManager.reference("org.polarsys.kitalpha.vp.componentsample");
                        }
                    }
                    catch (ViewpointActivationException e) {
                        NewComponentsampleProject.this.log("Can not reference viewpoint", "org.polarsys.kitalpha.vp.componentsample", e);
                    }
                    catch (EvaluationException e) {
                        NewComponentsampleProject.this.log("Can not evaluate predicate for viewpoint", "org.polarsys.kitalpha.vp.componentsample", e);
                    }
                }
            };
            session.getTransactionalEditingDomain().getCommandStack().execute((Command)ref);
        }
    }

    private void log(String message, String vpid, Throwable e) {
        Status status = new Status(4, "org.polarsys.kitalpha.vp.componentsample.wizard.project", String.valueOf(message) + ": " + vpid, e);
        Activator.getDefault().getLog().log((IStatus)status);
    }
}

