/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.pdt.introspector.core.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ifeature.IFeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeatureImport;
import org.eclipse.pde.internal.core.ifeature.IFeatureInfo;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.core.ifeature.IFeatureURL;
import org.eclipse.pde.internal.core.ifeature.IFeatureURLElement;
import org.eclipse.pde.internal.core.util.VersionUtil;
import org.osgi.framework.Version;
import org.polarsys.kitalpha.pdt.introspector.core.IntrospectionContext;
import org.polarsys.kitalpha.pdt.introspector.core.comparators.FeatureDependenciesComparator;
import org.polarsys.kitalpha.pdt.introspector.core.comparators.FeatureInclusionsComparator;
import org.polarsys.kitalpha.pdt.introspector.core.comparators.PluginFeatureDependenciesComparator;
import org.polarsys.kitalpha.pdt.introspector.core.exceptions.IntrospectionExceptions;
import org.polarsys.kitalpha.pdt.introspector.core.services.Helpers;
import org.polarsys.kitalpha.pdt.introspector.core.services.PackageServices;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.Feature;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.FeatureDependencies;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.FeatureDependency;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.FeatureInclusion;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.FeatureInclusions;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.FeaturePluginDependencies;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.FeatureToPluginDependency;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.IncludedPlugins;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.MatchRule;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.PlatformFactory;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.Plugin;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.Repository;

public class FeatureServices {
    private static Feature createFeature(org.eclipse.pde.internal.core.feature.Feature featureEntry, IntrospectionContext introContext, Repository currentRepository) {
        String copyrigthNotice = "";
        String licenseAgreement = "";
        PlatformFactory factory = PlatformFactory.eINSTANCE;
        Feature currentFeature = factory.createFeature();
        Version featureVersion = new Version(featureEntry.getVersion());
        String qualifier = featureVersion.getQualifier();
        int qualifierSize = qualifier.length();
        boolean qualifierMatch = introContext.isQualifierMatch();
        String version = Helpers.controlVersionLabel(featureEntry.getVersion(), qualifierMatch, qualifierSize);
        currentFeature.setFeatureDependencies(factory.createFeatureDependencies());
        currentFeature.setFeatureInclusions(factory.createFeatureInclusions());
        currentFeature.setPluginDependencies(factory.createFeaturePluginDependencies());
        currentFeature.setIncludedPlugins(factory.createIncludedPlugins());
        currentFeature.setId(featureEntry.getId());
        currentFeature.setVersion(version);
        IFeatureInfo featureInfo32 = featureEntry.getFeatureInfo(1);
        if (featureInfo32 != null) {
            copyrigthNotice = featureInfo32.getDescription();
        }
        if (copyrigthNotice != null) {
            currentFeature.setCopyrightNotice(copyrigthNotice);
        } else {
            currentFeature.setCopyrightNotice(Helpers.UNDEFINED_STRING);
        }
        IFeatureInfo featureInfo = featureEntry.getFeatureInfo(0);
        String description = null;
        if (featureInfo != null) {
            description = featureInfo.getDescription();
        }
        if (description != null) {
            currentFeature.setFeatureDescription(description);
        } else {
            currentFeature.setFeatureDescription(Helpers.UNDEFINED_STRING);
        }
        IFeatureInfo featureInfo2 = featureEntry.getFeatureInfo(2);
        if (featureInfo2 != null) {
            licenseAgreement = featureInfo2.getDescription();
        }
        if (licenseAgreement != null) {
            currentFeature.setLicenseAgreement(licenseAgreement);
        } else {
            currentFeature.setLicenseAgreement(Helpers.UNDEFINED_STRING);
        }
        String providerName = featureEntry.getFeature().getProviderName();
        if (licenseAgreement != null) {
            currentFeature.setProvider(providerName);
        } else {
            currentFeature.setProvider(Helpers.UNDEFINED_STRING);
        }
        IFeatureURL url = featureEntry.getFeature().getURL();
        IFeatureURLElement[] discoveries = null;
        if (url != null) {
            discoveries = url.getDiscoveries();
        }
        if (discoveries != null) {
            currentFeature.setSitesToVisit(discoveries.toString());
        } else {
            currentFeature.setSitesToVisit(Helpers.UNDEFINED_STRING);
        }
        return currentFeature;
    }

    private static void createFeatureDependenciesAndInclusions(org.eclipse.pde.internal.core.feature.Feature featureEntry, IFeatureModel featureDescription, IntrospectionContext introContext, Repository currentRepository) {
        IFeatureChild[] includedFeatures;
        IFeaturePlugin[] includedEclipsePlugins;
        List<Plugin> pluginsWithGivenID;
        int n;
        IFeatureImport[] imports;
        FeatureDependencies featureDependenciesFolder = null;
        IncludedPlugins includedPluginFolder = null;
        EList includedPlugins = null;
        EList featureDependencies = null;
        FeaturePluginDependencies pluginDependenciesFolder = null;
        EList pluginDependencies = null;
        String currentFeatureIDAndVersion = String.valueOf(featureEntry.getId()) + "_v_" + featureEntry.getVersion();
        boolean qualifierMatch = introContext.isQualifierMatch();
        Version featureVersion = new Version(featureEntry.getVersion());
        String qualifier = featureVersion.getQualifier();
        int qualifierSize = qualifier.length();
        String id = Helpers.controlVersionLabel(currentFeatureIDAndVersion, qualifierMatch, qualifierSize);
        Feature introspectionFeature = introContext.getFeatureId_Feature().get(id);
        FeatureInclusions featureInclusionsFolder = null;
        if (introspectionFeature.getFeatureInclusions() != null) {
            featureInclusionsFolder = introspectionFeature.getFeatureInclusions();
        }
        EList featureInclusions = featureInclusionsFolder.getFeatureInclusions();
        if (introspectionFeature != null) {
            includedPluginFolder = introspectionFeature.getIncludedPlugins();
        }
        if (includedPluginFolder != null) {
            includedPlugins = includedPluginFolder.getIncludedPlugins();
        }
        if (introspectionFeature != null) {
            featureDependenciesFolder = introspectionFeature.getFeatureDependencies();
            pluginDependenciesFolder = introspectionFeature.getPluginDependencies();
        }
        if (featureDependenciesFolder != null) {
            featureDependencies = featureDependenciesFolder.getFeatureDependencies();
        }
        if (pluginDependenciesFolder != null) {
            pluginDependencies = pluginDependenciesFolder.getPluginDependencies();
        }
        if ((imports = featureDescription.getFeature().getImports()) != null) {
            IFeatureImport[] iFeatureImportArray = imports;
            n = imports.length;
            int n2 = 0;
            while (n2 < n) {
                MatchRule currentMatchRule;
                IFeatureImport _import = iFeatureImportArray[n2];
                String requiredObjectID = _import.getId();
                int type = _import.getType();
                if (type == 1) {
                    List<Feature> availableFeatures = introContext.getAllFeaturesWithGivenID(requiredObjectID);
                    Feature requiredFeatureModel = null;
                    if (availableFeatures != null) {
                        int i = availableFeatures.size() - 1;
                        while (i >= 0) {
                            requiredFeatureModel = availableFeatures.get(i);
                            boolean compare = VersionUtil.compare((String)featureEntry.getId(), (String)featureEntry.getVersion(), (String)requiredObjectID, (String)requiredFeatureModel.getVersion(), (int)_import.getMatch());
                            if (compare) break;
                            --i;
                        }
                    }
                    if (requiredFeatureModel != null) {
                        FeatureDependency featureDependency = PlatformFactory.eINSTANCE.createFeatureDependency();
                        featureDependency.setTarget(requiredFeatureModel);
                        String featureDependencyVersion = _import.getVersion();
                        featureDependency.setVersion(featureDependencyVersion);
                        int featureDependencyMatchRule = _import.getMatch();
                        currentMatchRule = MatchRule.UNSET;
                        currentMatchRule = FeatureServices.getMatchRule(featureDependencyMatchRule);
                        featureDependency.setMatchRule(currentMatchRule);
                        featureDependencies.add((Object)featureDependency);
                    }
                } else {
                    pluginsWithGivenID = introContext.getAllPluginsWithGivenID(requiredObjectID);
                    Plugin requiredPluginModel = null;
                    if (!pluginsWithGivenID.isEmpty()) {
                        requiredPluginModel = pluginsWithGivenID.get(pluginsWithGivenID.size() - 1);
                        boolean compare = VersionUtil.compare((String)featureEntry.getId(), (String)featureEntry.getVersion(), (String)requiredObjectID, (String)requiredPluginModel.getVersion(), (int)_import.getMatch());
                        if (compare) break;
                    }
                    if (requiredPluginModel != null) {
                        FeatureToPluginDependency featureToPluginDependency = PlatformFactory.eINSTANCE.createFeatureToPluginDependency();
                        featureToPluginDependency.setTarget(requiredPluginModel);
                        String versionToMatch = _import.getVersion();
                        featureToPluginDependency.setVersion(versionToMatch);
                        int versionMatch = _import.getMatch();
                        currentMatchRule = MatchRule.UNSET;
                        currentMatchRule = FeatureServices.getMatchRule(versionMatch);
                        featureToPluginDependency.setMatchRule(currentMatchRule);
                        pluginDependencies.add((Object)featureToPluginDependency);
                    }
                }
                ++n2;
            }
            if (pluginDependencies != null) {
                FeatureServices.sortFeaturePluginDependencies((EList<FeatureToPluginDependency>)pluginDependencies);
            }
            if (featureDependencies != null) {
                FeatureServices.sortFeatureDependencies((EList<FeatureDependency>)featureDependencies);
            }
        }
        IFeaturePlugin[] iFeaturePluginArray = includedEclipsePlugins = featureEntry.getPlugins();
        int n3 = includedEclipsePlugins.length;
        n = 0;
        while (n < n3) {
            IFeaturePlugin iFeaturePlugin = iFeaturePluginArray[n];
            String includedPluginID = iFeaturePlugin.getId();
            pluginsWithGivenID = introContext.getAllPluginsWithGivenID(includedPluginID);
            Plugin includedPlugin = null;
            if (!pluginsWithGivenID.isEmpty()) {
                includedPlugin = pluginsWithGivenID.get(pluginsWithGivenID.size() - 1);
            }
            if (includedPlugin != null) {
                includedPlugins.add(includedPlugin);
            }
            ++n;
        }
        PackageServices.sortPlugins((EList<Plugin>)includedPlugins);
        IFeatureChild[] iFeatureChildArray = includedFeatures = featureEntry.getIncludedFeatures();
        int n4 = includedFeatures.length;
        n3 = 0;
        while (n3 < n4) {
            IFeatureChild iFeatureChild = iFeatureChildArray[n3];
            String includedFeatureID = iFeatureChild.getId();
            Feature includedFeature = null;
            List<Feature> includedFeatures2 = introContext.getAllFeaturesWithGivenID(includedFeatureID);
            if (!includedFeatures2.isEmpty()) {
                includedFeature = includedFeatures2.get(includedFeatures2.size() - 1);
            }
            if (includedFeature != null) {
                FeatureInclusion featureInclusion = PlatformFactory.eINSTANCE.createFeatureInclusion();
                featureInclusion.setIncludedFeature(includedFeature);
                featureInclusion.setOptional(iFeatureChild.isOptional());
                featureInclusion.setVersion(iFeatureChild.getVersion());
                featureInclusions.add((Object)featureInclusion);
            }
            ++n3;
        }
        FeatureServices.sortFeatureInclusions((EList<FeatureInclusion>)featureInclusions);
    }

    private static MatchRule getMatchRule(int featureDependencyMatchRule) {
        MatchRule currentMatchRule;
        switch (featureDependencyMatchRule) {
            case 0: {
                currentMatchRule = MatchRule.UNSET;
                break;
            }
            case 1: {
                currentMatchRule = MatchRule.EQUIVALENT;
                break;
            }
            case 2: {
                currentMatchRule = MatchRule.COMPATIBLE;
                break;
            }
            case 3: {
                currentMatchRule = MatchRule.PERFECT;
                break;
            }
            case 4: {
                currentMatchRule = MatchRule.GREATER_OR_EQUAL;
                break;
            }
            case 5: {
                currentMatchRule = MatchRule.PREFIX;
                break;
            }
            default: {
                currentMatchRule = MatchRule.UNSET;
            }
        }
        return currentMatchRule;
    }

    public static void createFeatures(IntrospectionContext introContext, IProgressMonitor monitor) throws IntrospectionExceptions {
        String filterRegEx;
        List<Object> platformFeatureModels = new ArrayList();
        List<Object> workspaceFeatureModels = new ArrayList();
        HashSet<Object> totalFeatures = new HashSet<Object>();
        Feature currentFeature = null;
        String namedAndVersionnedFeature = "";
        Repository currentRepository = null;
        if (introContext.isVisitPlatform()) {
            platformFeatureModels = Arrays.asList(PDECore.getDefault().getFeatureModelManager().getExternalModels());
            totalFeatures.addAll(platformFeatureModels);
        }
        if (introContext.isVisitWorkspace()) {
            workspaceFeatureModels = Arrays.asList(PDECore.getDefault().getFeatureModelManager().getWorkspaceModels());
            totalFeatures.addAll(workspaceFeatureModels);
        }
        if (monitor != null) {
            monitor.subTask("Creating Features...");
            if (monitor.isCanceled()) {
                throw new IntrospectionExceptions();
            }
        }
        for (IFeatureModel iFeatureModel : totalFeatures) {
            if (monitor != null && monitor.isCanceled()) {
                throw new IntrospectionExceptions();
            }
            filterRegEx = introContext.getFilterRegEx();
            if (!iFeatureModel.getFeature().getId().startsWith(filterRegEx)) continue;
            org.eclipse.pde.internal.core.feature.Feature feature = (org.eclipse.pde.internal.core.feature.Feature)iFeatureModel.getFeature();
            if (feature != null) {
                String id = String.valueOf(feature.getId()) + "_v_" + feature.getVersion();
                Version featureVersion = new Version(feature.getVersion());
                String qualifier = featureVersion.getQualifier();
                int qualifierSize = qualifier.length();
                boolean qualifierMatch = introContext.isQualifierMatch();
                namedAndVersionnedFeature = Helpers.controlVersionLabel(id, qualifierMatch, qualifierSize);
            }
            if (platformFeatureModels.contains(iFeatureModel)) {
                currentRepository = introContext.getRepositoryToSaveHashMap().get("Platform");
            }
            if (workspaceFeatureModels.contains(iFeatureModel)) {
                currentRepository = introContext.getRepositoryToSaveHashMap().get("Workspace");
            }
            if (feature != null && currentRepository != null && !introContext.getFeatureId_Feature_fromOtherModels().containsKey(namedAndVersionnedFeature)) {
                currentFeature = FeatureServices.createFeature(feature, introContext, currentRepository);
                currentRepository.getFeatures().add((Object)currentFeature);
                introContext.addFeature(namedAndVersionnedFeature, currentFeature);
            } else {
                introContext.addFeature(namedAndVersionnedFeature, introContext.getFeatureId_Feature_fromOtherModels().get(namedAndVersionnedFeature));
            }
            if (monitor == null) continue;
            monitor.worked(1);
        }
        if (monitor != null) {
            monitor.subTask("Setting up Features dependencies and inclusions...");
        }
        if (!totalFeatures.isEmpty()) {
            for (IFeatureModel iFeatureModel : totalFeatures) {
                if (monitor != null && monitor.isCanceled()) {
                    throw new IntrospectionExceptions();
                }
                filterRegEx = introContext.getFilterRegEx();
                if (!iFeatureModel.getFeature().getId().startsWith(filterRegEx)) continue;
                org.eclipse.pde.internal.core.feature.Feature featureEntry = (org.eclipse.pde.internal.core.feature.Feature)iFeatureModel.getFeature();
                if (introContext.getFeatureId_Feature_fromOtherModels().containsKey(namedAndVersionnedFeature)) break;
                FeatureServices.createFeatureDependenciesAndInclusions(featureEntry, iFeatureModel, introContext, currentRepository);
                currentRepository.getFeatures().add((Object)currentFeature);
                introContext.addFeature(namedAndVersionnedFeature, currentFeature);
                if (monitor == null) continue;
                monitor.worked(1);
            }
        }
    }

    public static void sortFeatureInclusions(EList<FeatureInclusion> includedFeatures) {
        FeatureInclusion[] includedFeaturesArray = (FeatureInclusion[])includedFeatures.toArray();
        FeatureInclusionsComparator FeatureInclusionsComparator2 = new FeatureInclusionsComparator();
        Arrays.sort(includedFeaturesArray, FeatureInclusionsComparator2);
        includedFeatures.clear();
        FeatureInclusion[] featureInclusionArray = includedFeaturesArray;
        int n = includedFeaturesArray.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureInclusion includedfeature = featureInclusionArray[n2];
            includedFeatures.add((Object)includedfeature);
            ++n2;
        }
    }

    public static void sortFeaturePluginDependencies(EList<FeatureToPluginDependency> pluginDependencies) {
        FeatureToPluginDependency[] includedPluginDependenciesArray = (FeatureToPluginDependency[])pluginDependencies.toArray();
        PluginFeatureDependenciesComparator PluginFeatureDependenciesComparator2 = new PluginFeatureDependenciesComparator();
        Arrays.sort(includedPluginDependenciesArray, PluginFeatureDependenciesComparator2);
        pluginDependencies.clear();
        FeatureToPluginDependency[] featureToPluginDependencyArray = includedPluginDependenciesArray;
        int n = includedPluginDependenciesArray.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureToPluginDependency plugin = featureToPluginDependencyArray[n2];
            pluginDependencies.add((Object)plugin);
            ++n2;
        }
    }

    public static void sortFeatureDependencies(EList<FeatureDependency> featureDependencies) {
        FeatureDependency[] featureDependenciesArray = (FeatureDependency[])featureDependencies.toArray();
        FeatureDependenciesComparator FeatureDependenciesComparator2 = new FeatureDependenciesComparator();
        Arrays.sort(featureDependenciesArray, FeatureDependenciesComparator2);
        featureDependencies.clear();
        FeatureDependency[] featureDependencyArray = featureDependenciesArray;
        int n = featureDependenciesArray.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureDependency feature = featureDependencyArray[n2];
            featureDependencies.add((Object)feature);
            ++n2;
        }
    }
}

