/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.pdt.introspector.core.services;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.emf.common.util.EList;
import org.polarsys.kitalpha.pdt.introspector.core.IntrospectionContext;
import org.polarsys.kitalpha.pdt.introspector.core.services.Helpers;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.AbstractValue;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.BooleanValue;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.ConfigurationElementAttribute;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.ConfigurationElementAttributeInstance;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.ConfigurationElementAttributeKind;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.ConfiguredSchemaElement;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.EclipseElement;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.Extension;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.ExtensionPoint;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.JavaClassValue;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.PlatformFactory;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.SchemaElement;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.StringValue;

public class ExtensionServices {
    public static void createConfiguredSchemaElements(IntrospectionContext introContext, IExtension currentIExtension, ExtensionPoint extensionPoint, Extension extension) {
        ExtensionPoint contributedExtensionPoint = extension.getExtensionPoint();
        IConfigurationElement[] configurationElements = currentIExtension.getConfigurationElements();
        EList extPointElements = extensionPoint.getSchemaElements();
        PlatformFactory platformFactory = PlatformFactory.eINSTANCE;
        IConfigurationElement[] iConfigurationElementArray = configurationElements;
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            String message;
            IConfigurationElement currentIConfigurationElement = iConfigurationElementArray[n2];
            ConfiguredSchemaElement configuredSchemaElement = platformFactory.createConfiguredSchemaElement();
            String name = currentIConfigurationElement.getName();
            configuredSchemaElement.setName(name);
            SchemaElement extensionSchemaElement = extensionPoint.getExtensionSchemaElement();
            if (extensionSchemaElement != null) {
                configuredSchemaElement.setSchemaElement(extensionSchemaElement);
            } else {
                message = "The extension " + extension.getId() + " cannot retrieve the extension shema element on " + extensionPoint.getId();
                Helpers.createErrorForModelElement((EclipseElement)extension, introContext, message, message);
            }
            if (extPointElements != null) {
                for (SchemaElement schemaElement : extPointElements) {
                    if (!schemaElement.getName().equals(currentIConfigurationElement.getName())) continue;
                    ExtensionServices.createSchemaElementAttributesInstance(introContext, configuredSchemaElement, currentIConfigurationElement, schemaElement);
                }
            } else {
                message = "The extension " + extension.getId() + " cannot retrieve the necessary ressources from the related extension point's shema element";
                Helpers.createErrorForModelElement((EclipseElement)extension, introContext, message, message);
            }
            extension.getConfiguredSchemaElement().add((Object)configuredSchemaElement);
            ExtensionServices.createSchemaElementChildren(introContext, currentIConfigurationElement, configuredSchemaElement, (EList<SchemaElement>)extPointElements);
            ExtensionServices.linkToExtensionPointSchemaElement(contributedExtensionPoint, configuredSchemaElement);
            ++n2;
        }
    }

    private static void linkToExtensionPointSchemaElement(ExtensionPoint contributedExtensionPoint, ConfiguredSchemaElement configuredSchemaElement) {
        EList contribuedExtensionPointSchemaElement = contributedExtensionPoint.getSchemaElements();
        for (SchemaElement contributedExtPointSchemaElement : contribuedExtensionPointSchemaElement) {
            if (!contributedExtPointSchemaElement.getName().equalsIgnoreCase(configuredSchemaElement.getName())) continue;
            configuredSchemaElement.setSchemaElement(contributedExtPointSchemaElement);
        }
    }

    private static void createSchemaElementChildren(IntrospectionContext introContext, IConfigurationElement iConfigurationElement, ConfiguredSchemaElement configuredSchemaElement, EList<SchemaElement> extPointElements) {
        PlatformFactory platformFactory = PlatformFactory.eINSTANCE;
        IConfigurationElement[] configurationElementsChildren = iConfigurationElement.getChildren();
        if (configurationElementsChildren.length != 0) {
            IConfigurationElement[] iConfigurationElementArray = configurationElementsChildren;
            int n = configurationElementsChildren.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement currentIConfigurationElement = iConfigurationElementArray[n2];
                ConfiguredSchemaElement configuredSchemaElementChild = platformFactory.createConfiguredSchemaElement();
                SchemaElement currentSchemaElementChild = null;
                for (SchemaElement schemaElement : extPointElements) {
                    if (!schemaElement.getName().equals(currentIConfigurationElement.getName())) continue;
                    currentSchemaElementChild = schemaElement;
                    ExtensionServices.createSchemaElementAttributesInstance(introContext, configuredSchemaElementChild, currentIConfigurationElement, currentSchemaElementChild);
                }
                configuredSchemaElementChild.setName(currentIConfigurationElement.getName());
                configuredSchemaElementChild.setSchemaElement(currentSchemaElementChild);
                configuredSchemaElement.getChildren().add((Object)configuredSchemaElementChild);
                ExtensionServices.createSchemaElementChildren(introContext, currentIConfigurationElement, configuredSchemaElementChild, extPointElements);
                ++n2;
            }
        }
    }

    private static void createSchemaElementAttributesInstance(IntrospectionContext introContext, ConfiguredSchemaElement configuredSchemaElementChild, IConfigurationElement currentConfigurationElement, SchemaElement currentSchemaElementChild) {
        String[] names = currentConfigurationElement.getAttributeNames();
        PlatformFactory platformFactory = PlatformFactory.eINSTANCE;
        EList extensionPointSideAttributes = currentSchemaElementChild.getAttributes();
        if (names.length != 0) {
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String attributeName = stringArray[n2];
                ConfigurationElementAttribute currentEPSideAttribute = null;
                for (ConfigurationElementAttribute configurationElementAttribute : extensionPointSideAttributes) {
                    if (!configurationElementAttribute.getName().equals(attributeName)) continue;
                    currentEPSideAttribute = configurationElementAttribute;
                    break;
                }
                ConfigurationElementAttributeInstance attributeInstance = platformFactory.createConfigurationElementAttributeInstance();
                if (currentEPSideAttribute != null) {
                    String attributeValue = currentConfigurationElement.getAttribute(attributeName);
                    ConfigurationElementAttributeKind type = currentEPSideAttribute.getType();
                    attributeInstance.setName(attributeName);
                    attributeInstance.setType(type);
                    attributeInstance.setAttributeDefinition(currentEPSideAttribute);
                    switch (type) {
                        case BOOLEAN: {
                            BooleanValue bval = platformFactory.createBooleanValue();
                            bval.setValue(Boolean.parseBoolean(attributeValue));
                            attributeInstance.setContainedValue((AbstractValue)bval);
                            break;
                        }
                        case JAVA: {
                            JavaClassValue jval = platformFactory.createJavaClassValue();
                            jval.setClassName(currentConfigurationElement.getAttribute(attributeName));
                            attributeInstance.setContainedValue((AbstractValue)jval);
                            break;
                        }
                        default: {
                            StringValue val = platformFactory.createStringValue();
                            val.setValue(attributeValue);
                            attributeInstance.setContainedValue((AbstractValue)val);
                        }
                    }
                }
                configuredSchemaElementChild.getConfigurationElements().add((Object)attributeInstance);
                ++n2;
            }
        }
    }
}

