/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.Platform.anno;

import ee.jakarta.tck.concurrent.common.context.providers.IntContextProvider;
import ee.jakarta.tck.concurrent.common.context.providers.StringContextProvider;
import ee.jakarta.tck.concurrent.framework.TestClient;
import ee.jakarta.tck.concurrent.framework.junit.anno.Assertion;
import ee.jakarta.tck.concurrent.framework.junit.anno.Challenge;
import ee.jakarta.tck.concurrent.framework.junit.anno.Common;
import ee.jakarta.tck.concurrent.framework.junit.anno.TestName;
import ee.jakarta.tck.concurrent.framework.junit.anno.Web;
import ee.jakarta.tck.concurrent.spec.Platform.anno.AnnotationServlet;
import jakarta.enterprise.concurrent.spi.ThreadContextProvider;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;

@Web
@RunAsClient
@Common(value={Common.PACKAGE.CONTEXT, Common.PACKAGE.CONTEXT_PROVIDERS, Common.PACKAGE.QUALIFIERS})
public class AnnotationWebTests
extends TestClient {
    @ArquillianResource(value=AnnotationServlet.class)
    private URL baseURL;
    @TestName
    private String testname;

    @Deployment(name="DeploymentDescriptorTests")
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"DeploymentDescriptorTests_web.war")).addPackages(false, new Package[]{AnnotationServlet.class.getPackage()})).addAsServiceProvider(ThreadContextProvider.class.getName(), new String[]{IntContextProvider.class.getName(), StringContextProvider.class.getName()})).addAsWebInfResource(AnnotationWebTests.class.getPackage(), "web.xml", "web.xml");
    }

    @Override
    protected String getServletPath() {
        return "AnnotationServlet";
    }

    @Assertion(id="GIT:404", strategy="Tests injection of context service defined in an annotation with qualifier(s).")
    public void testAnnoDefinedContextServiceQualifiers() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:404", strategy="Tests injection of managed executor service defined in an annotation with qualifier(s).")
    public void testAnnoDefinedManagedExecutorSvcQualifiers() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:404", strategy="Tests injection of managed scheduled exectuor service defined in an annotation with qualifier(s).")
    public void testAnnoDefinedManagedScheduledExecutorSvcQualifers() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:404", strategy="Tests injection of managed thread factory defined in an annotation with qualifier(s).")
    public void testAnnoDefinedManagedThreadFactoryQualifersWeb() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:404", strategy="Tests context-service defined in a annotation.")
    public void testAnnotationDefinesContextService() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:404", strategy="Tests managed-executor defined in a annotation.")
    public void testAnnotationDefinesManagedExecutor() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:404", strategy="Tests managed-scheduled-executor defined in a annotation.")
    public void testAnnotationDefinesManagedScheduledExecutor() {
        this.runTest(this.baseURL, this.testname);
    }

    @Challenge(link="https://github.com/jakartaee/concurrency/issues/226", version="3.0.0")
    @Assertion(id="GIT:404", strategy="Tests managed-thread-factory defined in a annotation.")
    public void testAnnotationDefinesManagedThreadFactory() {
        this.runTest(this.baseURL, this.testname);
    }
}

