/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.constraintdefinition.serviceloading;

import jakarta.validation.Validator;
import jakarta.validation.constraints.Size;
import java.util.List;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintdefinition.serviceloading.Author;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintdefinition.serviceloading.Book;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintdefinition.serviceloading.ServiceLoadedConstraint;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.IntegrationTest;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@IntegrationTest
@SpecVersion(spec="beanvalidation", version="4.0.0")
public class ServiceLoadedConstraintTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)ServiceLoadedConstraintTest.webArchiveBuilder().withTestClassPackage(ServiceLoadedConstraintTest.class)).withResource("jakarta.validation.ConstraintValidator", "META-INF/services/jakarta.validation.ConstraintValidator", true)).build();
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-register-validators", id="a")
    public void testConstraintValidatorLoadedCustomConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Set constraintViolations = validator.validate((Object)new Author(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(ServiceLoadedConstraint.class));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-register-validators", id="a")
    public void testConstraintValidatorLoadedBuiltInConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Set constraintViolations = validator.validate((Object)new Author(List.of(new Book("Book 1", 3), new Book("Book 2", 100))), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(ServiceLoadedConstraint.class).withProperty("name"), ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("books").containerElement("<list element>", true, null, 1, List.class, 0)));
    }
}

