/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.properties.sections.appearance;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.util.FontHelper;
import org.eclipse.gmf.runtime.diagram.ui.properties.internal.l10n.DiagramUIPropertiesImages;
import org.eclipse.gmf.runtime.diagram.ui.properties.internal.l10n.DiagramUIPropertiesMessages;
import org.eclipse.gmf.runtime.diagram.ui.properties.sections.AbstractNotationPropertiesSection;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.TextAlignment;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class TextAlignmentPropertySection
extends AbstractNotationPropertiesSection {
    protected static final String ALIGN_LEFT = DiagramUIPropertiesMessages.TextAlignmentPropertySection_AlignLeft;
    protected static final String ALIGN_CENTER = DiagramUIPropertiesMessages.TextAlignmentPropertySection_AlignCenter;
    protected static final String ALIGN_RIGHT = DiagramUIPropertiesMessages.TextAlignmentPropertySection_AlignRight;
    protected static final String TEXT_ALIGNMENT = DiagramUIPropertiesMessages.TextAlignmentPropertySection_TextAlignment;
    protected Button alignLeftButton;
    protected Button alignRightButton;
    protected Button alignCenterButton;
    protected Group textAlignmentGroup;

    protected void alignCenter() {
        this.setSelectedButton(TextAlignment.CENTER_LITERAL);
        ArrayList<ICommand> commands = new ArrayList<ICommand>();
        for (final IGraphicalEditPart ep : this.getInput()) {
            commands.add(this.createCommand(ALIGN_CENTER, ((View)ep.getModel()).eResource(), new Runnable(){

                public void run() {
                    ep.setStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getTextStyle_TextAlignment(), (Object)TextAlignment.CENTER_LITERAL);
                }
            }));
        }
        this.executeAsCompositeCommand(ALIGN_CENTER, commands);
    }

    protected void alignLeft() {
        this.setSelectedButton(TextAlignment.LEFT_LITERAL);
        ArrayList<ICommand> commands = new ArrayList<ICommand>();
        for (final IGraphicalEditPart ep : this.getInput()) {
            commands.add(this.createCommand(ALIGN_LEFT, ((View)ep.getModel()).eResource(), new Runnable(){

                public void run() {
                    ep.setStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getTextStyle_TextAlignment(), (Object)TextAlignment.LEFT_LITERAL);
                }
            }));
        }
        this.executeAsCompositeCommand(ALIGN_LEFT, commands);
    }

    protected void alignRight() {
        this.setSelectedButton(TextAlignment.RIGHT_LITERAL);
        ArrayList<ICommand> commands = new ArrayList<ICommand>();
        for (final IGraphicalEditPart ep : this.getInput()) {
            commands.add(this.createCommand(ALIGN_RIGHT, ((View)ep.getModel()).eResource(), new Runnable(){

                public void run() {
                    ep.setStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getTextStyle_TextAlignment(), (Object)TextAlignment.RIGHT_LITERAL);
                }
            }));
        }
        this.executeAsCompositeCommand(ALIGN_RIGHT, commands);
    }

    protected void createTextAlignmentGroup(Composite parent) {
        this.textAlignmentGroup = this.getWidgetFactory().createGroup(parent, TEXT_ALIGNMENT);
        GridLayout layout = new GridLayout(3, false);
        this.textAlignmentGroup.setLayout((Layout)layout);
        this.alignLeftButton = new Button((Composite)this.textAlignmentGroup, 2);
        this.alignLeftButton.setImage(DiagramUIPropertiesImages.get("icons/alignleft.gif"));
        this.alignLeftButton.setToolTipText(ALIGN_LEFT);
        this.alignLeftButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextAlignmentPropertySection.this.alignLeft();
            }
        });
        this.alignCenterButton = new Button((Composite)this.textAlignmentGroup, 2);
        this.alignCenterButton.setImage(DiagramUIPropertiesImages.get("icons/aligncenter.gif"));
        this.alignCenterButton.setToolTipText(ALIGN_CENTER);
        this.alignCenterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextAlignmentPropertySection.this.alignCenter();
            }
        });
        this.alignRightButton = new Button((Composite)this.textAlignmentGroup, 2);
        this.alignRightButton.setImage(DiagramUIPropertiesImages.get("icons/alignright.gif"));
        this.alignRightButton.setToolTipText(ALIGN_RIGHT);
        this.alignRightButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextAlignmentPropertySection.this.alignRight();
            }
        });
        this.setGroupWidth();
    }

    protected boolean digIntoGroups() {
        return true;
    }

    protected void initializeControls(Composite parent) {
        super.initializeControls(parent);
        this.createTextAlignmentGroup(this.composite);
    }

    public void refresh() {
        Object object;
        IGraphicalEditPart ep;
        super.refresh();
        if (!this.isDisposed() && (ep = this.getSingleInput()) != null && (object = ep.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getTextStyle_TextAlignment())) instanceof TextAlignment) {
            this.setSelectedButton((TextAlignment)object);
        }
    }

    private void setGroupWidth() {
        Composite familySize = this.getWidgetFactory().createComposite((Composite)this.textAlignmentGroup);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.heightHint = 0;
        familySize.setLayoutData((Object)gridData);
        familySize.setVisible(false);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        familySize.setLayout((Layout)layout);
        CCombo fontFamilyCombo = this.getWidgetFactory().createCCombo(familySize, 2060);
        fontFamilyCombo.setItems(FontHelper.getFontNames());
        CCombo fontSizeCombo = this.getWidgetFactory().createCCombo(familySize, 2060);
        fontSizeCombo.setItems(FontHelper.getFontSizes());
    }

    private void setSelectedButton(TextAlignment textAlignment) {
        if (TextAlignment.LEFT_LITERAL.equals(textAlignment)) {
            this.alignLeftButton.setSelection(true);
            this.alignCenterButton.setSelection(false);
            this.alignRightButton.setSelection(false);
        } else if (TextAlignment.CENTER_LITERAL.equals(textAlignment)) {
            this.alignLeftButton.setSelection(false);
            this.alignCenterButton.setSelection(true);
            this.alignRightButton.setSelection(false);
        } else if (TextAlignment.RIGHT_LITERAL.equals(textAlignment)) {
            this.alignLeftButton.setSelection(false);
            this.alignCenterButton.setSelection(false);
            this.alignRightButton.setSelection(true);
        }
    }
}

