/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.features.navigation;

import com.google.inject.Inject;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.glsp.server.actions.AbstractActionHandler;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.features.navigation.NavigationTarget;
import org.eclipse.glsp.server.features.navigation.NavigationTargetResolution;
import org.eclipse.glsp.server.features.navigation.NavigationTargetResolver;
import org.eclipse.glsp.server.features.navigation.ResolveNavigationTargetAction;
import org.eclipse.glsp.server.features.navigation.SetResolvedNavigationTargetAction;

public class ResolveNavigationTargetActionHandler
extends AbstractActionHandler<ResolveNavigationTargetAction> {
    protected static final Logger LOGGER = LogManager.getLogger(ResolveNavigationTargetActionHandler.class);
    @Inject
    protected Optional<NavigationTargetResolver> navigationTargetResolver;

    @Override
    public List<Action> executeAction(ResolveNavigationTargetAction action) {
        if (this.navigationTargetResolver.isEmpty()) {
            LOGGER.warn("Could not resolve navigation target. No implementation for: " + NavigationTargetResolver.class.getName() + " has been bound.");
            return this.none();
        }
        NavigationTarget target = action.getNavigationTarget();
        NavigationTargetResolution resolution = this.navigationTargetResolver.get().resolve(target);
        return this.listOf(new SetResolvedNavigationTargetAction(resolution.getElementIds(), resolution.getArgs()));
    }
}

