/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.preferences.internal;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.gendoc.preferences.internal.PreferenceGendocSelectionConverter;
import org.eclipse.gendoc.wizard.IGendocSelectionConverterRunner;
import org.eclipse.gendoc.wizard.IGendocTemplate;
import org.eclipse.gendoc.wizard.ISelectionConverter;

public class PreferenceGendocRunner
implements IGendocSelectionConverterRunner,
Cloneable {
    private IProject project;
    private String label;
    private String description;
    private Pattern pattern;
    private List<Parameter> parameters = new ArrayList<Parameter>();
    private List<IGendocTemplate> templates = new ArrayList<IGendocTemplate>();
    private IGendocTemplate defaultTemplate;

    public PreferenceGendocRunner(IProject proj, String label) {
        this.project = proj;
        this.label = label;
    }

    public IProject getProject() {
        return this.project;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public void setGendocTemplates(List<IGendocTemplate> templates) {
        this.templates = templates;
    }

    public List<IGendocTemplate> getGendocTemplates() {
        return this.templates;
    }

    public void addTemplate(IGendocTemplate template) {
        this.templates.add(template);
    }

    public void addDefaultTemplate(IGendocTemplate template) {
        this.addTemplate(template);
        this.defaultTemplate = template;
    }

    public void removeTemplate(IGendocTemplate template) {
        if (template == this.defaultTemplate) {
            this.defaultTemplate = null;
        }
        this.templates.remove(template.getOutPutExtension());
    }

    public IGendocTemplate getTemplate(String format) {
        for (IGendocTemplate t : this.templates) {
            if (!t.getOutPutExtension().equals(format)) continue;
            return t;
        }
        return null;
    }

    public IGendocTemplate getDefaultTemplate() {
        return this.defaultTemplate;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> params) {
        this.parameters = params;
    }

    public Map<String, String> getAdditionnalParameters() {
        LinkedHashMap<String, String> ap = new LinkedHashMap<String, String>();
        for (Parameter p : this.parameters) {
            ap.put(p.getName(), p.getLabel());
        }
        return ap;
    }

    public void addParameter(String name, String label) {
        this.parameters.add(new Parameter(name, label));
    }

    public void removeParameter(String name) {
        this.parameters.remove(new Parameter(name, ""));
    }

    public String getParameterLabel(String name) {
        for (Parameter p : this.parameters) {
            if (!p.getName().equals(name)) continue;
            return p.label;
        }
        return null;
    }

    public ISelectionConverter getSelectionConverter() {
        return new PreferenceGendocSelectionConverter(this);
    }

    public Object clone() throws CloneNotSupportedException {
        PreferenceGendocRunner runner = (PreferenceGendocRunner)super.clone();
        if (this.pattern != null) {
            runner.pattern = Pattern.compile(this.pattern.toString());
        }
        runner.parameters = new ArrayList<Parameter>();
        for (Parameter p : this.parameters) {
            runner.parameters.add(new Parameter(p.getName(), p.getLabel()));
        }
        runner.templates = new ArrayList<IGendocTemplate>();
        for (IGendocTemplate t : this.templates) {
            runner.templates.add(t);
            if (t != this.defaultTemplate) continue;
            runner.defaultTemplate = t;
        }
        return runner;
    }

    public static class Parameter {
        private String name;
        private String label;

        public Parameter(String name, String value) {
            this.name = name;
            this.label = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String value) {
            this.label = value;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Parameter other = (Parameter)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }
}

