/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.findReferences;

import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.findReferences.IReferenceFinder;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.impl.DefaultReferenceDescription;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Pair;

@FinalFieldsConstructor
public class ReferenceAcceptor
implements IReferenceFinder.Acceptor {
    private final IResourceServiceProvider.Registry resourceServiceProviderRegistry;
    private final IAcceptor<IReferenceDescription> delegate;
    private Resource currentResource;
    private Map<EObject, URI> exportedContainersInCurrentResource;

    @Override
    public void accept(EObject source, URI sourceURI, EReference eReference, int index, EObject targetOrProxy, URI targetURI) {
        if (this.currentResource == null || source.eResource() != this.currentResource) {
            this.computeExportedObjectsMap(source);
            this.currentResource = source.eResource();
        }
        this.accept(this.createReferenceDescription(sourceURI, targetURI, eReference, index, this.findExportedContainer(source)));
    }

    protected void computeExportedObjectsMap(EObject source) {
        Resource resource = source.eResource();
        IResourceServiceProvider resourceServiceProvider = this.resourceServiceProviderRegistry.getResourceServiceProvider(resource.getURI());
        if (resourceServiceProvider != null) {
            IResourceDescription resourceDescription = resourceServiceProvider.getResourceDescriptionManager().getResourceDescription(resource);
            this.exportedContainersInCurrentResource = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
            Iterable<IEObjectDescription> _exportedObjects = resourceDescription.getExportedObjects();
            for (IEObjectDescription description : _exportedObjects) {
                EObject instance = description.getEObjectOrProxy();
                boolean _eIsProxy = instance.eIsProxy();
                if (_eIsProxy) {
                    instance = resource.getEObject(description.getEObjectURI().fragment());
                }
                this.exportedContainersInCurrentResource.put(instance, description.getEObjectURI());
            }
        } else {
            this.exportedContainersInCurrentResource = CollectionLiterals.emptyMap();
        }
    }

    protected URI findExportedContainer(EObject obj) {
        EObject source = obj;
        boolean _isEmpty = this.exportedContainersInCurrentResource.isEmpty();
        if (_isEmpty) {
            return null;
        }
        URI result = this.exportedContainersInCurrentResource.get(source);
        while (result == null) {
            boolean _containsKey = this.exportedContainersInCurrentResource.containsKey(source);
            if (_containsKey) {
                return result;
            }
            if ((source = source.eContainer()) == null) {
                return null;
            }
            result = this.exportedContainersInCurrentResource.get(source);
        }
        this.exportedContainersInCurrentResource.put(source, result);
        return result;
    }

    @Override
    public void accept(IReferenceDescription description) {
        this.delegate.accept((Object)description);
    }

    protected IReferenceDescription createReferenceDescription(URI sourceURI, URI targetURI, EReference eReference, int index, URI containerURI) {
        return new DefaultReferenceDescription(sourceURI, targetURI, eReference, index, containerURI);
    }

    public ReferenceAcceptor(IResourceServiceProvider.Registry resourceServiceProviderRegistry, IAcceptor<IReferenceDescription> delegate) {
        this.resourceServiceProviderRegistry = resourceServiceProviderRegistry;
        this.delegate = delegate;
    }
}

