/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.trace.metamodel.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import opsemanticsview.OperationalSemanticsView;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gemoc.trace.commons.EcoreCraftingUtil;
import org.eclipse.gemoc.trace.commons.ExecutionMetamodelTraceability;
import org.eclipse.gemoc.trace.metamodel.generator.TraceMMExplorer;
import org.eclipse.gemoc.trace.metamodel.generator.TraceMMGenerationTraceability;
import org.eclipse.gemoc.trace.metamodel.generator.TraceMMStrings;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class TraceMMGeneratorStates {
    private final OperationalSemanticsView mmext;
    private final TraceMMExplorer traceMMExplorer;
    private final String languageName;
    private final boolean gemoc;
    private final EPackage tracemmresult;
    private final TraceMMGenerationTraceability traceability;
    private final Map<EClass, EClass> runtimeToTraced = new HashMap<EClass, EClass>();
    private final Set<EClass> allRuntimeClasses = new HashSet<EClass>();
    private final Set<EClass> allStaticClasses = new HashSet<EClass>();
    private final Set<EClass> allNewEClasses;
    private final Set<EClass> multipleOrig = new HashSet<EClass>();

    public TraceMMGeneratorStates(OperationalSemanticsView mmext, TraceMMGenerationTraceability traceability, TraceMMExplorer traceMMExplorer, String languageName, EPackage tracemmresult, boolean gemoc) {
        Set _set_1;
        this.mmext = mmext;
        TreeIterator _eAllContents = mmext.eAllContents();
        Set _set = IteratorExtensions.toSet((Iterator)_eAllContents);
        Iterable _filter = Iterables.filter((Iterable)_set, EClass.class);
        this.allNewEClasses = _set_1 = IterableExtensions.toSet((Iterable)_filter);
        this.traceability = traceability;
        this.traceMMExplorer = traceMMExplorer;
        this.languageName = languageName;
        this.tracemmresult = tracemmresult;
        this.gemoc = gemoc;
    }

    private void cleanup() {
        TreeIterator _eAllContents = this.tracemmresult.eAllContents();
        UnmodifiableIterator _filter = Iterators.filter((Iterator)_eAllContents, EClass.class);
        Set allCreatedEClasses = IteratorExtensions.toSet((Iterator)_filter);
        for (EClass c : allCreatedEClasses) {
            this.cleanupAnnotations(c);
        }
        Collection<EClass> _values = this.runtimeToTraced.values();
        Iterable _filter_1 = Iterables.filter(_values, EReference.class);
        for (EReference r : _filter_1) {
            r.setEOpposite(null);
        }
    }

    public void process() {
        this.handleTraceClasses();
        this.cleanup();
    }

    private void cleanupAnnotations(EClass eClass) {
        boolean _notEquals;
        EAnnotation traceabilityAnnotation = ExecutionMetamodelTraceability.getTraceabilityAnnotation((EModelElement)eClass);
        EList _eAnnotations = eClass.getEAnnotations();
        _eAnnotations.clear();
        boolean bl = _notEquals = !Objects.equal((Object)traceabilityAnnotation, null);
        if (_notEquals) {
            EList _eAnnotations_1 = eClass.getEAnnotations();
            _eAnnotations_1.add((Object)traceabilityAnnotation);
        }
    }

    private EPackage obtainTracedPackage(EPackage runtimePackage) {
        boolean _notEquals;
        EPackage result = this.traceMMExplorer.statesPackage;
        boolean bl = _notEquals = !Objects.equal((Object)runtimePackage, null);
        if (_notEquals) {
            Functions.Function1<EPackage, Boolean> _function;
            EPackage _eSuperPackage = runtimePackage.getESuperPackage();
            EPackage tracedSuperPackage = this.obtainTracedPackage(_eSuperPackage);
            final String tracedPackageName = TraceMMStrings.package_createTracedPackage(runtimePackage);
            EList _eSubpackages = tracedSuperPackage.getESubpackages();
            EPackage _findFirst = (EPackage)IterableExtensions.findFirst((Iterable)_eSubpackages, (Functions.Function1)(_function = new Functions.Function1<EPackage, Boolean>(){

                public Boolean apply(EPackage p) {
                    String _name = p.getName();
                    return _name.equals(tracedPackageName);
                }
            }));
            result = _findFirst;
            boolean _equals = Objects.equal((Object)result, null);
            if (_equals) {
                EPackage _createEPackage;
                result = _createEPackage = EcoreFactory.eINSTANCE.createEPackage();
                result.setName(tracedPackageName);
                String _name = result.getName();
                String _plus = String.valueOf(this.languageName) + "_" + _name;
                result.setNsURI(_plus);
                result.setNsPrefix("");
                EList _eSubpackages_1 = tracedSuperPackage.getESubpackages();
                _eSubpackages_1.add((Object)result);
            }
        }
        return result;
    }

    private String computeTraceabilityAnnotationValue(EClass extendedClass) {
        boolean _not;
        Functions.Function1<EStructuralFeature, Boolean> _function;
        String traceabilityAnnotationValue = null;
        EList _eStructuralFeatures = extendedClass.getEStructuralFeatures();
        Iterable _filter = IterableExtensions.filter((Iterable)_eStructuralFeatures, (Functions.Function1)(_function = new Functions.Function1<EStructuralFeature, Boolean>(){

            public Boolean apply(EStructuralFeature f) {
                EList _dynamicProperties = TraceMMGeneratorStates.this.mmext.getDynamicProperties();
                return _dynamicProperties.contains((Object)f);
            }
        }));
        Set dynamicProperties = IterableExtensions.toSet((Iterable)_filter);
        boolean _isEmpty = dynamicProperties.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            boolean _notEquals;
            EStructuralFeature mutableProperty = ((EStructuralFeature[])Conversions.unwrapArray((Object)dynamicProperties, EStructuralFeature.class))[0];
            String mutablePropertyTraceabilityValue = ExecutionMetamodelTraceability.getTraceabilityAnnotationValue((EModelElement)mutableProperty);
            boolean bl2 = _notEquals = !Objects.equal((Object)mutablePropertyTraceabilityValue, null);
            if (_notEquals) {
                String _substring;
                int classSubstringStartIndex = mutablePropertyTraceabilityValue.lastIndexOf("/");
                traceabilityAnnotationValue = _substring = mutablePropertyTraceabilityValue.substring(0, classSubstringStartIndex);
            }
        }
        return traceabilityAnnotationValue;
    }

    private boolean isInPackage(EPackage c, EPackage p) {
        boolean _notEquals;
        if (!Objects.equal((Object)c, null) && !Objects.equal((Object)p, null) && Objects.equal((Object)c, (Object)p)) {
            return true;
        }
        EPackage _eSuperPackage = c.getESuperPackage();
        boolean bl = _notEquals = !Objects.equal((Object)_eSuperPackage, null);
        if (_notEquals) {
            EPackage _eSuperPackage_1 = c.getESuperPackage();
            return this.isInPackage(_eSuperPackage_1, p);
        }
        return false;
    }

    private Set<EClass> getSubTypesOf(EClass c) {
        HashSet<EClass> result = new HashSet<EClass>();
        EPackage _executionMetamodel = this.mmext.getExecutionMetamodel();
        TreeIterator _eAllContents = _executionMetamodel.eAllContents();
        Set _set = IteratorExtensions.toSet((Iterator)_eAllContents);
        Iterable _filter = Iterables.filter((Iterable)_set, EClass.class);
        for (EClass someEClass : _filter) {
            EList _eSuperTypes = someEClass.getESuperTypes();
            boolean _contains = _eSuperTypes.contains((Object)c);
            if (!_contains) continue;
            result.add(someEClass);
        }
        return result;
    }

    private void getAllInheritance(Set<EClass> result, EClass c) {
        boolean _not;
        boolean _contains = result.contains(c);
        boolean bl = _not = !_contains;
        if (_not) {
            result.add(c);
            EList _eSuperTypes = c.getESuperTypes();
            for (EClass sup : _eSuperTypes) {
                this.getAllInheritance(result, sup);
            }
            Set<EClass> _subTypesOf = this.getSubTypesOf(c);
            for (EClass sub : _subTypesOf) {
                this.getAllInheritance(result, sub);
            }
        }
    }

    private Set<EClass> getAllInheritance(EClass c) {
        HashSet<EClass> result = new HashSet<EClass>();
        this.getAllInheritance(result, c);
        return result;
    }

    private void handleTraceClasses() {
        Object _function_2;
        EList _dynamicProperties = this.mmext.getDynamicProperties();
        for (EStructuralFeature dp : _dynamicProperties) {
            EClass extendedExistingClass = dp.getEContainingClass();
            this.allRuntimeClasses.add(extendedExistingClass);
            Set<EClass> allInheritance = this.getAllInheritance(extendedExistingClass);
            this.allRuntimeClasses.addAll(allInheritance);
        }
        final HashMap<EClass, EClass> baseClassToNewEClass = new HashMap<EClass, EClass>();
        for (final EClass c : this.allNewEClasses) {
            EPackage _executionMetamodel = this.mmext.getExecutionMetamodel();
            TreeIterator _eAllContents = _executionMetamodel.eAllContents();
            Set _set = IteratorExtensions.toSet((Iterator)_eAllContents);
            Iterable _filter = Iterables.filter((Iterable)_set, EClass.class);
            Functions.Function1<EClass, Boolean> _function = new Functions.Function1<EClass, Boolean>(){

                public Boolean apply(EClass cls) {
                    String _name = cls.getName();
                    String _name_1 = c.getName();
                    return Objects.equal((Object)_name, (Object)_name_1);
                }
            };
            EClass _findFirst = (EClass)IterableExtensions.findFirst((Iterable)_filter, (Functions.Function1)_function);
            baseClassToNewEClass.put(_findFirst, c);
        }
        for (final EClass c_1 : this.allNewEClasses) {
            EPackage _executionMetamodel_1 = this.mmext.getExecutionMetamodel();
            TreeIterator _eAllContents_1 = _executionMetamodel_1.eAllContents();
            Set _set_1 = IteratorExtensions.toSet((Iterator)_eAllContents_1);
            Iterable _filter_1 = Iterables.filter((Iterable)_set_1, EClass.class);
            Functions.Function1<EClass, Boolean> _function_1 = new Functions.Function1<EClass, Boolean>(){

                public Boolean apply(EClass cls) {
                    String _name = cls.getName();
                    String _name_1 = c_1.getName();
                    return Objects.equal((Object)_name, (Object)_name_1);
                }
            };
            EClass _findFirst_1 = (EClass)IterableExtensions.findFirst((Iterable)_filter_1, (Functions.Function1)_function_1);
            Set<EClass> allInheritance = this.getAllInheritance(_findFirst_1);
            _function_2 = new Functions.Function1<EClass, EClass>(){

                public EClass apply(EClass cls) {
                    EClass _xblockexpression = null;
                    EClass newEClass = (EClass)baseClassToNewEClass.get(cls);
                    EClass _xifexpression = null;
                    boolean _equals = Objects.equal((Object)newEClass, null);
                    _xifexpression = _equals ? cls : newEClass;
                    _xblockexpression = _xifexpression;
                    return _xblockexpression;
                }
            };
            Iterable _map = IterableExtensions.map(allInheritance, (Functions.Function1)_function_2);
            Iterables.addAll(this.allRuntimeClasses, (Iterable)_map);
        }
        EPackage _executionMetamodel_1 = this.mmext.getExecutionMetamodel();
        TreeIterator _eAllContents_1 = _executionMetamodel_1.eAllContents();
        Set _set_1 = IteratorExtensions.toSet((Iterator)_eAllContents_1);
        Iterable _filter_1 = Iterables.filter((Iterable)_set_1, EClass.class);
        Functions.Function1<EClass, Boolean> _function_1 = new Functions.Function1<EClass, Boolean>(){

            public Boolean apply(EClass c) {
                boolean _contains = TraceMMGeneratorStates.this.allRuntimeClasses.contains(c);
                return !_contains;
            }
        };
        Iterable _filter_2 = IterableExtensions.filter((Iterable)_filter_1, (Functions.Function1)_function_1);
        Iterables.addAll(this.allStaticClasses, (Iterable)_filter_2);
        for (EClass rc : this.allRuntimeClasses) {
            EList _eAllSuperTypes = rc.getEAllSuperTypes();
            _function_2 = new Functions.Function1<EClass, Boolean>(){

                public Boolean apply(EClass c) {
                    return !c.isAbstract() && TraceMMGeneratorStates.this.allRuntimeClasses.contains(c);
                }
            };
            Iterable _filter_3 = IterableExtensions.filter((Iterable)_eAllSuperTypes, (Functions.Function1)_function_2);
            Set concreteSuperTypes = IterableExtensions.toSet((Iterable)_filter_3);
            this.multipleOrig.addAll(concreteSuperTypes);
        }
        ArrayList<EClass> tracedClasses = new ArrayList<EClass>();
        List runtimeClasses = IterableExtensions.toList(this.allRuntimeClasses);
        Functions.Function1<EClass, String> _function_22 = new Functions.Function1<EClass, String>(){

            public String apply(EClass it) {
                return it.getName();
            }
        };
        List runtimeClassesSorted = IterableExtensions.sortBy((Iterable)runtimeClasses, (Functions.Function1)_function_22);
        for (EClass runtimeClass : runtimeClassesSorted) {
            EClass tracedClass = this.handleTraceClass(runtimeClass);
            tracedClasses.add(tracedClass);
        }
    }

    private EClass handleTraceClass(EClass runtimeClass) {
        boolean _not_1;
        boolean _not;
        boolean _contains = this.allRuntimeClasses.contains(runtimeClass);
        boolean bl = _not = !_contains;
        if (_not) {
            return runtimeClass;
        }
        boolean _containsKey = this.runtimeToTraced.containsKey(runtimeClass);
        boolean bl2 = _not_1 = !_containsKey;
        if (_not_1) {
            boolean _not_3;
            EClass tracedClass = EcoreFactory.eINSTANCE.createEClass();
            String _class_createTraceClassName = TraceMMStrings.class_createTraceClassName(runtimeClass);
            tracedClass.setName(_class_createTraceClassName);
            tracedClass.setAbstract(runtimeClass.isAbstract() || runtimeClass.isInterface());
            this.runtimeToTraced.put(runtimeClass, tracedClass);
            this.traceability.putTracedClasses(runtimeClass, tracedClass);
            EList _eSuperTypes = runtimeClass.getESuperTypes();
            Functions.Function1<EClass, Boolean> _function = new Functions.Function1<EClass, Boolean>(){

                public Boolean apply(EClass t) {
                    return TraceMMGeneratorStates.this.allRuntimeClasses.contains(t);
                }
            };
            Iterable _filter = IterableExtensions.filter((Iterable)_eSuperTypes, (Functions.Function1)_function);
            for (EClass superType : _filter) {
                EClass tracedSuperType = this.handleTraceClass(superType);
                EList _eSuperTypes_1 = tracedClass.getESuperTypes();
                _eSuperTypes_1.add((Object)tracedSuperType);
            }
            boolean _contains_1 = this.allNewEClasses.contains(runtimeClass);
            boolean notNewClass = !_contains_1;
            boolean _isAbstract = tracedClass.isAbstract();
            boolean notAbstract = !_isAbstract;
            EList _eSuperTypes_1 = tracedClass.getESuperTypes();
            boolean _isEmpty = _eSuperTypes_1.isEmpty();
            if (_isEmpty) {
                EGenericType tracedObjectGenericSuperType = EcoreFactory.eINSTANCE.createEGenericType();
                tracedObjectGenericSuperType.setEClassifier((EClassifier)this.traceMMExplorer.specificTracedObjectClass);
                EGenericType dimensionClassTracedObjectTypeBinding = EcoreFactory.eINSTANCE.createEGenericType();
                EList _eTypeArguments = tracedObjectGenericSuperType.getETypeArguments();
                _eTypeArguments.add((Object)dimensionClassTracedObjectTypeBinding);
                dimensionClassTracedObjectTypeBinding.setEClassifier((EClassifier)this.traceMMExplorer.specificDimensionClass);
                EList _eTypeArguments_1 = dimensionClassTracedObjectTypeBinding.getETypeArguments();
                EGenericType _createEGenericType = EcoreFactory.eINSTANCE.createEGenericType();
                _eTypeArguments_1.add((Object)_createEGenericType);
                EList _eGenericSuperTypes = tracedClass.getEGenericSuperTypes();
                _eGenericSuperTypes.add((Object)tracedObjectGenericSuperType);
            }
            EPackage _ePackage = runtimeClass.getEPackage();
            EPackage tracedPackage = this.obtainTracedPackage(_ePackage);
            EList _eClassifiers = tracedPackage.getEClassifiers();
            _eClassifiers.add((Object)tracedClass);
            EList _eStructuralFeatures = runtimeClass.getEStructuralFeatures();
            Functions.Function1<EStructuralFeature, Boolean> _function_1 = new Functions.Function1<EStructuralFeature, Boolean>(){

                public Boolean apply(EStructuralFeature f) {
                    EList _dynamicProperties = TraceMMGeneratorStates.this.mmext.getDynamicProperties();
                    return _dynamicProperties.contains((Object)f);
                }
            };
            Iterable dynamicProperties = IterableExtensions.filter((Iterable)_eStructuralFeatures, (Functions.Function1)_function_1);
            if (notNewClass && !IterableExtensions.isEmpty((Iterable)dynamicProperties)) {
                boolean _notEquals;
                String traceabilityAnnotationValue = this.computeTraceabilityAnnotationValue(runtimeClass);
                boolean bl3 = _notEquals = !Objects.equal((Object)traceabilityAnnotationValue, null);
                if (_notEquals) {
                    ExecutionMetamodelTraceability.createTraceabilityAnnotation((EModelElement)tracedClass, (String)traceabilityAnnotationValue);
                }
            }
            EList _eAllSuperTypes = runtimeClass.getEAllSuperTypes();
            Functions.Function1<EClass, Boolean> _function_2 = new Functions.Function1<EClass, Boolean>(){

                public Boolean apply(EClass c) {
                    return !TraceMMGeneratorStates.this.allRuntimeClasses.contains(c) || c.isAbstract();
                }
            };
            boolean onlyAbstractSuperTypes = IterableExtensions.forall((Iterable)_eAllSuperTypes, (Functions.Function1)_function_2);
            if (notNewClass && notAbstract && onlyAbstractSuperTypes) {
                String _xifexpression = null;
                boolean _contains_2 = this.multipleOrig.contains(runtimeClass);
                _xifexpression = _contains_2 ? TraceMMStrings.ref_OriginalObject_MultipleInheritance(runtimeClass) : "originalObject";
                String refName = _xifexpression;
                EReference ref = EcoreCraftingUtil.addReferenceToClass((EClass)tracedClass, (String)refName, (EClass)runtimeClass);
                this.traceability.addRefs_originalObject(tracedClass, ref);
            }
            HashSet runtimeProperties = new HashSet();
            boolean _contains_3 = this.allNewEClasses.contains(runtimeClass);
            if (_contains_3) {
                EList _eStructuralFeatures_1 = runtimeClass.getEStructuralFeatures();
                runtimeProperties.addAll(_eStructuralFeatures_1);
            } else {
                boolean _not_2;
                boolean _isEmpty_1 = IterableExtensions.isEmpty((Iterable)dynamicProperties);
                boolean bl4 = _not_2 = !_isEmpty_1;
                if (_not_2) {
                    Iterables.addAll(runtimeProperties, (Iterable)dynamicProperties);
                }
            }
            boolean _isEmpty_2 = runtimeProperties.isEmpty();
            boolean bl5 = _not_3 = !_isEmpty_2;
            if (_not_3) {
                this.traceability.addRuntimeClass(runtimeClass);
            }
            ArrayList<String> dimensionsGetters = new ArrayList<String>();
            for (EStructuralFeature runtimeProperty : runtimeProperties) {
                EStructuralFeature _copy;
                this.traceability.addMutableProperty(runtimeClass, runtimeProperty);
                EClass valueClass = EcoreFactory.eINSTANCE.createEClass();
                String _class_createStateClassName = TraceMMStrings.class_createStateClassName(runtimeClass, runtimeProperty);
                valueClass.setName(_class_createStateClassName);
                EStructuralFeature copiedProperty = _copy = (EStructuralFeature)EcoreUtil.copy((EObject)runtimeProperty);
                if (copiedProperty instanceof EReference) {
                    ((EReference)copiedProperty).setContainment(false);
                    ((EReference)copiedProperty).setEOpposite(null);
                    EClassifier _eType = runtimeProperty.getEType();
                    EClass _handleTraceClass = this.handleTraceClass((EClass)_eType);
                    ((EReference)copiedProperty).setEType((EClassifier)_handleTraceClass);
                    ((EReference)copiedProperty).setDerived(false);
                    ((EReference)copiedProperty).setChangeable(true);
                    ((EReference)copiedProperty).setVolatile(false);
                    EGenericType valueGenericSuperType = EcoreFactory.eINSTANCE.createEGenericType();
                    valueGenericSuperType.setEClassifier((EClassifier)this.traceMMExplorer.specificReferenceValueClass);
                    EGenericType valueTypeBinding = EcoreFactory.eINSTANCE.createEGenericType();
                    EList _eTypeArguments_2 = valueGenericSuperType.getETypeArguments();
                    _eTypeArguments_2.add((Object)valueTypeBinding);
                    EClassifier _eType_1 = ((EReference)copiedProperty).getEType();
                    valueTypeBinding.setEClassifier(_eType_1);
                    EList _eGenericSuperTypes_1 = valueClass.getEGenericSuperTypes();
                    _eGenericSuperTypes_1.add((Object)valueGenericSuperType);
                } else {
                    EList _eSuperTypes_2 = valueClass.getESuperTypes();
                    _eSuperTypes_2.add((Object)this.traceMMExplorer.specificAttributeValueClass);
                }
                EList _eStructuralFeatures_2 = valueClass.getEStructuralFeatures();
                _eStructuralFeatures_2.add((Object)copiedProperty);
                EList _eClassifiers_1 = this.traceMMExplorer.statesPackage.getEClassifiers();
                _eClassifiers_1.add((Object)valueClass);
                this.traceability.putMutablePropertyToValueProperty(runtimeProperty, copiedProperty);
                String _traceabilityAnnotationValue = ExecutionMetamodelTraceability.getTraceabilityAnnotationValue((EModelElement)runtimeProperty);
                ExecutionMetamodelTraceability.createTraceabilityAnnotation((EModelElement)valueClass, (String)_traceabilityAnnotationValue);
                EClass dimensionClass = EcoreFactory.eINSTANCE.createEClass();
                String _class_createDimensionClassName = TraceMMStrings.class_createDimensionClassName(runtimeClass, runtimeProperty);
                dimensionClass.setName(_class_createDimensionClassName);
                EGenericType dimensionGenericSuperType = EcoreFactory.eINSTANCE.createEGenericType();
                dimensionGenericSuperType.setEClassifier((EClassifier)this.traceMMExplorer.specificDimensionClass);
                EGenericType dimensionTypeBinding = EcoreFactory.eINSTANCE.createEGenericType();
                EList _eTypeArguments_3 = dimensionGenericSuperType.getETypeArguments();
                _eTypeArguments_3.add((Object)dimensionTypeBinding);
                dimensionTypeBinding.setEClassifier((EClassifier)valueClass);
                EList _eGenericSuperTypes_2 = dimensionClass.getEGenericSuperTypes();
                _eGenericSuperTypes_2.add((Object)dimensionGenericSuperType);
                EList _eClassifiers_2 = this.traceMMExplorer.statesPackage.getEClassifiers();
                _eClassifiers_2.add((Object)dimensionClass);
                String _name = dimensionClass.getName();
                String _firstLower = StringExtensions.toFirstLower((String)_name);
                EReference dimensionRef = EcoreCraftingUtil.addReferenceToClass((EClass)tracedClass, (String)_firstLower, (EClass)dimensionClass);
                dimensionRef.setContainment(true);
                dimensionRef.setLowerBound(0);
                dimensionRef.setUpperBound(1);
                String _stringGetter = EcoreCraftingUtil.stringGetter((EStructuralFeature)dimensionRef);
                dimensionsGetters.add(_stringGetter);
                this.traceability.putDimensionClass(runtimeProperty, dimensionClass);
                this.traceability.putDimensionRef(runtimeProperty, dimensionRef);
                this.traceability.putValueClass(runtimeProperty, valueClass);
            }
            EOperation getDimensionsInternal = EcoreFactory.eINSTANCE.createEOperation();
            EAnnotation getDimensionsAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            EList _eAnnotations = getDimensionsInternal.getEAnnotations();
            _eAnnotations.add((Object)getDimensionsAnnotation);
            getDimensionsInternal.setName("getDimensionsInternal");
            getDimensionsInternal.setLowerBound(0);
            getDimensionsInternal.setUpperBound(-1);
            EGenericType dimensionGenericSuperType = EcoreFactory.eINSTANCE.createEGenericType();
            dimensionGenericSuperType.setEClassifier((EClassifier)this.traceMMExplorer.specificDimensionClass);
            EGenericType dimensionTypeBinding = EcoreFactory.eINSTANCE.createEGenericType();
            EList _eTypeArguments_2 = dimensionGenericSuperType.getETypeArguments();
            _eTypeArguments_2.add((Object)dimensionTypeBinding);
            getDimensionsInternal.setEGenericType(dimensionGenericSuperType);
            getDimensionsAnnotation.setSource("http://www.eclipse.org/emf/2002/GenModel");
            EMap _details = getDimensionsAnnotation.getDetails();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("final EList<SpecificDimension<?>> result = new org.eclipse.emf.ecore.util.BasicInternalEList<SpecificDimension<?>>(Object.class);");
            _builder.newLine();
            _builder.append("result.addAll(super.getDimensionsInternal());");
            _builder.newLine();
            for (String getter : dimensionsGetters) {
                _builder.append("result.add(");
                _builder.append(getter, "");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("return result;");
            _builder.newLine();
            _details.put((Object)"body", (Object)_builder.toString());
            EList _eOperations = tracedClass.getEOperations();
            _eOperations.add((Object)getDimensionsInternal);
            return tracedClass;
        }
        return this.runtimeToTraced.get(runtimeClass);
    }
}

