/**
 * Copyright (c) 2016, 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package org.eclipse.gemoc.trace.metamodel.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import opsemanticsview.OperationalSemanticsView;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.gemoc.trace.commons.EMFUtil;
import org.eclipse.gemoc.trace.metamodel.generator.TraceMMExplorer;
import org.eclipse.gemoc.trace.metamodel.generator.TraceMMGenerationTraceability;
import org.eclipse.gemoc.trace.metamodel.generator.TraceMMGeneratorStates;
import org.eclipse.gemoc.trace.metamodel.generator.TraceMMGeneratorSteps;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

@SuppressWarnings("all")
public class TraceMMGenerator {
  private final OperationalSemanticsView mmext;
  
  private final ResourceSet rs;
  
  private final String languageName;
  
  private final boolean gemoc;
  
  @Accessors({ AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER })
  private final EPackage tracemmresult;
  
  @Accessors({ AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER })
  private final TraceMMGenerationTraceability traceability;
  
  private final TraceMMExplorer traceMMExplorer;
  
  private boolean done = false;
  
  public TraceMMGenerator(final OperationalSemanticsView mmext, final boolean gemoc) {
    try {
      this.mmext = mmext;
      this.gemoc = gemoc;
      EPackage _executionMetamodel = mmext.getExecutionMetamodel();
      String _name = _executionMetamodel.getName();
      String _replaceAll = _name.replaceAll(" ", "");
      String _plus = (_replaceAll + "Trace");
      this.languageName = _plus;
      ResourceSetImpl _resourceSetImpl = new ResourceSetImpl();
      this.rs = _resourceSetImpl;
      Resource.Factory.Registry _resourceFactoryRegistry = this.rs.getResourceFactoryRegistry();
      Map<String, Object> _extensionToFactoryMap = _resourceFactoryRegistry.getExtensionToFactoryMap();
      EcoreResourceFactoryImpl _ecoreResourceFactoryImpl = new EcoreResourceFactoryImpl();
      _extensionToFactoryMap.put("ecore", _ecoreResourceFactoryImpl);
      URI _createPlatformPluginURI = URI.createPlatformPluginURI("org.eclipse.gemoc.trace.metamodel.generator/model/base.ecore", true);
      final Resource base = EMFUtil.loadModelURI(_createPlatformPluginURI, this.rs);
      EList<EObject> _contents = base.getContents();
      EObject _get = _contents.get(0);
      this.tracemmresult = ((EPackage) _get);
      EList<EObject> _contents_1 = base.getContents();
      _contents_1.remove(this.tracemmresult);
      this.tracemmresult.setName(this.languageName);
      this.tracemmresult.setNsURI(this.languageName);
      this.tracemmresult.setNsPrefix(this.languageName);
      TraceMMExplorer _traceMMExplorer = new TraceMMExplorer(this.tracemmresult);
      this.traceMMExplorer = _traceMMExplorer;
      this.traceMMExplorer.stepsPackage.setNsURI((this.languageName + "_Steps"));
      this.traceMMExplorer.statesPackage.setNsURI((this.languageName + "_States"));
      TraceMMGenerationTraceability _traceMMGenerationTraceability = new TraceMMGenerationTraceability(this.traceMMExplorer, mmext);
      this.traceability = _traceMMGenerationTraceability;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  private TraceMMGeneratorSteps stepsGen;
  
  public void computeAllMaterial() throws IOException {
    if ((!this.done)) {
      final TraceMMGeneratorStates statesGen = new TraceMMGeneratorStates(this.mmext, this.traceability, this.traceMMExplorer, this.languageName, 
        this.tracemmresult, this.gemoc);
      statesGen.process();
      TraceMMGeneratorSteps _traceMMGeneratorSteps = new TraceMMGeneratorSteps(this.mmext, this.tracemmresult, this.traceability, this.traceMMExplorer, this.gemoc);
      this.stepsGen = _traceMMGeneratorSteps;
      this.stepsGen.process();
      final Diagnostic results = Diagnostician.INSTANCE.validate(this.mmext);
      List<Diagnostic> _children = results.getChildren();
      final Function1<Diagnostic, Boolean> _function = new Function1<Diagnostic, Boolean>() {
        @Override
        public Boolean apply(final Diagnostic r) {
          int _severity = r.getSeverity();
          return Boolean.valueOf((_severity == Diagnostic.ERROR));
        }
      };
      final Diagnostic error = IterableExtensions.<Diagnostic>findFirst(_children, _function);
      boolean _notEquals = (!Objects.equal(error, null));
      if (_notEquals) {
        throw new IllegalStateException(
          ("The generated trace metamodel is invalid for at least one reason: " + error));
      }
      this.done = true;
    } else {
      InputOutput.<String>println("ERROR: already computed.");
    }
  }
  
  public void sortResult() {
    this.sortEPackage(this.tracemmresult);
  }
  
  private void sortEPackage(final EPackage ePack) {
    EList<EPackage> _eSubpackages = ePack.getESubpackages();
    for (final EPackage subPackage : _eSubpackages) {
      this.sortEPackage(subPackage);
    }
    EList<EClassifier> _eClassifiers = ePack.getEClassifiers();
    final Function1<EClassifier, String> _function = new Function1<EClassifier, String>() {
      @Override
      public String apply(final EClassifier it) {
        return it.getName();
      }
    };
    final List<EClassifier> sortedSteps = IterableExtensions.<EClassifier, String>sortBy(_eClassifiers, _function);
    EList<EClassifier> _eClassifiers_1 = ePack.getEClassifiers();
    _eClassifiers_1.clear();
    EList<EClassifier> _eClassifiers_2 = ePack.getEClassifiers();
    _eClassifiers_2.addAll(sortedSteps);
    EList<EClassifier> _eClassifiers_3 = ePack.getEClassifiers();
    Iterable<EClass> _filter = Iterables.<EClass>filter(_eClassifiers_3, EClass.class);
    for (final EClass eClass : _filter) {
      {
        this.sortEClassFeatures(eClass);
        this.sortEClassInheritance(eClass);
      }
    }
  }
  
  private void sortEClassFeatures(final EClass eClass) {
    EList<EStructuralFeature> _eStructuralFeatures = eClass.getEStructuralFeatures();
    final Function1<EStructuralFeature, String> _function = new Function1<EStructuralFeature, String>() {
      @Override
      public String apply(final EStructuralFeature it) {
        return it.getName();
      }
    };
    final List<EStructuralFeature> sortedClassFeatures = IterableExtensions.<EStructuralFeature, String>sortBy(_eStructuralFeatures, _function);
    EList<EStructuralFeature> _eStructuralFeatures_1 = eClass.getEStructuralFeatures();
    _eStructuralFeatures_1.clear();
    EList<EStructuralFeature> _eStructuralFeatures_2 = eClass.getEStructuralFeatures();
    _eStructuralFeatures_2.addAll(sortedClassFeatures);
  }
  
  private void sortEClassInheritance(final EClass eClass) {
    EList<EGenericType> _eGenericSuperTypes = eClass.getEGenericSuperTypes();
    boolean _isEmpty = _eGenericSuperTypes.isEmpty();
    if (_isEmpty) {
      EList<EClass> _eSuperTypes = eClass.getESuperTypes();
      final Function1<EClass, String> _function = new Function1<EClass, String>() {
        @Override
        public String apply(final EClass it) {
          return it.getName();
        }
      };
      final List<EClass> sortedClassInheritance = IterableExtensions.<EClass, String>sortBy(_eSuperTypes, _function);
      EList<EClass> _eSuperTypes_1 = eClass.getESuperTypes();
      _eSuperTypes_1.clear();
      EList<EClass> _eSuperTypes_2 = eClass.getESuperTypes();
      _eSuperTypes_2.addAll(sortedClassInheritance);
    }
  }
  
  public void addGetCallerEOperations(final Set<EPackage> traceMetamodel, final Set<GenPackage> packages) {
    this.stepsGen.addGetCallerEOperations(traceMetamodel, packages);
  }
  
  @Pure
  public EPackage getTracemmresult() {
    return this.tracemmresult;
  }
  
  @Pure
  public TraceMMGenerationTraceability getTraceability() {
    return this.traceability;
  }
}
