/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.ui.views.engine.actions;

import org.eclipse.gemoc.commons.eclipse.ui.ViewHelper;
import org.eclipse.gemoc.executionframework.ui.Activator;
import org.eclipse.gemoc.executionframework.ui.views.engine.EnginesStatusView;
import org.eclipse.gemoc.executionframework.ui.views.engine.actions.AbstractEngineAction;
import org.eclipse.gemoc.xdsmlframework.api.core.EngineStatus;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionEngine;
import org.eclipse.jface.resource.ImageDescriptor;

public class DisposeStoppedEngineAction
extends AbstractEngineAction {
    public DisposeStoppedEngineAction() {
        this.setText("Dispose stopped engine");
        this.setToolTipText("Dispose stopped engine");
        ImageDescriptor id = Activator.imageDescriptorFromPlugin((String)"org.eclipse.gemoc.gemoc_language_workbench.ui", (String)"IMG_ELCL_REMOVE");
        this.setImageDescriptor(id);
    }

    public void run() {
        EnginesStatusView view = (EnginesStatusView)((Object)ViewHelper.retrieveView((String)"org.eclipse.gemoc.executionframework.ui.views.engine.EnginesStatusView"));
        view.removeStoppedEngines();
        if (view.getSelectedEngine() != null && view.getSelectedEngine().getRunningStatus().equals((Object)EngineStatus.RunStatus.Stopped)) {
            view.getSelectedEngine().dispose();
        } else {
            this.showMessage(view.getSite(), "please stop the Engine before trying to dispose it");
        }
    }

    @Override
    public void engineSelectionChanged(IExecutionEngine engine) {
        super.engineSelectionChanged(engine);
        if (this.getCurrentSelectedEngine() != null) {
            this.setEnabled(this.getCurrentSelectedEngine().getRunningStatus().equals((Object)EngineStatus.RunStatus.Stopped));
        }
    }
}

