/**
 * Copyright (c) 2016 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package org.eclipse.gemoc.executionframework.engine.core;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.gemoc.trace.commons.model.trace.MSE;
import org.eclipse.gemoc.trace.commons.model.trace.MSEOccurrence;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.xtend2.lib.StringConcatenation;

/**
 * An exception that is caused by anything thrown from the execution of
 * sequential operational semantics.
 */
@SuppressWarnings("all")
public class SequentialExecutionException extends RuntimeException {
  private Step<?> pendingStep;
  
  public SequentialExecutionException(final Step<?> pendingMSE, final Throwable cause) {
    this.pendingStep = this.pendingStep;
    this.initCause(cause);
  }
  
  private String prettyPrintMSEOcc() {
    if ((this.pendingStep != null)) {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("Pending MSEOccurrence: ");
      MSEOccurrence _mseoccurrence = this.pendingStep.getMseoccurrence();
      MSE _mse = _mseoccurrence.getMse();
      EObject _caller = _mse.getCaller();
      EClass _eClass = _caller.eClass();
      String _name = _eClass.getName();
      _builder.append(_name, "");
      _builder.append(".");
      MSEOccurrence _mseoccurrence_1 = this.pendingStep.getMseoccurrence();
      MSE _mse_1 = _mseoccurrence_1.getMse();
      EOperation _action = _mse_1.getAction();
      String _name_1 = _action.getName();
      _builder.append(_name_1, "");
      _builder.append(" called on ");
      MSEOccurrence _mseoccurrence_2 = this.pendingStep.getMseoccurrence();
      MSE _mse_2 = _mseoccurrence_2.getMse();
      EObject _caller_1 = _mse_2.getCaller();
      _builder.append(_caller_1, "");
      _builder.append(".");
      return _builder.toString();
    } else {
      return "No pending MSE.";
    }
  }
  
  @Override
  public String getMessage() {
    if (((this.getCause() != null) && (this.getCause() instanceof RollbackException))) {
      String _prettyPrintMSEOcc = this.prettyPrintMSEOcc();
      return ("An error occured during the execution of the operational semantics (originally catched as a RollbackException during the transaction commit).\n" + _prettyPrintMSEOcc);
    } else {
      if (((this.getCause() != null) && (this.getCause() instanceof InterruptedException))) {
        String _prettyPrintMSEOcc_1 = this.prettyPrintMSEOcc();
        return ("The engine thread was interrupted while it was waiting for being allowed to start an execution step\'s transaction.\n" + _prettyPrintMSEOcc_1);
      } else {
        return super.getMessage();
      }
    }
  }
}
