/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.addon.diffviewer.logic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javafx.util.Pair;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.diff.DefaultDiffEngine;
import org.eclipse.emf.compare.diff.DiffBuilder;
import org.eclipse.emf.compare.diff.FeatureFilter;
import org.eclipse.emf.compare.diff.IDiffEngine;
import org.eclipse.emf.compare.diff.IDiffProcessor;
import org.eclipse.emf.compare.internal.spec.MatchSpec;
import org.eclipse.emf.compare.postprocessor.BasicPostProcessorDescriptorImpl;
import org.eclipse.emf.compare.postprocessor.IPostProcessor;
import org.eclipse.emf.compare.postprocessor.PostProcessorDescriptorRegistryImpl;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gemoc.addon.diffviewer.logic.Diff;
import org.eclipse.gemoc.trace.commons.model.trace.Value;

public class DiffComputer {
    private IPostProcessor.Descriptor.Registry registry = null;
    private IDiffEngine diffEngine = null;
    private EMFCompare compare;
    private IPostProcessor.Descriptor descriptor = null;
    private boolean compareInitialized = false;
    private final List<Pair<List<Value<?>>, List<Value<?>>>> eqGroup = new ArrayList();
    private final List<Pair<List<Value<?>>, List<Value<?>>>> substGroup = new ArrayList();
    private final List<List<Value<?>>> inGroup = new ArrayList();
    private final List<List<Value<?>>> delGroup = new ArrayList();
    private final List<Diff> diffs = new ArrayList<Diff>();
    private final IPostProcessor customPostProcessor = new IPostProcessor(){
        private final Function<EObject, String> getIdFunction = e -> e.eClass().getName();

        public void postMatch(Comparison comparison, Monitor monitor) {
            ArrayList matches = new ArrayList(comparison.getMatches());
            ArrayList treatedMatches = new ArrayList();
            matches.forEach(m1 -> {
                matches.forEach(m2 -> {
                    if (m1 != m2 && !treatedMatches.contains(m2)) {
                        EObject right;
                        EObject left;
                        if (m1.getLeft() != null && m1.getRight() == null && m2.getLeft() == null && m2.getRight() != null) {
                            left = m1.getLeft();
                            right = m2.getRight();
                        } else if (m2.getLeft() != null && m2.getRight() == null && m1.getLeft() == null && m1.getRight() != null) {
                            left = m2.getLeft();
                            right = m1.getRight();
                        } else {
                            return;
                        }
                        String leftId = this.getIdFunction.apply(left);
                        String rightId = this.getIdFunction.apply(right);
                        if (leftId.equals(rightId)) {
                            comparison.getMatches().remove(m1);
                            comparison.getMatches().remove(m2);
                            MatchSpec match2 = new MatchSpec();
                            match2.setLeft(left);
                            match2.setRight(right);
                            comparison.getMatches().add((Object)match2);
                        }
                    }
                });
                treatedMatches.add(m1);
            });
        }

        public void postDiff(Comparison comparison, Monitor monitor) {
        }

        public void postRequirements(Comparison comparison, Monitor monitor) {
        }

        public void postEquivalences(Comparison comparison, Monitor monitor) {
        }

        public void postConflicts(Comparison comparison, Monitor monitor) {
        }

        public void postComparison(Comparison comparison, Monitor monitor) {
        }
    };

    private void configureDiffEngine() {
        DiffBuilder diffProcessor = new DiffBuilder();
        this.diffEngine = new DefaultDiffEngine((IDiffProcessor)diffProcessor){

            protected FeatureFilter createFeatureFilter() {
                return new FeatureFilter(){

                    protected boolean isIgnoredReference(Match match, EReference reference) {
                        String name = reference.getName();
                        return name.equals("parent") || name.equals("states") || name.equals("statesNoOpposite");
                    }
                };
            }
        };
    }

    public boolean compareEObjects(EObject e1, EObject e2) {
        if (e1 == e2) {
            return true;
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        if (e1.eClass() != e2.eClass()) {
            return false;
        }
        if (!this.compareInitialized) {
            this.configureDiffEngine();
            this.descriptor = new BasicPostProcessorDescriptorImpl(this.customPostProcessor, Pattern.compile(".*"), null);
            this.registry = new PostProcessorDescriptorRegistryImpl();
            this.registry.put((Object)this.customPostProcessor.getClass().getName(), this.descriptor);
            this.compare = EMFCompare.builder().setPostProcessorRegistry(this.registry).setDiffEngine(this.diffEngine).build();
            this.compareInitialized = true;
        }
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)e1, (Notifier)e2, null);
        Comparison comparison = this.compare.compare((IComparisonScope)scope);
        return comparison.getDifferences().isEmpty();
    }

    private boolean compareTraces(List<Value<?>> trace1, List<Value<?>> trace2) {
        int length2;
        int length1 = trace1.size();
        if (length1 != (length2 = trace2.size())) {
            return false;
        }
        boolean result = true;
        int i = 0;
        while (i < length1 && result) {
            result = this.compareEObjects((EObject)trace1.get(i), (EObject)trace2.get(i));
            ++i;
        }
        return result;
    }

    private int computeDistanceBetweenTraces(List<Value<?>> trace1, List<Value<?>> trace2) {
        int[][] m = new int[trace1.size() + 1][trace2.size() + 1];
        int i = 0;
        while (i < m.length) {
            m[i][0] = i;
            ++i;
        }
        i = 1;
        while (i < m[0].length) {
            m[0][i] = i;
            ++i;
        }
        int[][] cost = new int[trace1.size()][trace2.size()];
        int i2 = 0;
        while (i2 < cost.length) {
            int j = 0;
            while (j < cost[0].length) {
                cost[i2][j] = this.compareEObjects((EObject)trace1.get(i2), (EObject)trace2.get(j)) ? 0 : 1;
                ++j;
            }
            ++i2;
        }
        int result = 0;
        int i3 = 1;
        while (i3 < m.length) {
            int j = 1;
            while (j < m[1].length) {
                int deletion = m[i3 - 1][j] + 1;
                int insertion = m[i3][j - 1] + 1;
                int substitution = m[i3 - 1][j - 1] + cost[i3 - 1][j - 1];
                m[i3][j] = result = Math.min(Math.min(insertion, deletion), substitution);
                ++j;
            }
            ++i3;
        }
        return result;
    }

    private Map<int[], Integer> matchTraces(List<List<Value<?>>> traces1, List<List<Value<?>>> traces2) {
        HashMap<Integer, ArrayList<int[]>> pairs = new HashMap<Integer, ArrayList<int[]>>();
        int i = 0;
        while (i < traces1.size()) {
            int j = 0;
            while (j < traces2.size()) {
                int k = this.computeDistanceBetweenTraces(traces1.get(i), traces2.get(j));
                ArrayList<int[]> l = (ArrayList<int[]>)pairs.get(k);
                if (l == null) {
                    l = new ArrayList<int[]>();
                    pairs.put(k, l);
                }
                l.add(new int[]{i, j++});
            }
            ++i;
        }
        List distances = pairs.keySet().stream().sorted().collect(Collectors.toList());
        HashMap<int[], Integer> result = new HashMap<int[], Integer>();
        for (Integer d : distances) {
            List l = (List)pairs.get(d);
            while (l != null && !l.isEmpty()) {
                int[] p = (int[])l.remove(0);
                result.put(p, d);
                pairs.values().forEach(toClean -> {
                    boolean bl = toClean.removeIf(t -> t[0] == p[0] || t[1] == p[1]);
                });
            }
        }
        return result;
    }

    private EClass getTraceEClass(List<Value<?>> trace) {
        EClass result = null;
        for (Value<?> e : trace) {
            if (e == null) continue;
            result = e.eClass();
            break;
        }
        return result;
    }

    public List<Diff> getDiffs() {
        return this.diffs;
    }

    public List<Pair<List<Value<?>>, List<Value<?>>>> getEqGroup() {
        return this.eqGroup;
    }

    public List<Pair<List<Value<?>>, List<Value<?>>>> getSubstGroup() {
        return this.substGroup;
    }

    public List<List<Value<?>>> getInGroup() {
        return this.inGroup;
    }

    public List<List<Value<?>>> getDelGroup() {
        return this.delGroup;
    }

    public void loadTraces(List<List<Value<?>>> traces1, List<List<Value<?>>> traces2) {
        int i;
        List<List<Value<?>>> l;
        EClass eClass;
        HashMap traceGroups1 = new HashMap();
        HashMap traceGroups2 = new HashMap();
        this.diffs.clear();
        for (List<Value<?>> trace : traces1) {
            eClass = this.getTraceEClass(trace);
            if (eClass == null) continue;
            l = (ArrayList)traceGroups1.get(eClass);
            if (l == null) {
                l = new ArrayList();
                traceGroups1.put(eClass, l);
            }
            l.add(trace);
        }
        for (List<Value<?>> trace : traces2) {
            eClass = this.getTraceEClass(trace);
            if (eClass == null) continue;
            l = (List)traceGroups2.get(eClass);
            if (l == null) {
                l = new ArrayList();
                traceGroups2.put(eClass, l);
            }
            l.add(trace);
        }
        this.eqGroup.clear();
        this.substGroup.clear();
        this.inGroup.clear();
        this.delGroup.clear();
        HashSet classes = new HashSet(traceGroups1.keySet());
        classes.addAll(traceGroups2.keySet());
        List classesSorted = classes.stream().sorted((e1, e2) -> e2.getName().compareTo(e1.getName())).collect(Collectors.toList());
        HashMap<Pair, Integer> substGroupAccumulator = new HashMap<Pair, Integer>();
        for (EClass eClass2 : classesSorted) {
            if (!traceGroups1.containsKey(eClass2) || !traceGroups2.containsKey(eClass2)) continue;
            List traceGroup1 = (List)traceGroups1.get(eClass2);
            List traceGroup2 = (List)traceGroups2.get(eClass2);
            i = 0;
            int j = 0;
            while (i < traceGroup1.size() && j < traceGroup2.size()) {
                List trace2;
                List trace1 = (List)traceGroup1.get(i);
                if (this.compareTraces(trace1, trace2 = (List)traceGroup2.get(j))) {
                    traceGroup1.remove(i);
                    traceGroup2.remove(j);
                    j = 0;
                    this.eqGroup.add(new Pair((Object)trace1, (Object)trace2));
                    continue;
                }
                if (j < traceGroup2.size() - 1) {
                    ++j;
                    continue;
                }
                ++i;
                j = 0;
            }
            if (traceGroup1.isEmpty() || traceGroup2.isEmpty()) continue;
            for (Map.Entry<int[], Integer> pair : this.matchTraces(traceGroup1, traceGroup2).entrySet()) {
                List t1 = (List)traceGroup1.get(pair.getKey()[0]);
                List t2 = (List)traceGroup2.get(pair.getKey()[1]);
                substGroupAccumulator.put(new Pair((Object)t1, (Object)t2), pair.getValue());
            }
        }
        this.delGroup.addAll(traces1);
        this.inGroup.addAll(traces2);
        this.eqGroup.forEach(p -> {
            this.inGroup.remove(p.getKey());
            this.inGroup.remove(p.getValue());
            this.delGroup.remove(p.getKey());
            this.delGroup.remove(p.getValue());
        });
        for (Map.Entry e : substGroupAccumulator.entrySet().stream().sorted((e1, e2) -> (Integer)e1.getValue() - (Integer)e2.getValue()).collect(Collectors.toList())) {
            this.substGroup.add((Pair)e.getKey());
        }
        this.substGroup.forEach(p -> {
            this.inGroup.remove(p.getKey());
            this.inGroup.remove(p.getValue());
            this.delGroup.remove(p.getKey());
            this.delGroup.remove(p.getValue());
        });
        ArrayList stateTrace1 = new ArrayList();
        ArrayList stateTrace2 = new ArrayList();
        if (!this.substGroup.isEmpty()) {
            ArrayList valuesTrace1 = new ArrayList();
            ArrayList valuesTrace2 = new ArrayList();
            this.substGroup.forEach(p -> {
                valuesTrace1.add((List)p.getKey());
                valuesTrace2.add((List)p.getValue());
            });
            i = 0;
            while (i < ((List)valuesTrace1.get(0)).size()) {
                ArrayList<Value> stateValues = new ArrayList<Value>();
                for (List l2 : valuesTrace1) {
                    stateValues.add((Value)l2.get(i));
                }
                stateTrace1.add(stateValues);
                ++i;
            }
            i = 0;
            while (i < ((List)valuesTrace2.get(0)).size()) {
                ArrayList<Value> stateValues = new ArrayList<Value>();
                for (List l2 : valuesTrace2) {
                    stateValues.add((Value)l2.get(i));
                }
                stateTrace2.add(stateValues);
                ++i;
            }
            ArrayList allStates = new ArrayList(stateTrace1);
            allStates.addAll(stateTrace2);
            List<List<List<Value<?>>>> equivalenceClasses = this.computeEquivalenceClasses(allStates);
            this.diffs.addAll(this.computeDiff(stateTrace1, stateTrace2, equivalenceClasses));
        } else {
            this.eqGroup.stream().findAny().ifPresent(p -> {
                int i = 0;
                while (i < ((List)p.getKey()).size()) {
                    this.diffs.add(new Diff(Diff.DiffKind.EQ, i, i));
                    ++i;
                }
            });
        }
    }

    private List<List<List<Value<?>>>> computeEquivalenceClasses(List<List<Value<?>>> states) {
        ArrayList<Pair> stateToValueIndexes = new ArrayList<Pair>();
        ArrayList observedValues = new ArrayList();
        for (List<Value<?>> state : states) {
            ArrayList<Integer> valueIndexes = new ArrayList<Integer>();
            stateToValueIndexes.add(new Pair(state, valueIndexes));
            int i = 0;
            while (i < state.size()) {
                Value<?> value = state.get(i);
                int idx = -1;
                int j = 0;
                while (j < observedValues.size()) {
                    Value<?> v2;
                    Value v1 = (Value)observedValues.get(j);
                    if (this.compareEObjects((EObject)v1, (EObject)(v2 = value))) {
                        idx = j;
                        break;
                    }
                    ++j;
                }
                if (idx != -1) {
                    valueIndexes.add(idx);
                } else {
                    valueIndexes.add(observedValues.size());
                    observedValues.add(value);
                }
                ++i;
            }
        }
        List distinctClasses = stateToValueIndexes.stream().map(p -> (List)p.getValue()).distinct().collect(Collectors.toList());
        HashMap result = new HashMap();
        stateToValueIndexes.forEach(p -> {
            List state = (List)p.getKey();
            List indexes = (List)p.getValue();
            int v = distinctClasses.indexOf(indexes);
            ArrayList<List> equivalentStates = (ArrayList<List>)result.get(v);
            if (equivalentStates == null) {
                equivalentStates = new ArrayList<List>();
                result.put(v, equivalentStates);
            }
            if (equivalentStates.isEmpty()) {
                equivalentStates.add(state);
            } else if (states.indexOf(state) < states.indexOf(equivalentStates.get(0))) {
                equivalentStates.add(0, state);
            } else {
                equivalentStates.add(state);
            }
        });
        return result.values().stream().collect(Collectors.toList());
    }

    private int[][] alignTraces(List<List<Value<?>>> states1, List<List<Value<?>>> states2, Collection<List<List<Value<?>>>> classes) {
        int j;
        HashMap stateToEquivalentStates = new HashMap();
        classes.forEach(l -> l.forEach(s -> {
            ArrayList equivalentStates = new ArrayList(l);
            equivalentStates.remove(s);
            stateToEquivalentStates.put(s, equivalentStates);
        }));
        int[][] m = new int[states1.size() + 1][states2.size() + 1];
        int i = 0;
        while (i < m.length) {
            m[i][0] = i;
            ++i;
        }
        i = 1;
        while (i < m[0].length) {
            m[0][i] = i;
            ++i;
        }
        int[][] cost = new int[states1.size()][states2.size()];
        int i2 = 0;
        while (i2 < cost.length) {
            j = 0;
            while (j < cost[0].length) {
                List<Value<?>> s1 = states1.get(i2);
                List<Value<?>> s2 = states2.get(j);
                List equivalentStates = (List)stateToEquivalentStates.get(s1);
                cost[i2][j] = equivalentStates.contains(s2) ? 0 : 1;
                ++j;
            }
            ++i2;
        }
        i2 = 1;
        while (i2 < m.length) {
            j = 1;
            while (j < m[1].length) {
                int deletion = m[i2 - 1][j] + 1;
                int insertion = m[i2][j - 1] + 1;
                int substitution = m[i2 - 1][j - 1] + cost[i2 - 1][j - 1];
                m[i2][j] = Math.min(Math.min(insertion, deletion), substitution);
                ++j;
            }
            ++i2;
        }
        return m;
    }

    public List<Diff> computeDiff(List<List<Value<?>>> states1, List<List<Value<?>>> states2, Collection<List<List<Value<?>>>> classes) {
        int[][] comparisonMatrix = this.alignTraces(states1, states2, classes);
        int[][] highlightedCells = new int[comparisonMatrix.length][comparisonMatrix[0].length];
        int i = comparisonMatrix.length - 1;
        int j = comparisonMatrix[0].length - 1;
        ArrayList<Diff> diffs = new ArrayList<Diff>();
        while (i > 0 && j > 0) {
            int current = comparisonMatrix[i][j];
            int deletion = comparisonMatrix[i - 1][j];
            int insertion = comparisonMatrix[i][j - 1];
            int substitution = comparisonMatrix[i - 1][j - 1];
            int min = Math.min(deletion, Math.min(insertion, substitution));
            highlightedCells[i][j] = 1;
            if (min == substitution) {
                diffs.add(new Diff(current == substitution ? Diff.DiffKind.EQ : Diff.DiffKind.SUBST, i - 1, j - 1));
                --i;
                --j;
                continue;
            }
            if (min == deletion) {
                diffs.add(new Diff(Diff.DiffKind.DEL, i - 1, j - 1));
                --i;
                continue;
            }
            diffs.add(new Diff(Diff.DiffKind.IN, i - 1, j - 1));
            --j;
        }
        Collections.reverse(diffs);
        return diffs;
    }
}

