/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.util;

import java.util.EnumSet;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.klayoutdata.KEdgeLayout;
import org.eclipse.elk.core.klayoutdata.KInsets;
import org.eclipse.elk.core.klayoutdata.KPoint;
import org.eclipse.elk.core.klayoutdata.KShapeLayout;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.EdgeRouting;
import org.eclipse.elk.core.options.SizeConstraint;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.KEdge;
import org.eclipse.elk.graph.KLabel;
import org.eclipse.elk.graph.KNode;
import org.eclipse.elk.graph.KPort;

public class FixedLayoutProvider
extends AbstractLayoutProvider {
    public static final String ID = "org.eclipse.elk.alg.fixed";
    private static final float DEF_BORDER_SPACING = 15.0f;

    @Override
    public void layout(KNode layoutNode, IElkProgressMonitor progressMonitor) {
        Float borderSpacing;
        progressMonitor.begin("Fixed Layout", 1.0f);
        KShapeLayout parentLayout = (KShapeLayout)layoutNode.getData(KShapeLayout.class);
        EdgeRouting edgeRouting = (EdgeRouting)((Object)parentLayout.getProperty(CoreOptions.EDGE_ROUTING));
        float maxx = 0.0f;
        float maxy = 0.0f;
        for (KNode node : layoutNode.getChildren()) {
            KShapeLayout nodeLayout = (KShapeLayout)node.getData(KShapeLayout.class);
            Object pos = (KVector)nodeLayout.getProperty(CoreOptions.POSITION);
            if (pos != null) {
                nodeLayout.applyVector((KVector)pos);
                if (((EnumSet)nodeLayout.getProperty(CoreOptions.NODE_SIZE_CONSTRAINTS)).contains((Object)SizeConstraint.MINIMUM_SIZE)) {
                    float height;
                    float width;
                    KVector minSize = (KVector)nodeLayout.getProperty(CoreOptions.NODE_SIZE_MINIMUM);
                    if (minSize == null) {
                        width = ((Float)nodeLayout.getProperty(CoreOptions.NODE_SIZE_MIN_WIDTH)).floatValue();
                        height = ((Float)nodeLayout.getProperty(CoreOptions.NODE_SIZE_MIN_HEIGHT)).floatValue();
                    } else {
                        width = (float)minSize.x;
                        height = (float)minSize.y;
                    }
                    if (width > 0.0f && height > 0.0f) {
                        ElkUtil.resizeNode(node, width, height, true, true);
                    }
                }
            }
            maxx = Math.max(maxx, nodeLayout.getXpos() + nodeLayout.getWidth());
            maxy = Math.max(maxy, nodeLayout.getYpos() + nodeLayout.getHeight());
            for (KLabel label : node.getLabels()) {
                KShapeLayout labelLayout = (KShapeLayout)label.getData(KShapeLayout.class);
                pos = (KVector)labelLayout.getProperty(CoreOptions.POSITION);
                if (pos != null) {
                    labelLayout.applyVector((KVector)pos);
                }
                maxx = Math.max(maxx, nodeLayout.getXpos() + labelLayout.getXpos() + labelLayout.getWidth());
                maxy = Math.max(maxy, nodeLayout.getYpos() + labelLayout.getYpos() + labelLayout.getHeight());
            }
            for (KPort port : node.getPorts()) {
                KShapeLayout portLayout = (KShapeLayout)port.getData(KShapeLayout.class);
                pos = (KVector)portLayout.getProperty(CoreOptions.POSITION);
                if (pos != null) {
                    portLayout.applyVector((KVector)pos);
                }
                float portx = nodeLayout.getXpos() + portLayout.getXpos();
                float porty = nodeLayout.getYpos() + portLayout.getYpos();
                maxx = Math.max(maxx, portx + portLayout.getWidth());
                maxy = Math.max(maxy, porty + portLayout.getHeight());
                for (KLabel label : port.getLabels()) {
                    KShapeLayout labelLayout = (KShapeLayout)label.getData(KShapeLayout.class);
                    pos = (KVector)labelLayout.getProperty(CoreOptions.POSITION);
                    if (pos != null) {
                        labelLayout.applyVector((KVector)pos);
                    }
                    maxx = Math.max(maxx, portx + labelLayout.getXpos() + labelLayout.getWidth());
                    maxy = Math.max(maxy, porty + labelLayout.getYpos() + labelLayout.getHeight());
                }
            }
            for (KEdge edge : node.getOutgoingEdges()) {
                KVector maxv = this.processEdge(edge, edgeRouting);
                maxx = Math.max(maxx, (float)maxv.x);
                maxy = Math.max(maxy, (float)maxv.y);
            }
            for (KEdge edge : node.getIncomingEdges()) {
                if (edge.getSource().getParent() == layoutNode) continue;
                KVector maxv = this.processEdge(edge, edgeRouting);
                maxx = Math.max(maxx, (float)maxv.x);
                maxy = Math.max(maxy, (float)maxv.y);
            }
        }
        if (edgeRouting == EdgeRouting.ORTHOGONAL) {
            for (KNode node : layoutNode.getChildren()) {
                for (KEdge edge : node.getOutgoingEdges()) {
                    this.generateJunctionPoints(edge);
                }
            }
        }
        if ((borderSpacing = (Float)parentLayout.getProperty(CoreOptions.SPACING_BORDER)) == null || borderSpacing.floatValue() < 0.0f) {
            borderSpacing = Float.valueOf(15.0f);
        }
        KInsets insets = parentLayout.getInsets();
        float newWidth = maxx + borderSpacing.floatValue() + insets.getLeft() + insets.getRight();
        float newHeight = maxy + borderSpacing.floatValue() + insets.getTop() + insets.getBottom();
        ElkUtil.resizeNode(layoutNode, newWidth, newHeight, true, true);
        progressMonitor.done();
    }

    private KVector processEdge(KEdge edge, EdgeRouting edgeRouting) {
        KEdgeLayout edgeLayout = (KEdgeLayout)edge.getData(KEdgeLayout.class);
        boolean sameHierarchy = edge.getSource().getParent() == edge.getTarget().getParent();
        KVector maxv = new KVector();
        KVectorChain bendPoints = (KVectorChain)edgeLayout.getProperty(CoreOptions.BEND_POINTS);
        if (bendPoints != null && bendPoints.size() >= 2) {
            edgeLayout.applyVectorChain(bendPoints);
        }
        if (sameHierarchy) {
            for (KPoint point : edgeLayout.getBendPoints()) {
                maxv.x = Math.max(maxv.x, (double)point.getX());
                maxv.y = Math.max(maxv.y, (double)point.getY());
            }
        }
        for (KLabel label : edge.getLabels()) {
            KShapeLayout labelLayout = (KShapeLayout)label.getData(KShapeLayout.class);
            KVector pos = (KVector)labelLayout.getProperty(CoreOptions.POSITION);
            if (pos != null) {
                labelLayout.applyVector(pos);
            }
            if (!sameHierarchy) continue;
            maxv.x = Math.max(maxv.x, (double)(labelLayout.getXpos() + labelLayout.getWidth()));
            maxv.y = Math.max(maxv.y, (double)(labelLayout.getYpos() + labelLayout.getHeight()));
        }
        return maxv;
    }

    private void generateJunctionPoints(KEdge edge) {
        KEdgeLayout edgeLayout = (KEdgeLayout)edge.getData(KEdgeLayout.class);
        KVectorChain junctionPoints = ElkUtil.determineJunctionPoints(edge);
        if (junctionPoints.isEmpty()) {
            edgeLayout.setProperty(CoreOptions.JUNCTION_POINTS, null);
        } else {
            edgeLayout.setProperty(CoreOptions.JUNCTION_POINTS, junctionPoints);
        }
    }
}

