/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core;

import org.eclipse.elk.graph.KGraphElement;

public class GraphIssue {
    private final KGraphElement element;
    private final String message;
    private final Severity severity;

    public GraphIssue(KGraphElement element, String message, Severity severity) {
        if (message == null || severity == null) {
            throw new NullPointerException();
        }
        this.element = element;
        this.message = message;
        this.severity = severity;
    }

    public KGraphElement getElement() {
        return this.element;
    }

    public String getMessage() {
        return this.message;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public boolean equals(Object obj) {
        if (obj instanceof GraphIssue) {
            GraphIssue other = (GraphIssue)obj;
            return this.element == other.element && this.message.equals(other.message) && this.severity == other.severity;
        }
        return false;
    }

    public int hashCode() {
        return this.element.hashCode() ^ this.message.hashCode() ^ this.severity.hashCode();
    }

    public String toString() {
        return String.valueOf(this.severity.toString()) + ": " + this.message + " (" + this.element + ")";
    }

    public static enum Severity {
        ERROR,
        WARNING;


        public String getUserString() {
            switch (this) {
                case ERROR: {
                    return "Error";
                }
                case WARNING: {
                    return "Warning";
                }
            }
            throw new IllegalStateException("Missing case for " + (Object)((Object)this));
        }
    }
}

