/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.greedyswitch;

import java.util.List;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.intermediate.greedyswitch.CrossingMatrixFiller;
import org.eclipse.elk.alg.layered.intermediate.greedyswitch.InLayerEdgeTwoNodeCrossingCounter;
import org.eclipse.elk.alg.layered.intermediate.greedyswitch.NorthSouthEdgeNeighbouringNodeCrossingsCounter;
import org.eclipse.elk.alg.layered.properties.InternalProperties;
import org.eclipse.elk.core.options.PortSide;

public class SwitchDecider {
    private final LNode[] freeLayer;
    private final InLayerEdgeTwoNodeCrossingCounter inLayerCounter;
    private final NorthSouthEdgeNeighbouringNodeCrossingsCounter northSouthCounter;
    private final CrossingMatrixFiller crossingMatrixFiller;

    public SwitchDecider(int freeLayerIndex, LNode[][] graph, CrossingMatrixFiller crossingMatrixFiller) {
        this.crossingMatrixFiller = crossingMatrixFiller;
        if (freeLayerIndex >= graph.length) {
            throw new IndexOutOfBoundsException("Greedy SwitchDecider: Free layer layer not in graph.");
        }
        this.freeLayer = graph[freeLayerIndex];
        this.inLayerCounter = new InLayerEdgeTwoNodeCrossingCounter(this.freeLayer);
        this.northSouthCounter = new NorthSouthEdgeNeighbouringNodeCrossingsCounter(this.freeLayer);
    }

    public final void notifyOfSwitch(LNode upperNode, LNode lowerNode) {
        this.inLayerCounter.notifyOfSwitch(upperNode, lowerNode);
    }

    public final boolean doesSwitchReduceCrossings(int upperNodeIndex, int lowerNodeIndex) {
        if (this.constraintsPreventSwitch(upperNodeIndex, lowerNodeIndex)) {
            return false;
        }
        LNode upperNode = this.freeLayer[upperNodeIndex];
        LNode lowerNode = this.freeLayer[lowerNodeIndex];
        this.inLayerCounter.countCrossingsBetweenNodes(upperNode, lowerNode);
        this.northSouthCounter.countCrossings(upperNode, lowerNode);
        int upperLowerCrossings = this.crossingMatrixFiller.getCrossingMatrixEntry(upperNode, lowerNode) + this.inLayerCounter.getUpperLowerCrossings() + this.northSouthCounter.getUpperLowerCrossings();
        int lowerUpperCrossings = this.crossingMatrixFiller.getCrossingMatrixEntry(lowerNode, upperNode) + this.inLayerCounter.getLowerUpperCrossings() + this.northSouthCounter.getLowerUpperCrossings();
        return upperLowerCrossings > lowerUpperCrossings;
    }

    private boolean constraintsPreventSwitch(int nodeIndex, int lowerNodeIndex) {
        LNode upperNode = this.freeLayer[nodeIndex];
        LNode lowerNode = this.freeLayer[lowerNodeIndex];
        return this.haveSuccessorConstraints(upperNode, lowerNode) || this.haveLayoutUnitConstraints(upperNode, lowerNode) || this.areNormalAndNorthSouthPortDummy(upperNode, lowerNode);
    }

    private boolean haveSuccessorConstraints(LNode upperNode, LNode lowerNode) {
        List constraints = (List)upperNode.getProperty(InternalProperties.IN_LAYER_SUCCESSOR_CONSTRAINTS);
        boolean hasSuccessorConstraint = constraints != null && constraints.size() != 0 && constraints.contains((Object)lowerNode);
        return hasSuccessorConstraint;
    }

    private boolean haveLayoutUnitConstraints(LNode upperNode, LNode lowerNode) {
        boolean hasLayoutUnitConstraint;
        boolean neitherNodeIsLongEdgeDummy = upperNode.getType() != LNode.NodeType.LONG_EDGE && lowerNode.getType() != LNode.NodeType.LONG_EDGE;
        LNode upperLayoutUnit = (LNode)((Object)upperNode.getProperty(InternalProperties.IN_LAYER_LAYOUT_UNIT));
        LNode lowerLayoutUnit = (LNode)((Object)lowerNode.getProperty(InternalProperties.IN_LAYER_LAYOUT_UNIT));
        boolean nodesHaveLayoutUnits = this.partOfMultiNodeLayoutUnit(upperNode, upperLayoutUnit) || this.partOfMultiNodeLayoutUnit(lowerNode, lowerLayoutUnit);
        boolean areInDifferentLayoutUnits = upperLayoutUnit != lowerLayoutUnit;
        boolean upperNodeHasNorthernEdges = this.hasEdgesOnSide(upperNode, PortSide.NORTH);
        boolean lowerNodeHasSouthernEdges = this.hasEdgesOnSide(lowerNode, PortSide.SOUTH);
        boolean bl = hasLayoutUnitConstraint = nodesHaveLayoutUnits && areInDifferentLayoutUnits || upperNodeHasNorthernEdges || lowerNodeHasSouthernEdges;
        return neitherNodeIsLongEdgeDummy && hasLayoutUnitConstraint;
    }

    private boolean hasEdgesOnSide(LNode node, PortSide side) {
        Iterable<LPort> ports = node.getPorts(side);
        for (LPort port : ports) {
            if (port.getProperty(InternalProperties.PORT_DUMMY) == null && !port.getConnectedEdges().iterator().hasNext()) continue;
            return true;
        }
        return false;
    }

    private boolean partOfMultiNodeLayoutUnit(LNode node, LNode layoutUnit) {
        return layoutUnit != null && layoutUnit != node;
    }

    private boolean areNormalAndNorthSouthPortDummy(LNode upperNode, LNode lowerNode) {
        return this.isNorthSouthPortNode(upperNode) && this.isNormalNode(lowerNode) || this.isNorthSouthPortNode(lowerNode) && this.isNormalNode(upperNode);
    }

    private boolean isNormalNode(LNode node) {
        return node.getType() == LNode.NodeType.NORMAL;
    }

    private boolean isNorthSouthPortNode(LNode node) {
        return node.getType() == LNode.NodeType.NORTH_SOUTH_PORT;
    }

    public static enum CrossingCountSide {
        WEST,
        EAST;

    }
}

