/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.force.model;

import org.eclipse.elk.alg.force.graph.FGraph;
import org.eclipse.elk.alg.force.graph.FNode;
import org.eclipse.elk.alg.force.graph.FParticle;
import org.eclipse.elk.alg.force.model.AbstractForceModel;
import org.eclipse.elk.alg.force.properties.ForceOptions;
import org.eclipse.elk.core.math.KVector;

public final class FruchtermanReingoldModel
extends AbstractForceModel {
    private static final double SPACING_FACTOR = 0.01;
    private static final double ZERO_FACTOR = 100.0;
    private double temperature = ((Float)ForceOptions.TEMPERATURE.getDefault()).floatValue();
    private double threshold;
    private double k;

    @Override
    protected void initialize(FGraph graph) {
        super.initialize(graph);
        this.temperature = ((Float)graph.getProperty(ForceOptions.TEMPERATURE)).doubleValue();
        this.threshold = this.temperature / (double)((Integer)graph.getProperty(ForceOptions.ITERATIONS)).intValue();
        int n = graph.getNodes().size();
        double totalWidth = 0.0;
        double totalHeight = 0.0;
        for (FNode v : graph.getNodes()) {
            totalWidth += v.getSize().x;
            totalHeight += v.getSize().y;
        }
        double area = totalWidth * totalHeight;
        double c = (double)((Float)graph.getProperty(ForceOptions.SPACING_NODE)).floatValue() * 0.01;
        this.k = Math.sqrt(area / (double)(2 * n)) * c;
    }

    @Override
    protected boolean moreIterations(int count) {
        return this.temperature > 0.0;
    }

    @Override
    protected KVector calcDisplacement(FParticle forcer, FParticle forcee) {
        FruchtermanReingoldModel.avoidSamePosition(this.getRandom(), forcer, forcee);
        KVector displacement = forcee.getPosition().clone().sub(forcer.getPosition());
        double length = displacement.length();
        double d = Math.max(0.0, length - forcer.getRadius() - forcee.getRadius());
        double force = FruchtermanReingoldModel.repulsive(d, this.k) * (double)((Integer)forcer.getProperty(ForceOptions.PRIORITY)).intValue();
        int connection = this.getGraph().getConnection(forcer, forcee);
        if (connection > 0) {
            force -= FruchtermanReingoldModel.attractive(d, this.k) * (double)connection;
        }
        displacement.scale(force * this.temperature / length);
        return displacement;
    }

    @Override
    protected void iterationDone() {
        super.iterationDone();
        this.temperature -= this.threshold;
    }

    private static double repulsive(double d, double k) {
        if (d > 0.0) {
            return k * k / d;
        }
        return k * k * 100.0;
    }

    public static double attractive(double d, double k) {
        return d * d / k;
    }
}

