/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt.cocoa;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Provider;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.statusreporter.StatusReporter;
import org.eclipse.e4.ui.bindings.EBindingService;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MParameter;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.renderers.swt.cocoa.SWTCocoaEnhancerDelegate;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.cocoa.NSButton;
import org.eclipse.swt.internal.cocoa.NSControl;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSToolbar;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.osgi.service.event.Event;

public class CocoaUIHandler {
    private static final String COMMAND_ID_ABOUT = "org.eclipse.ui.help.aboutAction";
    private static final String COMMAND_ID_PREFERENCES = "org.eclipse.ui.window.preferences";
    private static final String COMMAND_ID_QUIT = "org.eclipse.ui.file.exit";
    private static final String COMMAND_PARAMETER_ID_MAY_PROMPT = "mayPrompt";
    private static final String COMMAND_ID_TOGGLE_COOLBAR = "org.eclipse.ui.ToggleCoolbarAction";
    static long sel_toolbarButtonClicked_;
    private static final long NSWindowToolbarButton = 3L;
    static Callback proc3Args;
    static final byte[] SWT_OBJECT;
    SWTCocoaEnhancerDelegate delegate;
    private long delegateJniRef;
    protected MCommand closeDialogCommand;
    @Inject
    protected MApplication app;
    @Inject
    protected Provider<StatusReporter> statusReporter;
    @Inject
    protected ECommandService commandService;
    @Inject
    protected EHandlerService handlerService;
    @Inject
    protected EModelService modelService;
    @Inject
    protected EBindingService bindingService;
    @Inject
    protected IEventBroker eventBroker;
    @Inject
    @Optional
    protected IPresentationEngine engine;

    static {
        byte[] byArray = new byte[11];
        byArray[0] = 83;
        byArray[1] = 87;
        byArray[2] = 84;
        byArray[3] = 95;
        byArray[4] = 79;
        byArray[5] = 66;
        byArray[6] = 74;
        byArray[7] = 69;
        byArray[8] = 67;
        byArray[9] = 84;
        SWT_OBJECT = byArray;
    }

    private void registerSelectors() {
        try {
            if (sel_toolbarButtonClicked_ == 0L) {
                sel_toolbarButtonClicked_ = this.registerName("toolbarButtonClicked:");
                this.setupDelegateClass();
            }
        }
        catch (Exception e) {
            this.log(e);
        }
    }

    private void setupDelegateClass() throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchFieldException {
        byte[] byArray = new byte[2];
        byArray[0] = 42;
        byte[] types = byArray;
        int size = C.PTR_SIZEOF;
        int align = C.PTR_SIZEOF == 4 ? 2 : 3;
        Class<CocoaUIHandler> clazz = CocoaUIHandler.class;
        proc3Args = new Callback(clazz, "actionProc", 3);
        Method getAddress = Callback.class.getMethod("getAddress", new Class[0]);
        Object object = getAddress.invoke((Object)proc3Args, new Object[0]);
        long proc3 = this.convertToLong(object);
        if (proc3 == 0L) {
            SWT.error((int)3);
        }
        Field field = OS.class.getField("class_NSObject");
        Object fieldObj = field.get(OS.class);
        object = CocoaUIHandler.invokeMethod(OS.class, "objc_allocateClassPair", new Object[]{fieldObj, "SWTCocoaEnhancerDelegate", CocoaUIHandler.wrapPointer(0L)});
        long cls = this.convertToLong(object);
        CocoaUIHandler.invokeMethod(OS.class, "class_addIvar", new Object[]{CocoaUIHandler.wrapPointer(cls), SWT_OBJECT, CocoaUIHandler.wrapPointer(size), new Byte((byte)align), types});
        CocoaUIHandler.invokeMethod(OS.class, "class_addMethod", new Object[]{CocoaUIHandler.wrapPointer(cls), CocoaUIHandler.wrapPointer(sel_toolbarButtonClicked_), CocoaUIHandler.wrapPointer(proc3), "@:@"});
        CocoaUIHandler.invokeMethod(OS.class, "objc_registerClassPair", new Object[]{CocoaUIHandler.wrapPointer(cls)});
    }

    private long registerName(String name) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<OS> clazz = OS.class;
        Object object = CocoaUIHandler.invokeMethod(clazz, "sel_registerName", new Object[]{name});
        return this.convertToLong(object);
    }

    @PostConstruct
    public void init() {
        this.registerSelectors();
        final Display display = Display.getDefault();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                CocoaUIHandler.this.allocateDelegate(display);
                CocoaUIHandler.this.hookApplicationMenu();
                CocoaUIHandler.this.processModelMenus();
                for (MWindow window : CocoaUIHandler.this.app.getChildren()) {
                    CocoaUIHandler.this.modifyWindowShell(window);
                }
            }
        });
    }

    protected void allocateDelegate(Display display) {
        try {
            this.delegate = new SWTCocoaEnhancerDelegate();
            this.delegate.alloc().init();
            Method method = OS.class.getMethod("NewGlobalRef", Object.class);
            Object object = method.invoke(OS.class, this);
            this.delegateJniRef = this.convertToLong(object);
        }
        catch (Exception e) {
            this.log(e);
        }
        if (this.delegateJniRef == 0L) {
            SWT.error((int)2);
        }
        try {
            Field idField = SWTCocoaEnhancerDelegate.class.getField("id");
            Object idValue = idField.get((Object)this.delegate);
            CocoaUIHandler.invokeMethod(OS.class, "object_setInstanceVariable", new Object[]{idValue, SWT_OBJECT, CocoaUIHandler.wrapPointer(this.delegateJniRef)});
            display.disposeExec(new Runnable(){

                @Override
                public void run() {
                    if (CocoaUIHandler.this.delegateJniRef != 0L) {
                        try {
                            CocoaUIHandler.invokeMethod(OS.class, "DeleteGlobalRef", new Object[]{CocoaUIHandler.wrapPointer(CocoaUIHandler.this.delegateJniRef)});
                        }
                        catch (Exception e) {
                            CocoaUIHandler.this.log(e);
                        }
                    }
                    CocoaUIHandler.this.delegateJniRef = 0L;
                    if (CocoaUIHandler.this.delegate != null) {
                        CocoaUIHandler.this.delegate.release();
                    }
                    CocoaUIHandler.this.delegate = null;
                }
            });
        }
        catch (Exception e) {
            this.log(e);
        }
    }

    protected void processModelMenus() {
        for (MWindow window : this.app.getChildren()) {
            this.redirectHandledMenuItems(window.getMainMenu());
        }
        for (MMenuContribution contribution : this.app.getMenuContributions()) {
            this.processMenuContribution(contribution);
        }
    }

    private void processMenuContribution(MMenuContribution contribution) {
        for (MMenuElement elmt : contribution.getChildren()) {
            if (elmt instanceof MMenu) {
                this.redirectHandledMenuItems((MMenu)elmt);
                continue;
            }
            if (!(elmt instanceof MMenuItem)) continue;
            this.redirectHandledMenuItem((MMenuItem)elmt);
        }
    }

    void log(Exception e) {
        ((StatusReporter)this.statusReporter.get()).report((IStatus)new Status(2, "org.eclipse.e4.ui.workbench.renderers.swt.cocoa", "Exception occurred during CocoaUI processing", (Throwable)e), 32, new Object[0]);
    }

    @Inject
    @Optional
    private void monitorShellTopicChanges(@UIEventTopic(value="org/eclipse/e4/ui/model/ui/UIElement/widget/*") Event event) {
        if (event.getProperty("ChangedElement") instanceof MWindow && event.getProperty("NewValue") != null) {
            MWindow window = (MWindow)event.getProperty("ChangedElement");
            this.modifyWindowShell(window);
            this.updateFullScreenStatus(window);
        }
    }

    @Inject
    @Optional
    private void monitorMainMenuTopicChanges(@UIEventTopic(value="org/eclipse/e4/ui/model/basic/Window/mainMenu/*") Event event) {
        Object newValue = event.getProperty("NewValue");
        Object oldValue = event.getProperty("OldValue");
        Object element = event.getProperty("ChangedElement");
        if (element instanceof MWindow && oldValue == null && newValue instanceof MMenu) {
            this.modifyWindowShell((MWindow)element);
        }
    }

    @Inject
    @Optional
    private void monitorMenuContributionsChanges(@UIEventTopic(value="org/eclipse/e4/ui/model/menu/MenuContributions/menuContributions/*") Event event) {
        if (event.getProperty("ChangedElement") instanceof MMenuContribution && event.getProperty("NewValue") != null) {
            MMenuContribution contribution = (MMenuContribution)event.getProperty("ChangedElement");
            this.processMenuContribution(contribution);
        }
    }

    @Inject
    @Optional
    private void monitorCommandChanges(@UIEventTopic(value="org/eclipse/e4/ui/model/application/Application/commands/*") Event event) {
        MCommand cmd;
        String id;
        if (event.getProperty("ChangedElement") instanceof MCommand && (COMMAND_ID_ABOUT.equals(id = (cmd = (MCommand)event.getProperty("ChangedElement")).getElementId()) || COMMAND_ID_PREFERENCES.equals(id) || COMMAND_ID_QUIT.equals(id))) {
            this.hookApplicationMenu();
        }
    }

    @Inject
    @Optional
    private void monitorApplicationTagChanges(@UIEventTopic(value="org/eclipse/e4/ui/model/application/ApplicationElement/tags/*") Event event) {
        if (event.getProperty("ChangedElement") instanceof MWindow) {
            MWindow window = (MWindow)event.getProperty("ChangedElement");
            this.updateFullScreenStatus(window);
        }
    }

    protected void updateFullScreenStatus(MWindow window) {
        if (OS.VERSION < 4208 || !(window.getWidget() instanceof Shell)) {
            return;
        }
    }

    protected void modifyWindowShell(MWindow window) {
        if (window.getWidget() == null) {
            return;
        }
        if (window.getMainMenu() == null) {
            return;
        }
        this.redirectHandledMenuItems(window.getMainMenu());
        if (OS.VERSION >= 4208) {
            return;
        }
        boolean trimInitiallyVisible = false;
        if (window instanceof MTrimmedWindow && !((MTrimmedWindow)window).getTrimBars().isEmpty()) {
            for (MTrimBar tb : ((MTrimmedWindow)window).getTrimBars()) {
                if (!tb.isVisible()) continue;
                trimInitiallyVisible = true;
            }
        }
        if (trimInitiallyVisible) {
            Shell shell = ((Control)window.getWidget()).getShell();
            NSWindow nsWindow = shell.view.window();
            NSToolbar dummyBar = new NSToolbar();
            dummyBar.alloc();
            dummyBar.initWithIdentifier(NSString.stringWith((String)"SWTToolbar"));
            dummyBar.setVisible(false);
            nsWindow.setToolbar(dummyBar);
            dummyBar.release();
            nsWindow.setShowsToolbarButton(true);
            try {
                Object fieldValue = CocoaUIHandler.wrapPointer(3L);
                NSButton toolbarButton = (NSButton)CocoaUIHandler.invokeMethod(NSWindow.class, nsWindow, "standardWindowButton", new Object[]{fieldValue});
                if (toolbarButton != null) {
                    toolbarButton.setTarget((id)this.delegate);
                    CocoaUIHandler.invokeMethod(NSControl.class, toolbarButton, "setAction", new Object[]{CocoaUIHandler.wrapPointer(sel_toolbarButtonClicked_)});
                }
            }
            catch (Exception e) {
                this.log(e);
            }
        }
    }

    private void redirectHandledMenuItems(MMenu menu) {
        if (menu == null) {
            return;
        }
        for (MMenuElement elmt : menu.getChildren()) {
            if (elmt instanceof MMenu) {
                this.redirectHandledMenuItems((MMenu)elmt);
                continue;
            }
            if (!(elmt instanceof MMenuItem)) continue;
            this.redirectHandledMenuItem((MMenuItem)elmt);
        }
    }

    private void redirectHandledMenuItem(MMenuItem item) {
        String elmtId = item.getElementId();
        if (elmtId != null && (elmtId.equals(COMMAND_ID_ABOUT) || elmtId.equals(COMMAND_ID_PREFERENCES) || elmtId.equals(COMMAND_ID_QUIT))) {
            item.setVisible(false);
            item.setToBeRendered(false);
            if (this.engine != null) {
                this.engine.removeGui((MUIElement)item);
            }
        } else if (item instanceof MHandledMenuItem) {
            MHandledMenuItem mhmi = (MHandledMenuItem)item;
            String string = elmtId = mhmi.getCommand() == null ? null : mhmi.getCommand().getElementId();
            if (elmtId != null && (elmtId.equals(COMMAND_ID_ABOUT) || elmtId.equals(COMMAND_ID_PREFERENCES) || elmtId.equals(COMMAND_ID_QUIT))) {
                item.setVisible(false);
                item.setToBeRendered(false);
                if (this.engine != null) {
                    this.engine.removeGui((MUIElement)item);
                }
            }
        }
    }

    private void hookApplicationMenu() {
        this.hookAppMenuItem(-6, COMMAND_ID_QUIT);
        this.hookAppMenuItem(-2, COMMAND_ID_PREFERENCES);
        this.hookAppMenuItem(-1, COMMAND_ID_ABOUT);
    }

    private void hookAppMenuItem(int menuItemId, final String commandId) {
        Menu[] menusToCheck;
        Display display = Display.getDefault();
        Menu[] menuArray = menusToCheck = new Menu[]{display.getMenuBar(), display.getSystemMenu()};
        int n = menusToCheck.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem item;
            Menu topLevelMenu = menuArray[n2];
            if (topLevelMenu != null && (item = this.findMenuItemById(topLevelMenu, menuItemId)) != null) {
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (CocoaUIHandler.this.runCommand(commandId) || CocoaUIHandler.this.runAction(commandId)) {
                            e.doit = false;
                        }
                    }
                });
            }
            ++n2;
        }
    }

    private MenuItem findMenuItemById(Menu menu, int menuItemId) {
        MenuItem[] menuItemArray = menu.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem mi = menuItemArray[n2];
            if (mi.getID() == menuItemId) {
                return mi;
            }
            ++n2;
        }
        return null;
    }

    private boolean runAction(String actionId) {
        MWindow window = (MWindow)this.app.getSelectedElement();
        if (window == null) {
            return false;
        }
        MMenu topMenu = window.getMainMenu();
        MMenuItem item = this.findAction(actionId, topMenu);
        if (item == null || !item.isEnabled()) {
            return false;
        }
        try {
            Display display = Display.getDefault();
            MenuItem aboutItem = null;
            boolean aboutEnabled = true;
            MenuItem prefsItem = null;
            boolean prefsEnabled = true;
            Menu appMenuBar = display.getMenuBar();
            if (appMenuBar != null) {
                aboutItem = this.findMenuItemById(appMenuBar, -1);
                if (aboutItem != null) {
                    aboutEnabled = aboutItem.getEnabled();
                    aboutItem.setEnabled(false);
                }
                if ((prefsItem = this.findMenuItemById(appMenuBar, -2)) != null) {
                    prefsEnabled = prefsItem.getEnabled();
                    prefsItem.setEnabled(false);
                }
            }
            try {
                this.simulateMenuSelection(item);
            }
            finally {
                if (prefsItem != null) {
                    prefsItem.setEnabled(prefsEnabled);
                }
                if (aboutItem != null) {
                    aboutItem.setEnabled(aboutEnabled);
                }
            }
        }
        catch (Exception e) {
            this.log(e);
        }
        return true;
    }

    private void simulateMenuSelection(MMenuItem item) {
        IEclipseContext lclContext = this.getContext((MUIElement)item);
        if (item instanceof MDirectMenuItem) {
            MDirectMenuItem dmi = (MDirectMenuItem)item;
            if (dmi.getObject() == null) {
                IContributionFactory cf = (IContributionFactory)lclContext.get(IContributionFactory.class.getName());
                dmi.setObject(cf.create(dmi.getContributionURI(), lclContext));
            }
            lclContext.set(MItem.class.getName(), (Object)item);
            ContextInjectionFactory.invoke((Object)dmi.getObject(), Execute.class, (IEclipseContext)lclContext);
            lclContext.remove(MItem.class.getName());
        } else if (item instanceof MHandledMenuItem) {
            MHandledMenuItem hmi = (MHandledMenuItem)item;
            EHandlerService service = (EHandlerService)lclContext.get(EHandlerService.class.getName());
            ParameterizedCommand cmd = hmi.getWbCommand();
            if (cmd == null) {
                cmd = this.generateParameterizedCommand((MHandledItem)hmi);
            }
            lclContext.set(MItem.class.getName(), (Object)item);
            service.executeHandler(cmd);
            lclContext.remove(MItem.class.getName());
        } else {
            ((StatusReporter)this.statusReporter.get()).report((IStatus)new Status(2, "org.eclipse.e4.ui.workbench.renderers.swt.cocoa", "Unhandled menu type: " + item.getClass() + ": " + item), 32, new Object[0]);
        }
    }

    private IEclipseContext getContext(MUIElement element) {
        if (element instanceof MContext) {
            return ((MContext)element).getContext();
        }
        return this.modelService.getContainingContext(element);
    }

    private boolean runCommand(String commandId) {
        if (this.commandService == null || this.handlerService == null) {
            return false;
        }
        Map<String, String> params = COMMAND_ID_QUIT.equals(commandId) ? Collections.singletonMap(COMMAND_PARAMETER_ID_MAY_PROMPT, "true") : null;
        ParameterizedCommand cmd = this.commandService.createCommand(commandId, params);
        if (cmd == null) {
            return false;
        }
        this.handlerService.executeHandler(cmd);
        return true;
    }

    private MMenuItem findAction(String actionId, MMenu menu) {
        if (menu == null) {
            return null;
        }
        for (MMenuElement item : menu.getChildren()) {
            MMenuItem found;
            if (item instanceof MMenuItem) {
                MHandledMenuItem mhmi;
                MMenuItem mmi = (MMenuItem)item;
                if (mmi.getElementId() != null && mmi.getElementId().equals(actionId)) {
                    return mmi;
                }
                if (!(mmi instanceof MHandledMenuItem) || (mhmi = (MHandledMenuItem)mmi).getCommand() == null || !actionId.equals(mhmi.getCommand().getElementId())) continue;
                return mmi;
            }
            if (!(item instanceof MMenu) || (found = this.findAction(actionId, (MMenu)item)) == null) continue;
            return found;
        }
        return null;
    }

    void toolbarButtonClicked(NSControl source) {
        try {
            NSWindow window = source.window();
            Field idField = NSWindow.class.getField("id");
            Object idValue = idField.get(window);
            Display display = Display.getCurrent();
            Widget widget = (Widget)CocoaUIHandler.invokeMethod(Display.class, display, "findWidget", new Object[]{idValue});
            if (!(widget instanceof Shell)) {
                return;
            }
            Shell shell = (Shell)widget;
            for (MWindow mwin : this.app.getChildren()) {
                if (mwin.getWidget() != shell || this.runCommand(COMMAND_ID_TOGGLE_COOLBAR)) continue;
                this.runAction(COMMAND_ID_TOGGLE_COOLBAR);
            }
        }
        catch (Exception e) {
            this.log(e);
        }
    }

    static int actionProc(int id2, int sel, int arg0) throws Exception {
        return (int)CocoaUIHandler.actionProc((long)id2, (long)sel, (long)arg0);
    }

    static long actionProc(long id2, long sel, long arg0) throws Exception {
        long[] jniRef = CocoaUIHandler.OS_object_getInstanceVariable(id2, SWT_OBJECT);
        if (jniRef[0] == 0L) {
            return 0L;
        }
        CocoaUIHandler delegate = (CocoaUIHandler)CocoaUIHandler.invokeMethod(OS.class, "JNIGetObject", new Object[]{CocoaUIHandler.wrapPointer(jniRef[0])});
        if (sel == sel_toolbarButtonClicked_) {
            NSControl source = CocoaUIHandler.new_NSControl(arg0);
            delegate.toolbarButtonClicked(source);
        }
        return 0L;
    }

    private static NSControl new_NSControl(long arg0) throws NoSuchMethodException, InstantiationException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<NSControl> clazz = NSControl.class;
        Class<Number> PTR_CLASS = C.PTR_SIZEOF == 8 ? Long.TYPE : Integer.TYPE;
        Constructor constructor = clazz.getConstructor(PTR_CLASS);
        return (NSControl)constructor.newInstance(CocoaUIHandler.wrapPointer(arg0));
    }

    private static long[] OS_object_getInstanceVariable(long delegateId, byte[] name) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        Class<Number> PTR_CLASS;
        Class<OS> clazz = OS.class;
        Method method = null;
        Class<Number> clazz2 = PTR_CLASS = C.PTR_SIZEOF == 8 ? Long.TYPE : Integer.TYPE;
        if (PTR_CLASS == Long.TYPE) {
            method = clazz.getMethod("object_getInstanceVariable", Long.TYPE, byte[].class, long[].class);
            long[] resultPtr = new long[1];
            method.invoke(null, new Long(delegateId), name, resultPtr);
            return resultPtr;
        }
        method = clazz.getMethod("object_getInstanceVariable", Integer.TYPE, byte[].class, int[].class);
        int[] resultPtr = new int[1];
        method.invoke(null, (int)delegateId, name, resultPtr);
        return new long[]{resultPtr[0]};
    }

    private long convertToLong(Object object) {
        if (object instanceof Integer) {
            Integer i = (Integer)object;
            return i.longValue();
        }
        if (object instanceof Long) {
            Long l = (Long)object;
            return l;
        }
        return 0L;
    }

    private static Object invokeMethod(Class<?> clazz, String methodName, Object[] args) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        return CocoaUIHandler.invokeMethod(clazz, null, methodName, args);
    }

    private static Object invokeMethod(Class<?> clazz, Object target, String methodName, Object[] args) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        Class[] signature = new Class[args.length];
        int i = 0;
        while (i < args.length) {
            Class<?> thisClass = args[i].getClass();
            signature[i] = thisClass == Integer.class ? Integer.TYPE : (thisClass == Long.class ? Long.TYPE : (thisClass == Byte.class ? Byte.TYPE : thisClass));
            ++i;
        }
        Method method = clazz.getMethod(methodName, signature);
        return method.invoke(target, args);
    }

    private static Object wrapPointer(long value) {
        Class<Number> PTR_CLASS;
        Class<Number> clazz = PTR_CLASS = C.PTR_SIZEOF == 8 ? Long.TYPE : Integer.TYPE;
        if (PTR_CLASS == Long.TYPE) {
            return new Long(value);
        }
        return (int)value;
    }

    private ParameterizedCommand generateParameterizedCommand(MHandledItem item) {
        HashMap<String, String> parameters = null;
        List modelParms = item.getParameters();
        if (modelParms != null && !modelParms.isEmpty()) {
            parameters = new HashMap<String, String>();
            for (MParameter mParm : modelParms) {
                parameters.put(mParm.getName(), mParm.getValue());
            }
        }
        ParameterizedCommand cmd = this.commandService.createCommand(item.getCommand().getElementId(), parameters);
        item.setWbCommand(cmd);
        return cmd;
    }
}

