/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.diverse.melange.lib;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import fr.inria.diverse.melange.lib.ModelUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.util.GenModelUtil;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.MapExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class EcoreExtensions {
    @Inject
    private ModelUtils modelUtils;

    public boolean isContainedBy(EObject children, EObject parent) {
        EObject iter = children.eContainer();
        while (iter != null) {
            boolean _equals = Objects.equal((Object)iter, (Object)parent);
            if (_equals) {
                return true;
            }
            iter = iter.eContainer();
        }
        return false;
    }

    public boolean emfEquals(EObject o1, EObject o2) {
        return EcoreUtil.equals((EObject)o1, (EObject)o2);
    }

    public String formatFeatureID(EClass cls, EStructuralFeature f) {
        StringConcatenation _builder = new StringConcatenation();
        String _camelToUnderscores = this.camelToUnderscores(cls.getName());
        _builder.append(_camelToUnderscores);
        _builder.append("__");
        String _camelToUnderscores_1 = this.camelToUnderscores(f.getName());
        _builder.append(_camelToUnderscores_1);
        return _builder.toString();
    }

    public String camelToUnderscores(String s) {
        return CodeGenUtil.format((String)s, (char)'_', (String)"", (boolean)true, (boolean)true).toUpperCase();
    }

    public Iterable<EClass> sortByClassInheritance(Iterable<EClass> classes) {
        Comparator<EClass> _function = new Comparator<EClass>(){

            @Override
            public int compare(EClass clsA, EClass clsB) {
                boolean _contains = clsA.getEAllSuperTypes().contains((Object)clsB);
                if (_contains) {
                    return -1;
                }
                boolean _contains_1 = clsB.getEAllSuperTypes().contains((Object)clsA);
                if (_contains_1) {
                    return 1;
                }
                return 0;
            }
        };
        return IterableExtensions.sortWith(classes, (Comparator)_function);
    }

    public Iterable<EOperation> sortByOverridingPriority(Iterable<EOperation> ops) {
        Comparator<EOperation> _function = new Comparator<EOperation>(){

            @Override
            public int compare(EOperation opA, EOperation opB) {
                EClassifier retA = opA.getEType();
                EClassifier retB = opB.getEType();
                if (retA instanceof EClass) {
                    if (!(retB instanceof EClass)) {
                        return 1;
                    }
                    boolean _contains = ((EClass)retA).getEAllSuperTypes().contains((Object)retB);
                    if (_contains) {
                        return -1;
                    }
                } else {
                    if (retB instanceof EClass) {
                        return -1;
                    }
                    return 1;
                }
                return 0;
            }
        };
        return IterableExtensions.sortWith(ops, (Comparator)_function);
    }

    public EPackage getRootPackage(EPackage pkg) {
        EPackage tmp = pkg;
        while (tmp.getESuperPackage() != null) {
            tmp = tmp.getESuperPackage();
        }
        return tmp;
    }

    public boolean isEcore(EModelElement m) {
        return m != null && this.isContainedBy((EObject)m, (EObject)EcorePackage.eINSTANCE);
    }

    public EPackage findSubPackage(EPackage root, final String fqn) {
        boolean _equals;
        if (root == null) {
            return null;
        }
        final String[] splitName = fqn.split("\\.");
        int _length = splitName.length;
        boolean bl = _equals = _length == 1;
        if (_equals) {
            Functions.Function1<EPackage, Boolean> _function = new Functions.Function1<EPackage, Boolean>(){

                public Boolean apply(EPackage it) {
                    String _name = it.getName();
                    return Objects.equal((Object)_name, (Object)fqn);
                }
            };
            return (EPackage)IterableExtensions.findFirst((Iterable)root.getESubpackages(), (Functions.Function1)_function);
        }
        Functions.Function1<EPackage, Boolean> _function_1 = new Functions.Function1<EPackage, Boolean>(){

            public Boolean apply(EPackage it) {
                String _name = it.getName();
                String _get = splitName[0];
                return Objects.equal((Object)_name, (Object)_get);
            }
        };
        EPackage subRoot = (EPackage)IterableExtensions.findFirst((Iterable)root.getESubpackages(), (Functions.Function1)_function_1);
        int _length_1 = splitName[0].length();
        int _plus = _length_1 + 1;
        String subFqn = fqn.substring(_plus);
        return this.findSubPackage(subRoot, subFqn);
    }

    public EClass getClass(EPackage pkg, final String clsName) {
        int indexOf = clsName.indexOf(".");
        if (indexOf == -1) {
            Functions.Function1<EClass, Boolean> _function = new Functions.Function1<EClass, Boolean>(){

                public Boolean apply(EClass it) {
                    String _name = it.getName();
                    return Objects.equal((Object)_name, (Object)clsName);
                }
            };
            return (EClass)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)pkg.getEClassifiers(), EClass.class), (Functions.Function1)_function);
        }
        final String withoutRoot = clsName.substring(indexOf + 1);
        int lastDot = withoutRoot.lastIndexOf(".");
        if (lastDot == -1) {
            Functions.Function1<EClass, Boolean> _function_1 = new Functions.Function1<EClass, Boolean>(){

                public Boolean apply(EClass it) {
                    String _name = it.getName();
                    return Objects.equal((Object)_name, (Object)withoutRoot);
                }
            };
            return (EClass)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)pkg.getEClassifiers(), EClass.class), (Functions.Function1)_function_1);
        }
        String subpack = withoutRoot.substring(0, lastDot);
        final String simpleName = withoutRoot.substring(lastDot + 1);
        EPackage ePack = this.findSubPackage(pkg, subpack);
        if (ePack == null) {
            return null;
        }
        Functions.Function1<EClass, Boolean> _function_2 = new Functions.Function1<EClass, Boolean>(){

            public Boolean apply(EClass it) {
                String _name = it.getName();
                return Objects.equal((Object)_name, (Object)simpleName);
            }
        };
        return (EClass)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)ePack.getEClassifiers(), EClass.class), (Functions.Function1)_function_2);
    }

    public EClass findClass(Set<EPackage> pkgs, final String clsName) {
        Functions.Function1<EPackage, EClass> _function = new Functions.Function1<EPackage, EClass>(){

            public EClass apply(EPackage it) {
                return EcoreExtensions.this.findClass(it, clsName);
            }
        };
        return (EClass)IterableExtensions.head((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map(pkgs, (Functions.Function1)_function)));
    }

    public EClass findClass(EPackage pkg, final String clsName) {
        if (clsName == null) {
            return null;
        }
        boolean _contains = clsName.contains(".");
        if (_contains) {
            return this.findQualifiedClass(pkg, clsName);
        }
        Functions.Function1<EClass, Boolean> _function = new Functions.Function1<EClass, Boolean>(){

            public Boolean apply(EClass it) {
                String _name = it.getName();
                return Objects.equal((Object)_name, (Object)clsName);
            }
        };
        return (EClass)IterableExtensions.findFirst(this.getAllClasses(pkg), (Functions.Function1)_function);
    }

    public EClass findQualifiedClass(EPackage rootPkg, final String qualifiedClsName) {
        if (qualifiedClsName == null || !qualifiedClsName.contains(".")) {
            return null;
        }
        String rootName = rootPkg.getName();
        boolean _startsWith = qualifiedClsName.startsWith(String.valueOf(rootName) + ".");
        if (_startsWith) {
            Functions.Function1<EClass, Boolean> _function = new Functions.Function1<EClass, Boolean>(){

                public Boolean apply(EClass it) {
                    String _uniqueId = EcoreExtensions.this.getUniqueId((ENamedElement)it);
                    return Objects.equal((Object)_uniqueId, (Object)qualifiedClsName);
                }
            };
            return (EClass)IterableExtensions.findFirst(this.getAllClasses(rootPkg), (Functions.Function1)_function);
        }
        Functions.Function1<EClass, Boolean> _function_1 = new Functions.Function1<EClass, Boolean>(){

            public Boolean apply(EClass it) {
                return qualifiedClsName.endsWith(EcoreExtensions.this.getUniqueId((ENamedElement)it));
            }
        };
        return (EClass)IterableExtensions.findFirst(this.getAllClasses(rootPkg), (Functions.Function1)_function_1);
    }

    public EClassifier findClassifier(Set<EPackage> pkgs, final String clsName) {
        Functions.Function1<EPackage, EClassifier> _function = new Functions.Function1<EPackage, EClassifier>(){

            public EClassifier apply(EPackage it) {
                return EcoreExtensions.this.findClassifier(it, clsName);
            }
        };
        return (EClassifier)IterableExtensions.head((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map(pkgs, (Functions.Function1)_function)));
    }

    public EClassifier findClassifier(EPackage pkg, final String clsName) {
        boolean _contains = clsName.contains(".");
        if (_contains) {
            return this.findQualifiedClassifier(pkg, clsName);
        }
        Functions.Function1<EClassifier, Boolean> _function = new Functions.Function1<EClassifier, Boolean>(){

            public Boolean apply(EClassifier it) {
                String _name = it.getName();
                return Objects.equal((Object)_name, (Object)clsName);
            }
        };
        return (EClassifier)IterableExtensions.findFirst((Iterable)pkg.getEClassifiers(), (Functions.Function1)_function);
    }

    public EClassifier findQualifiedClassifier(EPackage rootPkg, final String qualifiedClsName) {
        if (qualifiedClsName == null || !qualifiedClsName.contains(".")) {
            return null;
        }
        String rootName = rootPkg.getName();
        boolean _startsWith = qualifiedClsName.startsWith(String.valueOf(rootName) + ".");
        if (_startsWith) {
            Functions.Function1<EClassifier, Boolean> _function = new Functions.Function1<EClassifier, Boolean>(){

                public Boolean apply(EClassifier it) {
                    String _uniqueId = EcoreExtensions.this.getUniqueId((ENamedElement)it);
                    return Objects.equal((Object)_uniqueId, (Object)qualifiedClsName);
                }
            };
            return (EClassifier)IterableExtensions.findFirst(this.getAllClassifiers(rootPkg), (Functions.Function1)_function);
        }
        Functions.Function1<EClassifier, Boolean> _function_1 = new Functions.Function1<EClassifier, Boolean>(){

            public Boolean apply(EClassifier it) {
                return qualifiedClsName.endsWith(EcoreExtensions.this.getUniqueId((ENamedElement)it));
            }
        };
        return (EClassifier)IterableExtensions.findFirst(this.getAllClassifiers(rootPkg), (Functions.Function1)_function_1);
    }

    public List<EClassifier> getAllClassifiers(List<EPackage> pkgs) {
        Functions.Function1<EPackage, EList<EClassifier>> _function = new Functions.Function1<EPackage, EList<EClassifier>>(){

            public EList<EClassifier> apply(EPackage it) {
                return it.getEClassifiers();
            }
        };
        return IterableExtensions.toList((Iterable)Iterables.concat((Iterable)ListExtensions.map(pkgs, (Functions.Function1)_function)));
    }

    protected String _getUniqueId(Void it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("null");
        return _builder.toString();
    }

    protected String _getUniqueId(EPackage it) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        EPackage _eSuperPackage = it.getESuperPackage();
        boolean bl = _tripleNotEquals = _eSuperPackage != null;
        if (_tripleNotEquals) {
            String _uniqueId = this.getUniqueId((ENamedElement)it.getESuperPackage());
            _builder.append(_uniqueId);
            _builder.append(".");
        }
        String _name = it.getName();
        _builder.append(_name);
        return _builder.toString();
    }

    protected String _getUniqueId(EClassifier it) {
        StringConcatenation _builder = new StringConcatenation();
        String _uniqueId = this.getUniqueId((ENamedElement)it.getEPackage());
        _builder.append(_uniqueId);
        _builder.append(".");
        String _name = it.getName();
        _builder.append(_name);
        return _builder.toString();
    }

    protected String _getUniqueId(EOperation it) {
        StringConcatenation _builder = new StringConcatenation();
        String _uniqueId = this.getUniqueId((ENamedElement)it.getEContainingClass());
        _builder.append(_uniqueId);
        _builder.append(".");
        String _name = it.getName();
        _builder.append(_name);
        return _builder.toString();
    }

    protected String _getUniqueId(EStructuralFeature it) {
        StringConcatenation _builder = new StringConcatenation();
        String _uniqueId = this.getUniqueId((ENamedElement)it.getEContainingClass());
        _builder.append(_uniqueId);
        _builder.append(".");
        String _name = it.getName();
        _builder.append(_name);
        return _builder.toString();
    }

    public boolean isInstantiable(EClass cls) {
        return !cls.isAbstract() && !cls.isInterface() && this.isAbstractable(cls);
    }

    public boolean isAbstractable(EClass cls) {
        return !Objects.equal((Object)cls.getName(), (Object)"EObject") && cls.getInstanceClass() == null && cls.getInstanceTypeName() == null;
    }

    public boolean isAspectSpecific(EModelElement e) {
        Functions.Function1<EAnnotation, Boolean> _function = new Functions.Function1<EAnnotation, Boolean>(){

            public Boolean apply(EAnnotation it) {
                String _source = it.getSource();
                return Objects.equal((Object)_source, (Object)"aspect");
            }
        };
        return IterableExtensions.exists((Iterable)e.getEAnnotations(), (Functions.Function1)_function);
    }

    public void addAspectAnnotation(EModelElement e) {
        EList _eAnnotations = e.getEAnnotations();
        EAnnotation _createEAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
        Procedures.Procedure1<EAnnotation> _function = new Procedures.Procedure1<EAnnotation>(){

            public void apply(EAnnotation it) {
                it.setSource("aspect");
            }
        };
        EAnnotation _doubleArrow = (EAnnotation)ObjectExtensions.operator_doubleArrow((Object)_createEAnnotation, (Procedures.Procedure1)_function);
        _eAnnotations.add((Object)_doubleArrow);
    }

    public void addContainmentAnnotation(EModelElement e) {
        EList _eAnnotations = e.getEAnnotations();
        EAnnotation _createEAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
        Procedures.Procedure1<EAnnotation> _function = new Procedures.Procedure1<EAnnotation>(){

            public void apply(EAnnotation it) {
                it.setSource("containment");
            }
        };
        EAnnotation _doubleArrow = (EAnnotation)ObjectExtensions.operator_doubleArrow((Object)_createEAnnotation, (Procedures.Procedure1)_function);
        _eAnnotations.add((Object)_doubleArrow);
    }

    public void addOppositeAnnotation(EModelElement e, final String ref) {
        EList _eAnnotations = e.getEAnnotations();
        EAnnotation _createEAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
        Procedures.Procedure1<EAnnotation> _function = new Procedures.Procedure1<EAnnotation>(){

            public void apply(EAnnotation it) {
                it.setSource("opposite");
                it.getDetails().put((Object)"value", (Object)ref);
            }
        };
        EAnnotation _doubleArrow = (EAnnotation)ObjectExtensions.operator_doubleArrow((Object)_createEAnnotation, (Procedures.Procedure1)_function);
        _eAnnotations.add((Object)_doubleArrow);
    }

    public boolean hasContainmentAnnotation(EModelElement e) {
        Functions.Function1<EAnnotation, Boolean> _function = new Functions.Function1<EAnnotation, Boolean>(){

            public Boolean apply(EAnnotation it) {
                String _source = it.getSource();
                return Objects.equal((Object)_source, (Object)"containment");
            }
        };
        return IterableExtensions.exists((Iterable)e.getEAnnotations(), (Functions.Function1)_function);
    }

    public boolean hasSuppressedVisibility(ENamedElement f) {
        String _genmodelAnnotationValue = this.getGenmodelAnnotationValue((EModelElement)f, "suppressedVisibility");
        return Objects.equal((Object)_genmodelAnnotationValue, (Object)"true");
    }

    public boolean needsUnsetterInterface(EStructuralFeature f) {
        return f.isUnsettable() && !Objects.equal((Object)this.getGenmodelAnnotationValue((EModelElement)f, "suppressedUnsetVisibility"), (Object)"true");
    }

    public boolean needsUnsetterImplementation(EStructuralFeature f) {
        return f.isUnsettable();
    }

    public boolean needsUnsetterCheckerInterface(EStructuralFeature f) {
        return f.isUnsettable() && !Objects.equal((Object)this.getGenmodelAnnotationValue((EModelElement)f, "suppressedIsSetVisibility"), (Object)"true");
    }

    public boolean needsUnsetterCheckerImplementation(EStructuralFeature f) {
        return f.isUnsettable();
    }

    public String getGenmodelAnnotationValue(EModelElement e, final String key) {
        String _elvis = null;
        EAnnotation _eAnnotation = e.getEAnnotation("http://www.eclipse.org/emf/2002/GenModel");
        EMap _details = null;
        if (_eAnnotation != null) {
            _details = _eAnnotation.getDetails();
        }
        Map.Entry _findFirst = null;
        if (_details != null) {
            Functions.Function1<Map.Entry<String, String>, Boolean> _function = new Functions.Function1<Map.Entry<String, String>, Boolean>(){

                public Boolean apply(Map.Entry<String, String> d) {
                    String _key = d.getKey();
                    return Objects.equal((Object)_key, (Object)key);
                }
            };
            _findFirst = (Map.Entry)IterableExtensions.findFirst((Iterable)_details, (Functions.Function1)_function);
        }
        String _value = null;
        if (_findFirst != null) {
            _value = (String)_findFirst.getValue();
        }
        _elvis = _value != null ? _value : "";
        return _elvis;
    }

    public void generateCode(GenModel genModel) {
        genModel.reconcile();
        genModel.setCanGenerate(true);
        genModel.setValidateModel(true);
        Generator generator = GenModelUtil.createGenerator((GenModel)genModel);
        generator.generate((Object)genModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject", new Monitor(){

            public void beginTask(String name, int totalWork) {
            }

            public void clearBlocked() {
            }

            public void done() {
            }

            public void internalWorked(double work) {
            }

            public boolean isCanceled() {
                return false;
            }

            public void setBlocked(Diagnostic reason) {
            }

            public void setCanceled(boolean value) {
            }

            public void setTaskName(String name) {
            }

            public void subTask(String name) {
            }

            public void worked(int work) {
            }
        });
    }

    public EClass getOrCreateClass(EPackage aspPkg, final String fqn) {
        boolean _notEquals;
        boolean _equals;
        EClass find = this.getClass(aspPkg, fqn);
        if (find != null) {
            return find;
        }
        final String[] segments = fqn.split("\\.");
        int _length = segments.length;
        boolean bl = _equals = _length == 1;
        if (_equals) {
            EClass _createEClass = EcoreFactory.eINSTANCE.createEClass();
            Procedures.Procedure1<EClass> _function = new Procedures.Procedure1<EClass>(){

                public void apply(EClass cls) {
                    cls.setName(fqn);
                }
            };
            EClass newCls = (EClass)ObjectExtensions.operator_doubleArrow((Object)_createEClass, (Procedures.Procedure1)_function);
            this.addAspectAnnotation((EModelElement)newCls);
            EList _eClassifiers = aspPkg.getEClassifiers();
            _eClassifiers.add((Object)newCls);
            return newCls;
        }
        String _get = segments[0];
        String _name = aspPkg.getName();
        boolean bl2 = _notEquals = !Objects.equal((Object)_get, (Object)_name);
        if (_notEquals) {
            EClass _createEClass_1 = EcoreFactory.eINSTANCE.createEClass();
            Procedures.Procedure1<EClass> _function_1 = new Procedures.Procedure1<EClass>(){

                public void apply(EClass cls) {
                    cls.setName((String)IterableExtensions.last((Iterable)((Iterable)Conversions.doWrapArray((Object)segments))));
                }
            };
            EClass newCls_1 = (EClass)ObjectExtensions.operator_doubleArrow((Object)_createEClass_1, (Procedures.Procedure1)_function_1);
            this.addAspectAnnotation((EModelElement)newCls_1);
            EList _eClassifiers_1 = aspPkg.getEClassifiers();
            _eClassifiers_1.add((Object)newCls_1);
            return newCls_1;
        }
        EPackage last = aspPkg;
        int i = 1;
        while (i < ((List)Conversions.doWrapArray((Object)segments)).size() - 1) {
            final EPackage finalLast = last;
            final String segment = segments[i];
            EPackage _createEPackage = EcoreFactory.eINSTANCE.createEPackage();
            Procedures.Procedure1<EPackage> _function_2 = new Procedures.Procedure1<EPackage>(){

                public void apply(EPackage p) {
                    p.setName(segment);
                    String _nsPrefix = finalLast.getNsPrefix();
                    String _plus = String.valueOf(_nsPrefix) + ".";
                    String _plus_1 = String.valueOf(_plus) + segment;
                    p.setNsPrefix(_plus_1);
                    String _nsURI = finalLast.getNsURI();
                    String _plus_2 = String.valueOf(_nsURI) + ".";
                    String _plus_3 = String.valueOf(_plus_2) + segment;
                    p.setNsURI(_plus_3);
                }
            };
            EPackage newPack = (EPackage)ObjectExtensions.operator_doubleArrow((Object)_createEPackage, (Procedures.Procedure1)_function_2);
            EList _eSubpackages = last.getESubpackages();
            _eSubpackages.add((Object)newPack);
            last = newPack;
            ++i;
        }
        EClass _createEClass_2 = EcoreFactory.eINSTANCE.createEClass();
        Procedures.Procedure1<EClass> _function_2 = new Procedures.Procedure1<EClass>(){

            public void apply(EClass cls) {
                cls.setName((String)IterableExtensions.last((Iterable)((Iterable)Conversions.doWrapArray((Object)segments))));
            }
        };
        EClass newCls_2 = (EClass)ObjectExtensions.operator_doubleArrow((Object)_createEClass_2, (Procedures.Procedure1)_function_2);
        this.addAspectAnnotation((EModelElement)newCls_2);
        EList _eClassifiers_2 = last.getEClassifiers();
        _eClassifiers_2.add((Object)newCls_2);
        return newCls_2;
    }

    public EClassifier getOrCreateDataType(EPackage pkg, final String name, final String instanceTypeName) {
        List primitiveTypes = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"java.lang.Boolean", "java.lang.Byte", "java.lang.Double", "java.lang.Float", "java.lang.Integer", "java.lang.Long", "java.lang.Short"}));
        String _firstUpper = StringExtensions.toFirstUpper((String)name);
        String _plus = "E" + _firstUpper;
        String _xifexpression = null;
        boolean _contains = primitiveTypes.contains(instanceTypeName);
        _xifexpression = _contains ? "Object" : "";
        String ecoreDtName = String.valueOf(_plus) + _xifexpression;
        Functions.Function1<EDataType, Boolean> _function = new Functions.Function1<EDataType, Boolean>(){

            public Boolean apply(EDataType it) {
                return Objects.equal((Object)it.getName(), (Object)name) && Objects.equal((Object)it.getInstanceTypeName(), (Object)instanceTypeName);
            }
        };
        EDataType find = (EDataType)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)pkg.getEClassifiers(), EDataType.class), (Functions.Function1)_function);
        EClassifier findDt = this.findClassifier((EPackage)EcorePackage.eINSTANCE, ecoreDtName);
        if (find != null) {
            return find;
        }
        if (!Objects.equal((Object)name, (Object)"Object") && findDt != null) {
            return findDt;
        }
        EDataType _createEDataType = EcoreFactory.eINSTANCE.createEDataType();
        Procedures.Procedure1<EDataType> _function_1 = new Procedures.Procedure1<EDataType>(){

            public void apply(EDataType dt) {
                dt.setName(name);
                dt.setInstanceTypeName(instanceTypeName);
                EcoreExtensions.this.addAspectAnnotation((EModelElement)dt);
            }
        };
        EDataType newDt = (EDataType)ObjectExtensions.operator_doubleArrow((Object)_createEDataType, (Procedures.Procedure1)_function_1);
        EList _eClassifiers = pkg.getEClassifiers();
        _eClassifiers.add((Object)newDt);
        return newDt;
    }

    public EClassifier getOrCreateEnum(EPackage pkg, final String name, final Iterable<String> literals) {
        Functions.Function1<EEnum, Boolean> _function = new Functions.Function1<EEnum, Boolean>(){

            public Boolean apply(EEnum it) {
                String _name = it.getName();
                return Objects.equal((Object)_name, (Object)name);
            }
        };
        EEnum find = (EEnum)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)pkg.getEClassifiers(), EEnum.class), (Functions.Function1)_function);
        if (find != null) {
            return find;
        }
        EEnum _createEEnum = EcoreFactory.eINSTANCE.createEEnum();
        Procedures.Procedure1<EEnum> _function_1 = new Procedures.Procedure1<EEnum>(){

            public void apply(EEnum e) {
                e.setName(name);
                EList _eLiterals = e.getELiterals();
                Functions.Function1<String, EEnumLiteral> _function = new Functions.Function1<String, EEnumLiteral>(){

                    public EEnumLiteral apply(final String litValue) {
                        EEnumLiteral _createEEnumLiteral = EcoreFactory.eINSTANCE.createEEnumLiteral();
                        Procedures.Procedure1<EEnumLiteral> _function = new Procedures.Procedure1<EEnumLiteral>(){

                            public void apply(EEnumLiteral lit) {
                                lit.setName(litValue);
                            }
                        };
                        return (EEnumLiteral)ObjectExtensions.operator_doubleArrow((Object)_createEEnumLiteral, (Procedures.Procedure1)_function);
                    }
                };
                Iterable _map = IterableExtensions.map((Iterable)literals, (Functions.Function1)_function);
                Iterables.addAll((Collection)_eLiterals, (Iterable)_map);
                EcoreExtensions.this.addAspectAnnotation((EModelElement)e);
            }
        };
        EEnum newE = (EEnum)ObjectExtensions.operator_doubleArrow((Object)_createEEnum, (Procedures.Procedure1)_function_1);
        EList _eClassifiers = pkg.getEClassifiers();
        _eClassifiers.add((Object)newE);
        return newE;
    }

    public EPackage copy(EPackage pkg) {
        return this.copy(pkg, pkg.getName(), pkg.getName(), pkg.getNsURI());
    }

    public EPackage copy(EPackage pkg, String name) {
        String _lowerCase = name.toLowerCase();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("http://");
        String _lowerCase_1 = name.toLowerCase();
        _builder.append(_lowerCase_1);
        _builder.append("/");
        return this.copy(pkg, name, _lowerCase, _builder.toString());
    }

    public EPackage copy(EPackage pkg, final String pkgName, final String prefix, final String uri) {
        EPackage _createEPackage = EcoreFactory.eINSTANCE.createEPackage();
        Procedures.Procedure1<EPackage> _function = new Procedures.Procedure1<EPackage>(){

            public void apply(EPackage it) {
                it.setName(pkgName.toLowerCase());
                it.setNsPrefix(prefix);
                it.setNsURI(uri);
            }
        };
        EPackage newPkg = (EPackage)ObjectExtensions.operator_doubleArrow((Object)_createEPackage, (Procedures.Procedure1)_function);
        newPkg.getEClassifiers().addAll(EcoreUtil.copyAll((Collection)pkg.getEClassifiers()));
        return newPkg;
    }

    public EPackage createSubPackage(String pkgUri, final String pkgName) {
        EPackage _createEPackage = EcoreFactory.eINSTANCE.createEPackage();
        Procedures.Procedure1<EPackage> _function = new Procedures.Procedure1<EPackage>(){

            public void apply(EPackage it) {
                it.setName(pkgName.toLowerCase());
                it.setNsPrefix(pkgName.toLowerCase());
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("http://");
                String _lowerCase = pkgName.toLowerCase();
                _builder.append(_lowerCase);
                _builder.append("/");
                it.setNsURI(_builder.toString());
            }
        };
        final EPackage newPkg = (EPackage)ObjectExtensions.operator_doubleArrow((Object)_createEPackage, (Procedures.Procedure1)_function);
        EPackage pkg = this.modelUtils.loadPkg(pkgUri);
        Consumer<EClass> _function_1 = new Consumer<EClass>(){

            @Override
            public void accept(final EClass cls) {
                EList _eClassifiers = newPkg.getEClassifiers();
                EClass _createEClass = EcoreFactory.eINSTANCE.createEClass();
                Procedures.Procedure1<EClass> _function = new Procedures.Procedure1<EClass>(){

                    public void apply(EClass it) {
                        it.setAbstract(cls.isAbstract());
                        it.setInterface(cls.isInterface());
                        it.setName(cls.getName());
                        EList _eSuperTypes = it.getESuperTypes();
                        _eSuperTypes.add((Object)cls);
                    }
                };
                EClass _doubleArrow = (EClass)ObjectExtensions.operator_doubleArrow((Object)_createEClass, (Procedures.Procedure1)_function);
                _eClassifiers.add((Object)_doubleArrow);
            }
        };
        Iterables.filter((Iterable)pkg.getEClassifiers(), EClass.class).forEach(_function_1);
        return newPkg;
    }

    public List<EPackage> getReferencedPkgs(EPackage pkg) {
        ArrayList<EPackage> ret = new ArrayList<EPackage>();
        this.getReferencedPkgsRec(pkg, ret);
        return ret;
    }

    public void getReferencedPkgsRec(EPackage pkg, final List<EPackage> ret) {
        Functions.Function2<EObject, Collection<EStructuralFeature.Setting>, Boolean> _function = new Functions.Function2<EObject, Collection<EStructuralFeature.Setting>, Boolean>(){

            public Boolean apply(EObject o, Collection<EStructuralFeature.Setting> s) {
                return o instanceof EClass;
            }
        };
        BiConsumer<EObject, Collection<EStructuralFeature.Setting>> _function_1 = new BiConsumer<EObject, Collection<EStructuralFeature.Setting>>(){

            @Override
            public void accept(EObject cls, Collection<EStructuralFeature.Setting> s) {
                EObject container = cls;
                while (container != null && !(container instanceof EPackage)) {
                    container = container.eContainer();
                }
                final EPackage referenced = (EPackage)container;
                if (referenced != null && !IterableExtensions.exists((Iterable)ret, (Functions.Function1)new Functions.Function1<EPackage, Boolean>(){

                    public Boolean apply(EPackage it) {
                        String _nsURI = it.getNsURI();
                        String _nsURI_1 = referenced.getNsURI();
                        return Objects.equal((Object)_nsURI, (Object)_nsURI_1);
                    }
                }) && !EcoreExtensions.this.isEcore(referenced)) {
                    ret.add(referenced);
                    EcoreExtensions.this.getReferencedPkgsRec(referenced, ret);
                }
            }
        };
        MapExtensions.filter((Map)EcoreUtil.ExternalCrossReferencer.find((EObject)pkg), (Functions.Function2)_function).forEach(_function_1);
    }

    public List<EClass> getAllClasses(EPackage pkg) {
        ArrayList ret = CollectionLiterals.newArrayList((Object[])new EClass[0]);
        Iterables.addAll((Collection)ret, (Iterable)Iterables.filter((Iterable)pkg.getEClassifiers(), EClass.class));
        Functions.Function1<EPackage, EList<EClassifier>> _function = new Functions.Function1<EPackage, EList<EClassifier>>(){

            public EList<EClassifier> apply(EPackage it) {
                return it.getEClassifiers();
            }
        };
        Iterables.addAll((Collection)ret, (Iterable)Iterables.filter((Iterable)Iterables.concat((Iterable)ListExtensions.map(this.getAllSubPkgs(pkg), (Functions.Function1)_function)), EClass.class));
        return ret;
    }

    public List<EClassifier> getAllClassifiers(EPackage pkg) {
        ArrayList ret = CollectionLiterals.newArrayList((Object[])new EClassifier[0]);
        ret.addAll(pkg.getEClassifiers());
        Functions.Function1<EPackage, EList<EClassifier>> _function = new Functions.Function1<EPackage, EList<EClassifier>>(){

            public EList<EClassifier> apply(EPackage it) {
                return it.getEClassifiers();
            }
        };
        Iterables.addAll((Collection)ret, (Iterable)Iterables.concat((Iterable)ListExtensions.map(this.getAllSubPkgs(pkg), (Functions.Function1)_function)));
        return ret;
    }

    public List<EPackage> getAllSubPkgs(EPackage pkg) {
        ArrayList ret = CollectionLiterals.newArrayList((Object[])new EPackage[0]);
        this.getAllSubPkgsRec(pkg, ret);
        return ret;
    }

    public void getAllSubPkgsRec(EPackage pkg, final List<EPackage> ret) {
        Consumer<EPackage> _function = new Consumer<EPackage>(){

            @Override
            public void accept(EPackage p) {
                EcoreExtensions.this.getAllSubPkgsRec(p, ret);
                ret.add(p);
            }
        };
        pkg.getESubpackages().forEach((Consumer)_function);
    }

    public List<GenPackage> getAllGenPkgs(GenModel gm) {
        ArrayList ret = CollectionLiterals.newArrayList((Object[])new GenPackage[0]);
        this.getAllGenPkgsRec(gm, (List<GenPackage>)ret);
        return ret;
    }

    public void getAllGenPkgsRec(GenModel gm, final List<GenPackage> ret) {
        Functions.Function1<GenPackage, Boolean> _function = new Functions.Function1<GenPackage, Boolean>(){

            public Boolean apply(final GenPackage gp) {
                Functions.Function1<GenPackage, Boolean> _function = new Functions.Function1<GenPackage, Boolean>(){

                    public Boolean apply(GenPackage it) {
                        String _nsURI = it.getEcorePackage().getNsURI();
                        String _nsURI_1 = gp.getEcorePackage().getNsURI();
                        return Objects.equal((Object)_nsURI, (Object)_nsURI_1);
                    }
                };
                boolean _exists = IterableExtensions.exists((Iterable)ret, (Functions.Function1)_function);
                return !_exists;
            }
        };
        Consumer<GenPackage> _function_1 = new Consumer<GenPackage>(){

            @Override
            public void accept(GenPackage gp) {
                ret.add(gp);
                EcoreExtensions.this.getAllGenPkgsRec(gp, (List<GenPackage>)ret);
            }
        };
        IterableExtensions.filter((Iterable)gm.getGenPackages(), (Functions.Function1)_function).forEach(_function_1);
        Functions.Function1<GenPackage, Boolean> _function_2 = new Functions.Function1<GenPackage, Boolean>(){

            public Boolean apply(final GenPackage gp) {
                return gp != null && gp.getEcorePackage() != null && !IterableExtensions.exists((Iterable)ret, (Functions.Function1)new Functions.Function1<GenPackage, Boolean>(){

                    public Boolean apply(GenPackage it) {
                        String _nsURI = it.getEcorePackage().getNsURI();
                        String _nsURI_1 = gp.getEcorePackage().getNsURI();
                        return Objects.equal((Object)_nsURI, (Object)_nsURI_1);
                    }
                });
            }
        };
        Consumer<GenPackage> _function_3 = new Consumer<GenPackage>(){

            @Override
            public void accept(GenPackage gp) {
                ret.add(gp);
                EcoreExtensions.this.getAllGenPkgsRec(gp.getGenModel(), (List<GenPackage>)ret);
                EcoreExtensions.this.getAllGenPkgsRec(gp, (List<GenPackage>)ret);
            }
        };
        IterableExtensions.filter((Iterable)gm.getUsedGenPackages(), (Functions.Function1)_function_2).forEach(_function_3);
    }

    public void getAllGenPkgsRec(GenPackage gp, final List<GenPackage> ret) {
        Functions.Function1<GenPackage, Boolean> _function = new Functions.Function1<GenPackage, Boolean>(){

            public Boolean apply(final GenPackage gpp) {
                Functions.Function1<GenPackage, Boolean> _function = new Functions.Function1<GenPackage, Boolean>(){

                    public Boolean apply(GenPackage it) {
                        String _nsURI = it.getEcorePackage().getNsURI();
                        String _nsURI_1 = gpp.getEcorePackage().getNsURI();
                        return Objects.equal((Object)_nsURI, (Object)_nsURI_1);
                    }
                };
                boolean _exists = IterableExtensions.exists((Iterable)ret, (Functions.Function1)_function);
                return !_exists;
            }
        };
        Consumer<GenPackage> _function_1 = new Consumer<GenPackage>(){

            @Override
            public void accept(GenPackage gpp) {
                ret.add(gpp);
                EcoreExtensions.this.getAllGenPkgsRec(gpp, (List<GenPackage>)ret);
            }
        };
        IterableExtensions.filter((Iterable)gp.getSubGenPackages(), (Functions.Function1)_function).forEach(_function_1);
    }

    public boolean needsSetterInterface(EStructuralFeature attr) {
        return attr.isChangeable() && !attr.isMany();
    }

    public boolean needsSetterImplementation(EStructuralFeature attr) {
        return attr.isChangeable() && !attr.isMany();
    }

    public boolean isEMFMapDetails(EReference ref) {
        boolean _equals;
        boolean _and = false;
        String _name = null;
        if (ref != null) {
            _name = ref.getName();
        }
        if (!(_equals = Objects.equal((Object)_name, (Object)"details"))) {
            _and = false;
        } else {
            boolean _equals_1;
            EClass _eReferenceType = ref.getEReferenceType();
            String _name_1 = null;
            if (_eReferenceType != null) {
                _name_1 = _eReferenceType.getName();
            }
            _and = _equals_1 = Objects.equal((Object)_name_1, (Object)"EStringToStringMapEntry");
        }
        return _and;
    }

    public boolean isEcore(EPackage pkg) {
        String _nsURI = pkg.getNsURI();
        return Objects.equal((Object)_nsURI, (Object)"http://www.eclipse.org/emf/2002/Ecore");
    }

    public boolean isUml(EPackage pkg) {
        String _name = pkg.getName();
        return Objects.equal((Object)_name, (Object)"uml");
    }

    public void replaceLocalEObjectReferencesToEcoreEObjectReferences(EPackage pkg) {
        EClass eObject = this.findClass(pkg, "EObject");
        if (eObject != null) {
            Consumer<EStructuralFeature.Setting> _function = new Consumer<EStructuralFeature.Setting>(){

                @Override
                public void accept(EStructuralFeature.Setting setting) {
                    EObject ref = setting.getEObject();
                    if (ref instanceof EReference) {
                        EReference _copy = (EReference)EcoreUtil.copy((EObject)((EReference)ref));
                        Procedures.Procedure1<EReference> _function = new Procedures.Procedure1<EReference>(){

                            public void apply(EReference it) {
                                it.setEType((EClassifier)EcorePackage.Literals.EOBJECT);
                            }
                        };
                        EReference replacement = (EReference)ObjectExtensions.operator_doubleArrow((Object)_copy, (Procedures.Procedure1)_function);
                        EcoreUtil.replace((EObject)ref, (EObject)replacement);
                    }
                }
            };
            EcoreUtil.UsageCrossReferencer.find((EObject)eObject, (EObject)pkg).forEach(_function);
            EcoreUtil.delete((EObject)eObject);
        }
    }

    public void replaceDataTypeWithEClass(Set<EPackage> pkgs, final EDataType dt) {
        String dtName = this.getUniqueId((ENamedElement)dt);
        EClass find = this.findClass(pkgs, dtName);
        EClass _xifexpression = null;
        if (find != null) {
            _xifexpression = find;
        } else {
            EClass _xblockexpression = null;
            EClass _createEClass = EcoreFactory.eINSTANCE.createEClass();
            Procedures.Procedure1<EClass> _function = new Procedures.Procedure1<EClass>(){

                public void apply(EClass it) {
                    it.setName(dt.getName());
                }
            };
            EClass newCls = (EClass)ObjectExtensions.operator_doubleArrow((Object)_createEClass, (Procedures.Procedure1)_function);
            boolean _isAspectSpecific = this.isAspectSpecific((EModelElement)dt);
            if (_isAspectSpecific) {
                this.addAspectAnnotation((EModelElement)newCls);
            }
            _xifexpression = _xblockexpression = newCls;
        }
        final EClass replacement = _xifexpression;
        Consumer<EStructuralFeature.Setting> _function = new Consumer<EStructuralFeature.Setting>(){

            @Override
            public void accept(EStructuralFeature.Setting setting) {
                final EObject attr = setting.getEObject();
                if (attr instanceof EAttribute) {
                    boolean _hasContainmentAnnotation;
                    EReference _createEReference = EcoreFactory.eINSTANCE.createEReference();
                    Procedures.Procedure1<EReference> _function = new Procedures.Procedure1<EReference>(){

                        public void apply(EReference ref) {
                            ref.setName(((EAttribute)attr).getName());
                            ref.setLowerBound(((EAttribute)attr).getLowerBound());
                            ref.setUpperBound(((EAttribute)attr).getUpperBound());
                            ref.setEType((EClassifier)replacement);
                            ref.setUnique(((EAttribute)attr).isUnique());
                        }
                    };
                    EReference featureReplacement = (EReference)ObjectExtensions.operator_doubleArrow((Object)_createEReference, (Procedures.Procedure1)_function);
                    boolean _isAspectSpecific = EcoreExtensions.this.isAspectSpecific((EModelElement)attr);
                    if (_isAspectSpecific) {
                        EcoreExtensions.this.addAspectAnnotation((EModelElement)featureReplacement);
                    }
                    if (_hasContainmentAnnotation = EcoreExtensions.this.hasContainmentAnnotation((EModelElement)attr)) {
                        featureReplacement.setContainment(true);
                    }
                    EcoreUtil.replace((EObject)attr, (EObject)featureReplacement);
                } else if (attr instanceof EOperation) {
                    EOperation op = (EOperation)attr;
                    op.setEType((EClassifier)replacement);
                } else if (attr instanceof EParameter) {
                    EParameter param = (EParameter)attr;
                    param.setEType((EClassifier)replacement);
                }
            }
        };
        EcoreUtil.UsageCrossReferencer.find((EObject)dt, pkgs).forEach(_function);
        if (find != null) {
            EcoreUtil.delete((EObject)dt);
        } else {
            EcoreUtil.replace((EObject)dt, (EObject)replacement);
        }
    }

    public void initializeNsUriWith(EPackage syntax, String nsUriBase) {
        String _xifexpression = null;
        boolean _endsWith = nsUriBase.endsWith("/");
        _xifexpression = _endsWith ? nsUriBase : String.valueOf(nsUriBase) + "/";
        final String base = _xifexpression;
        String _replace = this.getUniqueId((ENamedElement)syntax).replace(".", "/");
        String _plus = String.valueOf(base) + _replace;
        String _plus_1 = String.valueOf(_plus) + "/";
        syntax.setNsURI(_plus_1);
        Consumer<EPackage> _function = new Consumer<EPackage>(){

            @Override
            public void accept(EPackage pkg) {
                String suffix = EcoreExtensions.this.getUniqueId((ENamedElement)pkg).replace(".", "/");
                pkg.setNsURI(String.valueOf(base) + suffix + "/");
            }
        };
        this.getAllSubPkgs(syntax).forEach(_function);
    }

    public String getUniqueId(ENamedElement it) {
        if (it instanceof EOperation) {
            return this._getUniqueId((EOperation)it);
        }
        if (it instanceof EStructuralFeature) {
            return this._getUniqueId((EStructuralFeature)it);
        }
        if (it instanceof EClassifier) {
            return this._getUniqueId((EClassifier)it);
        }
        if (it instanceof EPackage) {
            return this._getUniqueId((EPackage)it);
        }
        if (it == null) {
            return this._getUniqueId((Void)null);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }
}

