/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.diverse.k3.ui.builder;

import fr.inria.diverse.k3.ui.Activator;
import fr.inria.diverse.k3.ui.builder.AspectMappingPropertiesChecker;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gemoc.commons.eclipse.pde.manifest.ManifestChanger;
import org.eclipse.gemoc.commons.eclipse.pde.manifest.ManifestChangerExportPackage;
import org.eclipse.gemoc.commons.eclipse.pde.manifest.ManifestChangerPluginDependency;
import org.osgi.framework.BundleException;

public class K3Builder
extends IncrementalProjectBuilder {
    protected AspectMappingPropertiesChecker _aspectMappingPropertiesChecker;
    public static final String BUILDER_ID = "fr.inria.diverse.k3.ui.k3Builder";
    private static final String MARKER_TYPE = "fr.inria.diverse.k3.ui.k3Problem";

    protected void checkAspectJNature(IResource resource) throws CoreException {
        IProject project;
        if (resource instanceof IFile && resource.getName().endsWith(".aj") && !(project = resource.getProject()).hasNature("org.eclipse.ajdt.ui.ajnature")) {
            try {
                IProjectDescription desc = project.getDescription();
                String[] prevNatures = desc.getNatureIds();
                String[] newNatures = new String[prevNatures.length + 1];
                System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
                newNatures[prevNatures.length] = "org.eclipse.ajdt.ui.ajnature";
                desc.setNatureIds(newNatures);
                project.setDescription(desc, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                Activator.logErrorMessage(e.getMessage(), e);
            }
            try {
                if (project.hasNature("org.eclipse.pde.PluginNature")) {
                    IFile manifest = project.getFile("META-INF/MANIFEST.MF");
                    ManifestChanger changer = new ManifestChanger(manifest);
                    ManifestChangerPluginDependency updater = new ManifestChangerPluginDependency(changer);
                    updater.add("org.aspectj.runtime");
                    changer.commit();
                }
            }
            catch (BundleException e) {
                Activator.logErrorMessage(e.getMessage(), e);
            }
            catch (IOException e) {
                Activator.logErrorMessage(e.getMessage(), e);
            }
        }
    }

    public void addMarker(IFile file, String message, int lineNumber, int severity) {
        try {
            IMarker marker = file.createMarker(MARKER_TYPE);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", severity);
            if (lineNumber == -1) {
                lineNumber = 1;
            }
            marker.setAttribute("lineNumber", lineNumber);
        }
        catch (CoreException coreException) {}
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return null;
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        this.getProject().deleteMarkers(MARKER_TYPE, true, 2);
        IFile mappingPropertyFile = this.getProject().getFile("/META-INF/xtend-gen/" + this.getProject().getName() + ".k3_aspect_mapping.properties");
        if (mappingPropertyFile.exists()) {
            mappingPropertyFile.delete(true, monitor);
        }
    }

    public void deleteMarkers(IFile file) {
        try {
            file.deleteMarkers(MARKER_TYPE, false, 0);
        }
        catch (CoreException coreException) {}
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        try {
            this.getProject().accept((IResourceVisitor)new K3BuilderResourceVisitor());
        }
        catch (CoreException coreException) {}
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        delta.accept((IResourceDeltaVisitor)new K3BuilderDeltaVisitor());
    }

    class K3BuilderDeltaVisitor
    implements IResourceDeltaVisitor {
        K3BuilderDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            switch (delta.getKind()) {
                case 1: {
                    K3Builder.this.checkAspectJNature(resource);
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    IProject project;
                    if (K3Builder.this._aspectMappingPropertiesChecker == null) {
                        K3Builder.this._aspectMappingPropertiesChecker = new AspectMappingPropertiesChecker(K3Builder.this);
                    }
                    K3Builder.this._aspectMappingPropertiesChecker.checkK3AspectMappingPropertiesForGeneratedJava(resource);
                    if (!(resource instanceof IFile) || !resource.getName().endsWith(".xtend") || !(project = resource.getProject()).hasNature("org.eclipse.pde.PluginNature")) break;
                    IFolder root = project.getFolder("xtend-gen");
                    Set<String> packs = this.findPackage(root);
                    this.updateManifest(project, packs);
                }
            }
            return true;
        }

        private void updateManifest(IProject project, Set<String> packs) {
            IFile manifest = project.getFile("META-INF/MANIFEST.MF");
            ManifestChanger changer = new ManifestChanger(manifest);
            ManifestChangerExportPackage updater = new ManifestChangerExportPackage(changer);
            for (String pack : packs) {
                try {
                    updater.add(pack);
                    changer.commit();
                }
                catch (BundleException e) {
                    Activator.logErrorMessage(e.getMessage(), e);
                }
                catch (IOException e) {
                    Activator.logErrorMessage(e.getMessage(), e);
                }
                catch (CoreException e) {
                    Activator.logErrorMessage(e.getMessage(), e);
                }
            }
        }

        private Set<String> findPackage(IFolder root) {
            HashSet<String> res = new HashSet<String>();
            try {
                IResource[] iResourceArray = root.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource member = iResourceArray[n2];
                    if (member.getType() == 2) {
                        Set<String> subRes = this.findPackageRec(member, member.getName());
                        res.addAll(subRes);
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                Activator.logErrorMessage(e.getMessage(), e);
            }
            return res;
        }

        private Set<String> findPackageRec(IResource resource, String packageName) {
            HashSet<String> res = new HashSet<String>();
            if (resource.getType() == 2) {
                try {
                    IResource[] iResourceArray = ((IFolder)resource).members();
                    int n = iResourceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource member = iResourceArray[n2];
                        if (member.getType() == 2) {
                            Set<String> subRes = this.findPackageRec(member, String.valueOf(packageName) + "." + member.getName());
                            res.addAll(subRes);
                        } else if (member.getType() == 1 && member.getFileExtension().equals("java")) {
                            res.add(packageName);
                        }
                        ++n2;
                    }
                }
                catch (CoreException e) {
                    Activator.logErrorMessage(e.getMessage(), e);
                }
            }
            return res;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean hasAjFile(IResource resource) {
            if (resource.getType() != 2) return false;
            try {
                IResource[] iResourceArray = ((IFolder)resource).members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        return false;
                    }
                    IResource member = iResourceArray[n2];
                    if (member.getType() == 2 ? this.hasAjFile(member) : member.getType() == 1 && member.getFileExtension().equals("aj")) {
                        return true;
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                Activator.logErrorMessage(e.getMessage(), e);
            }
            return false;
        }
    }

    class K3BuilderResourceVisitor
    implements IResourceVisitor {
        K3BuilderResourceVisitor() {
        }

        public boolean visit(IResource resource) {
            if (K3Builder.this._aspectMappingPropertiesChecker == null) {
                K3Builder.this._aspectMappingPropertiesChecker = new AspectMappingPropertiesChecker(K3Builder.this);
            }
            K3Builder.this._aspectMappingPropertiesChecker.checkK3AspectMappingPropertiesForGeneratedJava(resource);
            try {
                K3Builder.this.checkAspectJNature(resource);
            }
            catch (CoreException e) {
                Activator.logErrorMessage(e.getMessage(), e);
            }
            return true;
        }
    }
}

