/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Set;
import org.eclipse.gemini.web.internal.template.ServiceCallback;
import org.eclipse.gemini.web.internal.template.ServiceTemplate;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

final class EventManager {
    private final ServiceTemplate<EventAdmin> template;

    public EventManager(BundleContext context) {
        this.template = this.isEventAdminAvailable() ? new ServiceTemplate<EventAdmin>(context, EventAdmin.class) : null;
    }

    public void start() {
        if (this.template != null) {
            this.template.start();
        }
    }

    public void stop() {
        if (this.template != null) {
            this.template.stop();
        }
    }

    public void sendDeploying(Bundle applicationBundle, Bundle extenderBundle, String contextPath) {
        this.sendEvent("org/osgi/service/web/DEPLOYING", applicationBundle, extenderBundle, contextPath, null, null, null);
    }

    public void sendDeployed(Bundle applicationBundle, Bundle extenderBundle, String contextPath) {
        this.sendEvent("org/osgi/service/web/DEPLOYED", applicationBundle, extenderBundle, contextPath, null, null, null);
    }

    public void sendUndeploying(Bundle applicationBundle, Bundle extenderBundle, String contextPath) {
        this.sendEvent("org/osgi/service/web/UNDEPLOYING", applicationBundle, extenderBundle, contextPath, null, null, null);
    }

    public void sendUndeployed(Bundle applicationBundle, Bundle extenderBundle, String contextPath) {
        this.sendEvent("org/osgi/service/web/UNDEPLOYED", applicationBundle, extenderBundle, contextPath, null, null, null);
    }

    public void sendFailed(Bundle applicationBundle, Bundle extenderBundle, String contextPath, Exception ex, String collidingWebContextPath, Set<Long> collisionBundles) {
        this.sendEvent("org/osgi/service/web/FAILED", applicationBundle, extenderBundle, contextPath, ex, collidingWebContextPath, collisionBundles);
    }

    private void sendEvent(final String eventName, final Bundle applicationBundle, final Bundle extenderBundle, final String contextPath, final Throwable ex, final String collidingWebContextPath, final Set<Long> collisionBundles) {
        if (this.template != null) {
            this.template.executeWithService(new ServiceCallback<EventAdmin, Void>(){

                @Override
                public Void doWithService(EventAdmin eventAdmin) {
                    Hashtable<String, Object> props = new Hashtable<String, Object>();
                    if (applicationBundle.getSymbolicName() != null) {
                        ((Dictionary)props).put("bundle.symbolicName", applicationBundle.getSymbolicName());
                    }
                    ((Dictionary)props).put("bundle.id", applicationBundle.getBundleId());
                    ((Dictionary)props).put("bundle", applicationBundle);
                    ((Dictionary)props).put("bundle.version", applicationBundle.getVersion());
                    ((Dictionary)props).put("timestamp", System.currentTimeMillis());
                    ((Dictionary)props).put("context.path", contextPath);
                    if (extenderBundle != null) {
                        ((Dictionary)props).put("extender.bundle", extenderBundle);
                        ((Dictionary)props).put("extender.bundle.id", extenderBundle.getBundleId());
                        if (extenderBundle.getSymbolicName() != null) {
                            ((Dictionary)props).put("extender.bundle.symbolicName", extenderBundle.getSymbolicName());
                        }
                        ((Dictionary)props).put("extender.bundle.version", extenderBundle.getVersion());
                    }
                    if (ex != null) {
                        ((Dictionary)props).put("exception", ex);
                    }
                    if (collidingWebContextPath != null) {
                        ((Dictionary)props).put("collision", collidingWebContextPath);
                        Collection immutableCollisionBundles = Collections.unmodifiableCollection(collisionBundles);
                        ((Dictionary)props).put("collision.bundles", immutableCollisionBundles);
                    }
                    eventAdmin.sendEvent(new Event(eventName, props));
                    return null;
                }
            });
        }
    }

    private boolean isEventAdminAvailable() {
        try {
            this.getClass().getClassLoader().loadClass(EventAdmin.class.getName());
            return true;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }
}

