/*
 * Decompiled with CFR 0.152.
 */
package model.account;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import model.account.Customer;
import model.account.Transaction;

@Entity
public class Account {
    @Id
    @GeneratedValue
    int id;
    double balance;
    @OneToOne(mappedBy="account")
    Customer customer;
    @OneToMany(mappedBy="account")
    @OrderBy(value="txTime")
    List<Transaction> txns;
    @Temporal(value=TemporalType.DATE)
    public Date dateCreated = new Date(System.currentTimeMillis());

    public Account() {
    }

    public Account(Customer customer) {
        this();
        this.balance = 0.0;
        this.customer = customer;
        customer.setAccount(this);
        this.txns = new ArrayList<Transaction>();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public double getBalance() {
        return this.balance;
    }

    public void setBalance(double balance) {
        this.balance = balance;
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    public List<Transaction> getTxns() {
        return this.txns;
    }

    public void setTxns(List<Transaction> txns) {
        this.txns = txns;
    }

    public String toString() {
        return "Account(" + this.id + ", " + (this.customer != null ? this.customer.getLastName() : "null") + ", Balance: $" + this.balance + ")";
    }
}

