/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2mcrl2;

import java.util.List;
import org.eclipse.escet.cif.cif2mcrl2.CifToMcrl2Transformer;
import org.eclipse.escet.cif.cif2mcrl2.GenerateMarkedActionOption;
import org.eclipse.escet.cif.cif2mcrl2.GenerateValueActionsOption;
import org.eclipse.escet.cif.io.CifReader;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.options.InputFileOption;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.options.OutputFileOption;
import org.eclipse.escet.common.app.framework.output.IOutputComponent;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Lists;

public class CifToMcrl2Application
extends Application<IOutputComponent> {
    public static void main(String[] args) {
        CifToMcrl2Application cmApp = new CifToMcrl2Application();
        cmApp.run(args, true);
    }

    public CifToMcrl2Application() {
    }

    public CifToMcrl2Application(AppStreams streams) {
        super(streams);
    }

    protected int runInternal() {
        CifReader cifReader = (CifReader)new CifReader().init();
        Specification spec = (Specification)cifReader.read();
        String absSpecPath = Paths.resolve((String)InputFileOption.getPath());
        if (this.isTerminationRequested()) {
            return 0;
        }
        String valueActionPatterns = GenerateValueActionsOption.getValue();
        boolean addMarkedAction = GenerateMarkedActionOption.isEnabled();
        CifToMcrl2Transformer transformer = new CifToMcrl2Transformer(() -> this.isTerminationRequested(), OutputProvider.getWarningOutputStream());
        CodeBox code = transformer.transform(spec, absSpecPath, valueActionPatterns, addMarkedAction);
        String outPath = OutputFileOption.getDerivedPath((String)".cif", (String)".mcrl2");
        String absOutPath = Paths.resolve((String)outPath);
        code.writeToFile(outPath, absOutPath);
        return 0;
    }

    public String getAppName() {
        return "CIF to mCRL2 transformer";
    }

    public String getAppDescription() {
        return "Convert CIF specification to mCRL2.";
    }

    protected OutputProvider<IOutputComponent> getProvider() {
        return new OutputProvider();
    }

    private OptionCategory getConvertOptionsCategory() {
        List subPages = Lists.list();
        List options = Lists.list();
        options.add(Options.getInstance(InputFileOption.class));
        options.add(Options.getInstance(GenerateValueActionsOption.class));
        options.add(Options.getInstance(GenerateMarkedActionOption.class));
        options.add(Options.getInstance(OutputFileOption.class));
        return new OptionCategory("CIF to mCRL2 options", "Options for converting a CIF specification to mCRL2.", subPages, options);
    }

    protected OptionCategory getAllOptions() {
        List subPages = Lists.list();
        subPages.add(CifToMcrl2Application.getGeneralOptionCategory());
        subPages.add(this.getConvertOptionsCategory());
        List options = Lists.list();
        String optDesc = "All options for the conversion from CIF to mCRL2.";
        return new OptionCategory("CIF to mCRL2 conversion options", optDesc, subPages, options);
    }
}

