/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.generators;

import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class DocumentingSupport {
    private DocumentingSupport() {
    }

    public static String getDescription(PositionObject posObj) {
        if (posObj instanceof ContVariable) {
            return "continuous variable \"" + CifTextUtils.getAbsName((PositionObject)posObj, (boolean)false) + "\"";
        }
        if (DocumentingSupport.isAutomatonLocation(posObj)) {
            Automaton aut = (Automaton)posObj.eContainer();
            return "current-location variable for automaton \"" + CifTextUtils.getAbsName((PositionObject)aut, (boolean)false) + "\"";
        }
        if (posObj instanceof DiscVariable) {
            return "discrete variable \"" + CifTextUtils.getAbsName((PositionObject)posObj, (boolean)false) + "\"";
        }
        if (posObj instanceof InputVariable) {
            return "input variable \"" + CifTextUtils.getAbsName((PositionObject)posObj, (boolean)false) + "\"";
        }
        if (posObj instanceof AlgVariable) {
            return "algebraic variable \"" + CifTextUtils.getAbsName((PositionObject)posObj, (boolean)false) + "\"";
        }
        if (posObj instanceof Event) {
            Event evt = (Event)posObj;
            Assert.notNull((Object)evt.getControllable());
            if (evt.getControllable().booleanValue()) {
                return "controllable event \"" + CifTextUtils.getAbsName((PositionObject)posObj, (boolean)false) + "\"";
            }
            return "uncontrollable event \"" + CifTextUtils.getAbsName((PositionObject)posObj, (boolean)false) + "\"";
        }
        if (posObj instanceof Automaton) {
            return "automaton \"" + CifTextUtils.getAbsName((PositionObject)posObj, (boolean)false) + "\"";
        }
        if (posObj instanceof Specification) {
            return "specification (top-level group)";
        }
        if (posObj instanceof Group) {
            return "group \"" + CifTextUtils.getAbsName((PositionObject)posObj, (boolean)false) + "\"";
        }
        throw new AssertionError((Object)("Unexpected position object \"" + String.valueOf(posObj) + "\" found."));
    }

    public static boolean isAutomatonLocation(PositionObject posObj) {
        DiscVariable dvar;
        return posObj instanceof DiscVariable && (dvar = (DiscVariable)posObj).getName().isEmpty();
    }
}

