/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.typecheck;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import org.eclipse.escet.chi.metamodel.chi.ChiFactory;
import org.eclipse.escet.chi.metamodel.chi.Declaration;
import org.eclipse.escet.chi.metamodel.chi.Specification;
import org.eclipse.escet.chi.typecheck.CheckSpecification;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.java.exceptions.InputOutputException;
import org.eclipse.escet.common.typechecker.EcoreTypeChecker;

public class ChiTypeChecker
extends EcoreTypeChecker<List<Declaration>, Specification> {
    private final String emfBaseName;

    public ChiTypeChecker() {
        this(null);
    }

    public ChiTypeChecker(String emfBaseName) {
        this.emfBaseName = emfBaseName;
    }

    public Specification transRoot(List<Declaration> decls) {
        Specification spec = ChiFactory.eINSTANCE.createSpecification();
        spec.getDeclarations().addAll(decls);
        spec = CheckSpecification.transSpecification(spec, this);
        return spec;
    }

    protected String getEcoreFileExtension() {
        return "chix";
    }

    protected OutputStream getXmlOutputStream() {
        if (this.emfBaseName == null) {
            return null;
        }
        Object path = this.emfBaseName + "." + this.getEcoreFileExtension();
        path = Paths.resolve((String)path);
        try {
            return new BufferedOutputStream(new FileOutputStream((String)path));
        }
        catch (FileNotFoundException e) {
            String msg = "Failed to write generated EMF model.";
            throw new InputOutputException(msg, (Throwable)e);
        }
    }
}

