/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkImage;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.XClientMessageEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ImageList;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TypedListener;

public class TrayItem
extends Item {
    Tray parent;
    ToolTip toolTip;
    String toolTipText;
    int imageHandle;
    int tooltipsHandle;
    ImageList imageList;

    public TrayItem(Tray parent, int style) {
        super(parent, style);
        this.parent = parent;
        this.createWidget(parent.getItemCount());
    }

    public void addMenuDetectListener(MenuDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(35, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createWidget(int index) {
        super.createWidget(index);
        this.parent.createItem(this, index);
    }

    void createHandle(int index) {
        this.state |= 8;
        if (OS.GTK_VERSION >= OS.VERSION(2, 10, 0)) {
            this.handle = OS.gtk_status_icon_new();
            if (this.handle == 0) {
                this.error(2);
            }
            this.imageHandle = OS.gtk_image_new();
            OS.gtk_status_icon_set_visible(this.handle, true);
        } else {
            this.handle = OS.gtk_plug_new(0);
            if (this.handle == 0) {
                this.error(2);
            }
            this.imageHandle = OS.gtk_image_new();
            if (this.imageHandle == 0) {
                this.error(2);
            }
            OS.gtk_container_add(this.handle, this.imageHandle);
            OS.gtk_widget_show(this.handle);
            OS.gtk_widget_show(this.imageHandle);
            int id = OS.gtk_plug_get_id(this.handle);
            int monitor = 0;
            int screen = OS.gdk_screen_get_default();
            if (screen != 0) {
                monitor = OS.gdk_screen_get_number(screen);
            }
            byte[] trayBuffer = Converter.wcsToMbcs(null, "_NET_SYSTEM_TRAY_S" + monitor, true);
            int trayAtom = OS.gdk_atom_intern(trayBuffer, true);
            int xTrayAtom = OS.gdk_x11_atom_to_xatom(trayAtom);
            int xDisplay = OS.GDK_DISPLAY();
            int trayWindow = OS.XGetSelectionOwner(xDisplay, xTrayAtom);
            byte[] messageBuffer = Converter.wcsToMbcs(null, "_NET_SYSTEM_TRAY_OPCODE", true);
            int messageAtom = OS.gdk_atom_intern(messageBuffer, true);
            int xMessageAtom = OS.gdk_x11_atom_to_xatom(messageAtom);
            XClientMessageEvent event = new XClientMessageEvent();
            event.type = 33;
            event.window = trayWindow;
            event.message_type = xMessageAtom;
            event.format = 32;
            event.data[0] = 0;
            event.data[1] = 0;
            event.data[2] = id;
            int clientEvent = OS.g_malloc(XClientMessageEvent.sizeof);
            OS.memmove(clientEvent, event, XClientMessageEvent.sizeof);
            OS.XSendEvent(xDisplay, trayWindow, false, 0, clientEvent);
            OS.g_free(clientEvent);
        }
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.imageHandle);
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Tray getParent() {
        this.checkWidget();
        return this.parent;
    }

    public ToolTip getToolTip() {
        this.checkWidget();
        return this.toolTip;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    int gtk_activate(int widget) {
        this.sendSelectionEvent(13);
        int nextEvent = OS.gdk_event_peek();
        if (nextEvent != 0) {
            int nextEventType = OS.GDK_EVENT_TYPE(nextEvent);
            int currEvent = OS.gtk_get_current_event();
            int currEventType = 0;
            if (currEvent != 0) {
                currEventType = OS.GDK_EVENT_TYPE(currEvent);
                OS.gdk_event_free(currEvent);
            }
            OS.gdk_event_free(nextEvent);
            if (currEventType == 4 && nextEventType == 5) {
                this.sendSelectionEvent(14);
            }
        }
        return 0;
    }

    int gtk_button_press_event(int widget, int eventPtr) {
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove(gdkEvent, eventPtr, GdkEventButton.sizeof);
        if (gdkEvent.type == 6) {
            return 0;
        }
        if (gdkEvent.button == 3 && gdkEvent.type == 4) {
            this.sendEvent(35);
            return 0;
        }
        if (gdkEvent.type == 5) {
            this.sendSelectionEvent(14);
        } else {
            this.sendSelectionEvent(13);
        }
        return 0;
    }

    int gtk_size_allocate(int widget, int allocation) {
        if (this.image != null && this.image.mask != 0 && OS.gdk_drawable_get_depth(this.image.mask) == 1) {
            int xoffset = (int)Math.floor((double)OS.GTK_WIDGET_X(widget) + (double)(OS.GTK_WIDGET_WIDTH(widget) - OS.GTK_WIDGET_REQUISITION_WIDTH(widget)) * 0.5 + 0.5);
            int yoffset = (int)Math.floor((double)OS.GTK_WIDGET_Y(widget) + (double)(OS.GTK_WIDGET_HEIGHT(widget) - OS.GTK_WIDGET_REQUISITION_HEIGHT(widget)) * 0.5 + 0.5);
            Rectangle b = this.image.getBounds();
            int gdkImagePtr = OS.gdk_drawable_get_image(this.image.mask, 0, 0, b.width, b.height);
            if (gdkImagePtr == 0) {
                SWT.error(2);
            }
            GdkImage gdkImage = new GdkImage();
            OS.memmove(gdkImage, gdkImagePtr);
            byte[] maskData = new byte[gdkImage.bpl * gdkImage.height];
            OS.memmove(maskData, gdkImage.mem, maskData.length);
            OS.g_object_unref(gdkImagePtr);
            Region region = new Region(this.display);
            int y = 0;
            while (y < b.height) {
                int x = 0;
                while (x < b.width) {
                    int index = y * gdkImage.bpl + (x >> 3);
                    int theByte = maskData[index] & 0xFF;
                    int mask = 1 << (x & 7);
                    if ((theByte & mask) != 0) {
                        region.add(xoffset + x, yoffset + y, 1, 1);
                    }
                    ++x;
                }
                ++y;
            }
            OS.gtk_widget_realize(this.handle);
            int window = OS.GTK_WIDGET_WINDOW(this.handle);
            OS.gdk_window_shape_combine_region(window, region.handle, 0, 0);
            region.dispose();
        }
        return 0;
    }

    int gtk_status_icon_popup_menu(int widget, int button, int activate_time) {
        Display display = this.display;
        display.currentTrayItem = this;
        this.sendEvent(35);
        if (!this.isDisposed()) {
            display.runPopups();
        }
        display.currentTrayItem = null;
        return 0;
    }

    void hookEvents() {
        if (OS.GTK_VERSION >= OS.VERSION(2, 10, 0)) {
            OS.g_signal_connect_closure(this.handle, OS.activate, this.display.closures[1], false);
            OS.g_signal_connect_closure(this.handle, OS.popup_menu, this.display.closures[63], false);
        } else {
            int eventMask = 256;
            OS.gtk_widget_add_events(this.handle, eventMask);
            OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[2], 0, this.display.closures[2], false);
            OS.g_signal_connect_closure_by_id(this.imageHandle, this.display.signalIds[47], 0, this.display.closures[47], false);
        }
    }

    public boolean getVisible() {
        this.checkWidget();
        if (OS.GTK_VERSION >= OS.VERSION(2, 10, 0)) {
            return OS.gtk_status_icon_get_visible(this.handle);
        }
        return OS.GTK_WIDGET_VISIBLE(this.handle);
    }

    void register() {
        super.register();
        this.display.addWidget(this.imageHandle, this);
    }

    void releaseHandle() {
        if (this.handle != 0) {
            if (OS.GTK_VERSION >= OS.VERSION(2, 10, 0)) {
                OS.g_object_unref(this.handle);
            } else {
                OS.gtk_widget_destroy(this.handle);
            }
        }
        this.imageHandle = 0;
        this.handle = 0;
        super.releaseHandle();
        this.parent = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.tooltipsHandle != 0) {
            OS.g_object_unref(this.tooltipsHandle);
        }
        this.tooltipsHandle = 0;
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
        this.toolTipText = null;
    }

    public void removeMenuDetectListener(MenuDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(35, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.image = image;
        if (image != null) {
            int imageIndex;
            if (this.imageList == null) {
                this.imageList = new ImageList();
            }
            if ((imageIndex = this.imageList.indexOf(image)) == -1) {
                imageIndex = this.imageList.add(image);
            } else {
                this.imageList.put(imageIndex, image);
            }
            int pixbuf = this.imageList.getPixbuf(imageIndex);
            if (OS.GTK_VERSION >= OS.VERSION(2, 10, 0)) {
                OS.gtk_status_icon_set_from_pixbuf(this.handle, pixbuf);
                OS.gtk_status_icon_set_visible(this.handle, true);
            } else {
                Rectangle rect = image.getBounds();
                OS.gtk_widget_set_size_request(this.handle, rect.width, rect.height);
                OS.gtk_image_set_from_pixbuf(this.imageHandle, pixbuf);
                OS.gtk_widget_show(this.imageHandle);
            }
        } else {
            OS.gtk_widget_set_size_request(this.handle, 1, 1);
            if (OS.GTK_VERSION >= OS.VERSION(2, 10, 0)) {
                OS.gtk_status_icon_set_from_pixbuf(this.handle, 0);
                OS.gtk_status_icon_set_visible(this.handle, false);
            } else {
                OS.gtk_image_set_from_pixbuf(this.imageHandle, 0);
                OS.gtk_widget_hide(this.imageHandle);
            }
        }
    }

    public void setToolTip(ToolTip toolTip) {
        this.checkWidget();
        ToolTip oldTip = this.toolTip;
        ToolTip newTip = toolTip;
        if (oldTip != null) {
            oldTip.item = null;
        }
        this.toolTip = newTip;
        if (newTip != null) {
            newTip.item = this;
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        byte[] buffer = null;
        if (string != null && string.length() > 0) {
            buffer = Converter.wcsToMbcs(null, string, true);
        }
        if (this.tooltipsHandle == 0) {
            this.tooltipsHandle = OS.gtk_tooltips_new();
            if (this.tooltipsHandle == 0) {
                this.error(2);
            }
            OS.g_object_ref(this.tooltipsHandle);
            OS.gtk_object_sink(this.tooltipsHandle);
        }
        if (OS.GTK_VERSION >= OS.VERSION(2, 10, 0)) {
            OS.gtk_status_icon_set_tooltip(this.handle, buffer);
        } else {
            OS.gtk_tooltips_set_tip(this.tooltipsHandle, this.handle, buffer, null);
        }
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if (OS.GTK_VERSION >= OS.VERSION(2, 10, 0) ? OS.gtk_status_icon_get_visible(this.handle) == visible : OS.GTK_WIDGET_VISIBLE(this.handle) == visible) {
            return;
        }
        if (visible) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
            if (OS.GTK_VERSION >= OS.VERSION(2, 10, 0)) {
                OS.gtk_status_icon_set_visible(this.handle, visible);
            } else {
                OS.gtk_widget_show(this.handle);
            }
        } else {
            if (OS.GTK_VERSION >= OS.VERSION(2, 10, 0)) {
                OS.gtk_status_icon_set_visible(this.handle, visible);
            } else {
                OS.gtk_widget_hide(this.handle);
            }
            this.sendEvent(23);
        }
    }
}

