/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.real;

import net.sourceforge.plantuml.real.PositiveForce;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.real.RealMoveable;

class RealMiddle2
extends RealMoveable {
    private final RealMoveable p1;
    private final RealMoveable p2;

    RealMiddle2(RealMoveable p1, RealMoveable p2) {
        super(p1.getLine(), "middle");
        assert (p1.getLine() == p2.getLine());
        this.p1 = p1;
        this.p2 = p2;
    }

    @Override
    double getCurrentValueInternal() {
        return (this.p1.getCurrentValue() + this.p2.getCurrentValue()) / 2.0;
    }

    @Override
    public Real addAtLeast(double delta) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void ensureBiggerThan(Real other) {
        this.getLine().addForce(new PositiveForce(other, this, 0.0));
    }

    @Override
    void move(double delta) {
        this.p1.move(delta / 2.0);
        this.p2.move(delta / 2.0);
    }
}

