/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.test.workspace;

import com.google.common.base.Optional;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.client.ESUsersession;
import org.eclipse.emf.emfstore.client.test.common.cases.ESTestWithLoggedInUser;
import org.eclipse.emf.emfstore.client.test.common.dsl.Add;
import org.eclipse.emf.emfstore.client.test.common.dsl.Create;
import org.eclipse.emf.emfstore.client.test.common.util.ProjectUtil;
import org.eclipse.emf.emfstore.client.util.ESVoidCallable;
import org.eclipse.emf.emfstore.client.util.RunESCommand;
import org.eclipse.emf.emfstore.common.model.ESModelElementId;
import org.eclipse.emf.emfstore.internal.client.model.Configuration;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESLocalProjectImpl;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.emf.emfstore.test.model.TestElement;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class WorkspaceTest
extends ESTestWithLoggedInUser {
    private Optional<Integer> changePackageFragmentSize;

    @BeforeClass
    public static void beforeClass() {
        WorkspaceTest.startEMFStore();
    }

    @AfterClass
    public static void afterClass() {
        WorkspaceTest.stopEMFStore();
    }

    @Before
    public void before() {
        this.changePackageFragmentSize = Configuration.getClientBehavior().getChangePackageFragmentSize();
        super.before();
    }

    @After
    public void after() {
        super.after();
        Configuration.getClientBehavior().setChangePackageFragmentSize(this.changePackageFragmentSize);
    }

    @Test
    public void restartServerAndUpdateOutdatedClient() throws ESException {
        Configuration.getClientBehavior().setChangePackageFragmentSize(Optional.of((Object)1));
        final TestElement testElement = Create.testElement((String)"foo");
        Add.toProject((ESLocalProject)this.getLocalProject(), (EObject)testElement);
        ESModelElementId testElementId = (ESModelElementId)this.getLocalProject().getModelElementId((EObject)testElement);
        ProjectUtil.share((ESUsersession)this.getUsersession(), (ESLocalProject)this.getLocalProject());
        ESLocalProject clonedProject = this.getLocalProject().getRemoteProject().checkout("clonedProject", (IProgressMonitor)new NullProgressMonitor());
        RunESCommand.run((Callable)new ESVoidCallable(){

            public void run() {
                testElement.setName("bar");
                testElement.getContainedElements().add((Object)Create.testElement());
                testElement.getContainedElements().add((Object)Create.testElement());
                testElement.getContainedElements().add((Object)Create.testElement());
            }
        });
        this.getLocalProject().commit((IProgressMonitor)new NullProgressMonitor());
        WorkspaceTest.restartEMFStore();
        clonedProject.update((IProgressMonitor)new NullProgressMonitor());
        TestElement copiedTestElement = (TestElement)clonedProject.getModelElement((Object)testElementId);
        MatcherAssert.assertThat((Object)copiedTestElement.getName(), (Matcher)IsEqual.equalTo((Object)"bar"));
    }

    @Test
    public void restartClientAndCheckBaseVersion() throws ESException {
        final TestElement testElement = Create.testElement((String)"foo");
        Add.toProject((ESLocalProject)this.getLocalProject(), (EObject)testElement);
        ProjectUtil.share((ESUsersession)this.getUsersession(), (ESLocalProject)this.getLocalProject());
        ESLocalProject clonedProject = this.getLocalProject().getRemoteProject().checkout("clonedProject", (IProgressMonitor)new NullProgressMonitor());
        RunESCommand.run((Callable)new ESVoidCallable(){

            public void run() {
                testElement.setName("bar");
            }
        });
        this.getLocalProject().commit((IProgressMonitor)new NullProgressMonitor());
        clonedProject.update((IProgressMonitor)new NullProgressMonitor());
        ProjectSpace cloned = (ProjectSpace)((ESLocalProjectImpl)ESLocalProjectImpl.class.cast(clonedProject)).toInternalAPI();
        URI uri = cloned.eResource().getURI();
        URI normalizedUri = cloned.getResourceSet().getURIConverter().normalize(uri);
        ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
        Resource resource = resourceSetImpl.getResource(normalizedUri, true);
        ProjectSpace loadedProjectSpace = (ProjectSpace)resource.getContents().get(0);
        MatcherAssert.assertThat((Object)loadedProjectSpace.getBaseVersion().getIdentifier(), (Matcher)IsEqual.equalTo((Object)1));
    }
}

