/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.connection.xmlrpc;

import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPoint;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPointException;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.Messages;
import org.eclipse.emf.emfstore.internal.server.ServerConfiguration;
import org.eclipse.emf.emfstore.internal.server.connection.xmlrpc.XmlRpcBuiltinWebServer;
import org.eclipse.emf.emfstore.server.ESXmlRpcWebServerProvider;

public final class XmlRpcWebserverManager {
    private static final String WEBSERVER_PROVIDER_KEY = "org.eclipse.emf.emfstore.server.webServerProvider";
    public static ESXmlRpcWebServerProvider webServerProvider = null;

    public static ESXmlRpcWebServerProvider getInstance() {
        ESXmlRpcWebServerProvider provider = XmlRpcWebserverManager.getWebServerProvider();
        return provider;
    }

    private XmlRpcWebserverManager() {
    }

    public static synchronized ESXmlRpcWebServerProvider getWebServerProvider() {
        if (webServerProvider == null) {
            int port = 8080;
            try {
                port = Integer.valueOf(ServerConfiguration.getProperties().getProperty("emfstore.connection.xmlrpc.port"));
            }
            catch (NumberFormatException numberFormatException) {
                port = Integer.valueOf("8080");
            }
            try {
                IExtensionRegistry reg = Platform.getExtensionRegistry();
                reg.getConfigurationElementsFor(WEBSERVER_PROVIDER_KEY);
                webServerProvider = new ESExtensionPoint(WEBSERVER_PROVIDER_KEY, true).size() > 0 ? (ESXmlRpcWebServerProvider)new ESExtensionPoint(WEBSERVER_PROVIDER_KEY, true).getClass("providerClass", ESXmlRpcWebServerProvider.class) : new XmlRpcBuiltinWebServer();
            }
            catch (ESExtensionPointException e) {
                String message = Messages.ServerConfiguration_No_WebServer_Provider;
                ModelUtil.logException((String)message, (Throwable)e);
                return null;
            }
            webServerProvider.setPort(port);
            ModelUtil.logInfo((String)("Using WebServerProvider " + webServerProvider.getClass() + " at port " + webServerProvider.getPort()));
        }
        return webServerProvider;
    }
}

