/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.bowling.impl;

import java.util.Map;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.emfstore.bowling.Area;
import org.eclipse.emf.emfstore.bowling.BowlingFactory;
import org.eclipse.emf.emfstore.bowling.BowlingPackage;
import org.eclipse.emf.emfstore.bowling.Fan;
import org.eclipse.emf.emfstore.bowling.Game;
import org.eclipse.emf.emfstore.bowling.Gender;
import org.eclipse.emf.emfstore.bowling.League;
import org.eclipse.emf.emfstore.bowling.Matchup;
import org.eclipse.emf.emfstore.bowling.Merchandise;
import org.eclipse.emf.emfstore.bowling.Player;
import org.eclipse.emf.emfstore.bowling.Referee;
import org.eclipse.emf.emfstore.bowling.Tournament;
import org.eclipse.emf.emfstore.bowling.TournamentType;
import org.eclipse.emf.emfstore.bowling.impl.AreaImpl;
import org.eclipse.emf.emfstore.bowling.impl.FanImpl;
import org.eclipse.emf.emfstore.bowling.impl.GameImpl;
import org.eclipse.emf.emfstore.bowling.impl.LeagueImpl;
import org.eclipse.emf.emfstore.bowling.impl.MatchupImpl;
import org.eclipse.emf.emfstore.bowling.impl.MerchandiseImpl;
import org.eclipse.emf.emfstore.bowling.impl.PlayerImpl;
import org.eclipse.emf.emfstore.bowling.impl.PlayerToPointsMapImpl;
import org.eclipse.emf.emfstore.bowling.impl.RefereeImpl;
import org.eclipse.emf.emfstore.bowling.impl.RefereeToGamesMapImpl;
import org.eclipse.emf.emfstore.bowling.impl.TournamentImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BowlingFactoryImpl
extends EFactoryImpl
implements BowlingFactory {
    public static BowlingFactory init() {
        try {
            BowlingFactory theBowlingFactory = (BowlingFactory)EPackage.Registry.INSTANCE.getEFactory("http://org/eclipse/example/bowling");
            if (theBowlingFactory != null) {
                return theBowlingFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new BowlingFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createPlayer();
            }
            case 1: {
                return this.createLeague();
            }
            case 2: {
                return this.createTournament();
            }
            case 3: {
                return this.createMatchup();
            }
            case 4: {
                return this.createGame();
            }
            case 5: {
                return (EObject)this.createPlayerToPointsMap();
            }
            case 6: {
                return this.createReferee();
            }
            case 7: {
                return (EObject)this.createRefereeToGamesMap();
            }
            case 8: {
                return this.createArea();
            }
            case 9: {
                return this.createFan();
            }
            case 10: {
                return this.createMerchandise();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 11: {
                return this.createTournamentTypeFromString(eDataType, initialValue);
            }
            case 12: {
                return this.createGenderFromString(eDataType, initialValue);
            }
            case 13: {
                return this.createXMLDateFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 11: {
                return this.convertTournamentTypeToString(eDataType, instanceValue);
            }
            case 12: {
                return this.convertGenderToString(eDataType, instanceValue);
            }
            case 13: {
                return this.convertXMLDateToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public Player createPlayer() {
        PlayerImpl player = new PlayerImpl();
        return player;
    }

    @Override
    public League createLeague() {
        LeagueImpl league = new LeagueImpl();
        return league;
    }

    @Override
    public Tournament createTournament() {
        TournamentImpl tournament = new TournamentImpl();
        return tournament;
    }

    @Override
    public Matchup createMatchup() {
        MatchupImpl matchup = new MatchupImpl();
        return matchup;
    }

    @Override
    public Game createGame() {
        GameImpl game = new GameImpl();
        return game;
    }

    public Map.Entry<Player, Integer> createPlayerToPointsMap() {
        PlayerToPointsMapImpl playerToPointsMap = new PlayerToPointsMapImpl();
        return playerToPointsMap;
    }

    @Override
    public Referee createReferee() {
        RefereeImpl referee = new RefereeImpl();
        return referee;
    }

    public Map.Entry<Referee, Game> createRefereeToGamesMap() {
        RefereeToGamesMapImpl refereeToGamesMap = new RefereeToGamesMapImpl();
        return refereeToGamesMap;
    }

    @Override
    public Area createArea() {
        AreaImpl area = new AreaImpl();
        return area;
    }

    @Override
    public Fan createFan() {
        FanImpl fan = new FanImpl();
        return fan;
    }

    @Override
    public Merchandise createMerchandise() {
        MerchandiseImpl merchandise = new MerchandiseImpl();
        return merchandise;
    }

    public TournamentType createTournamentTypeFromString(EDataType eDataType, String initialValue) {
        TournamentType result = TournamentType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertTournamentTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public Gender createGenderFromString(EDataType eDataType, String initialValue) {
        Gender result = Gender.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertGenderToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public XMLGregorianCalendar createXMLDateFromString(EDataType eDataType, String initialValue) {
        return (XMLGregorianCalendar)XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.DATE, initialValue);
    }

    public String convertXMLDateToString(EDataType eDataType, Object instanceValue) {
        return XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.DATE, instanceValue);
    }

    @Override
    public BowlingPackage getBowlingPackage() {
        return (BowlingPackage)this.getEPackage();
    }

    @Deprecated
    public static BowlingPackage getPackage() {
        return BowlingPackage.eINSTANCE;
    }
}

