/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.core.liqp;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.embedcdt.core.liqp.ProtectionSettings;
import org.eclipse.embedcdt.core.liqp.RenderSettings;
import org.eclipse.embedcdt.core.liqp.parser.Flavor;

public class TemplateContext {
    protected TemplateContext parent;
    public final ProtectionSettings protectionSettings;
    public final RenderSettings renderSettings;
    public final Flavor flavor;
    private Map<String, Object> variables;

    public TemplateContext() {
        this(new ProtectionSettings.Builder().build(), new RenderSettings.Builder().build(), Flavor.LIQUID, new LinkedHashMap<String, Object>());
    }

    public TemplateContext(ProtectionSettings protectionSettings, RenderSettings renderSettings, Flavor flavor, Map<String, Object> variables) {
        this.parent = null;
        this.protectionSettings = protectionSettings;
        this.renderSettings = renderSettings;
        this.flavor = flavor;
        this.variables = variables;
    }

    public TemplateContext(TemplateContext parent) {
        this.parent = parent;
        this.protectionSettings = parent.protectionSettings;
        this.renderSettings = parent.renderSettings;
        this.flavor = parent.flavor;
        this.variables = new LinkedHashMap<String, Object>();
    }

    public void incrementIterations() {
        this.protectionSettings.incrementIterations();
    }

    public boolean containsKey(String key) {
        if (this.variables.containsKey(key)) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.containsKey(key);
        }
        return false;
    }

    public Object get(String key) {
        Object value = this.variables.get(key);
        if (value != null) {
            return value;
        }
        if (this.parent != null) {
            return this.parent.get(key);
        }
        return null;
    }

    public Object put(String key, Object value) {
        return this.put(key, value, false);
    }

    public Object put(String key, Object value, boolean putInRootContext) {
        if (!putInRootContext || this.parent == null) {
            return this.variables.put(key, value);
        }
        return this.parent.put(key, value, putInRootContext);
    }

    public Object remove(String key) {
        if (this.variables.containsKey(key)) {
            return this.variables.remove(key);
        }
        if (this.parent != null) {
            return this.parent.remove(key);
        }
        return null;
    }

    public Map<String, Object> getVariables() {
        return new LinkedHashMap<String, Object>(this.variables);
    }
}

