/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.libavoid.server;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.elk.alg.libavoid.LibavoidPlugin;
import org.eclipse.elk.alg.libavoid.server.LibavoidServerException;
import org.osgi.framework.Bundle;

public class LibavoidServer {
    private String executable;
    private Process process;
    private Watchdog watchdog;
    private InputStream libavoidStream;
    private File tempFile;
    private int processTimeout = 10000;
    public static final String EXECUTABLE_PATH_LINUX64 = "/libavoid-server/libavoid-server-linux";
    public static final String EXECUTABLE_PATH_WIN64 = "/libavoid-server/libavoid-server-win.exe";
    public static final String EXECUTABLE_PATH_OSX64 = "/libavoid-server/libavoid-server-macos";
    public static final int BUFFER_SIZE = 512;
    private static final int MAX_ERROR_OUTPUT = 512;
    private static final int PROC_ERROR_TIME = 500;
    public static final int PROCESS_DEF_TIMEOUT = 10000;
    private Object nextJob = new Object();

    private static OS detectOS() {
        String os = System.getProperty("os.name").toLowerCase();
        String arch = System.getProperty("os.arch").toLowerCase();
        if (os.contains("linux")) {
            if (arch.contains("64")) {
                return OS.LINUX64;
            }
            if (arch.contains("86")) {
                return OS.LINUX32;
            }
        } else if (os.contains("win")) {
            if (arch.contains("64")) {
                return OS.WIN64;
            }
            if (arch.contains("86")) {
                return OS.WIN32;
            }
        } else if (os.contains("mac")) {
            if (arch.contains("64")) {
                return OS.OSX64;
            }
            if (arch.contains("86")) {
                return OS.OSX32;
            }
        } else if (os.contains("solaris")) {
            return OS.SOLARIS;
        }
        return OS.UNKNOWN;
    }

    LibavoidServer() {
    }

    private File resolveExecutable() throws IOException {
        String path = null;
        OS os = LibavoidServer.detectOS();
        switch (os) {
            case LINUX64: {
                path = EXECUTABLE_PATH_LINUX64;
                break;
            }
            case WIN64: {
                path = EXECUTABLE_PATH_WIN64;
                break;
            }
            case OSX64: {
                path = EXECUTABLE_PATH_OSX64;
                break;
            }
            default: {
                throw new LibavoidServerException("Unsupported operating system.");
            }
        }
        URL url = null;
        if (LibavoidPlugin.getDefault() != null) {
            Bundle bundle = LibavoidPlugin.getDefault().getBundle();
            url = FileLocator.find((Bundle)bundle, (IPath)new Path(path), null);
        }
        if (url == null) {
            url = this.getClass().getResource(path);
        }
        if (url == null) {
            throw new LibavoidServerException("Libavoid binary could not be located.");
        }
        File execFile = new File(FileLocator.resolve((URL)url).getFile());
        if (!execFile.exists()) {
            int count;
            execFile = File.createTempFile("libavoid-server", ".exe");
            FileOutputStream dest = new FileOutputStream(execFile);
            InputStream source = url.openStream();
            byte[] buffer = new byte[512];
            do {
                if ((count = source.read(buffer)) <= 0) continue;
                ((OutputStream)dest).write(buffer, 0, count);
            } while (count > 0);
            ((OutputStream)dest).close();
            this.tempFile = execFile;
        }
        switch (os) {
            case LINUX32: 
            case LINUX64: 
            case OSX32: 
            case OSX64: 
            case SOLARIS: {
                boolean success;
                if (execFile.canExecute() || (success = execFile.setExecutable(true))) break;
                throw new LibavoidServerException("Failed to set executable permission for " + execFile.getPath());
            }
        }
        return execFile;
    }

    public synchronized void initialize() {
        if (this.watchdog == null) {
            this.watchdog = new Watchdog();
            this.watchdog.setName("Libavoid Watchdog");
            this.watchdog.start();
        }
        if (this.process == null) {
            try {
                try {
                    if (this.executable == null) {
                        this.executable = this.resolveExecutable().getPath();
                    }
                    this.process = Runtime.getRuntime().exec(new String[]{this.executable});
                }
                catch (IOException exception) {
                    throw new LibavoidServerException("Failed to start libavoid server process.", exception);
                }
            }
            finally {
                if (this.process == null) {
                    this.cleanup(Cleanup.STOP);
                }
            }
        }
    }

    public OutputStream input() {
        if (this.process != null) {
            return new BufferedOutputStream(this.process.getOutputStream());
        }
        throw new IllegalStateException("Libavoid server has not been initialized.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream output() {
        if (this.process != null) {
            Object object = this.nextJob;
            synchronized (object) {
                this.libavoidStream = this.process.getInputStream();
                this.nextJob.notify();
            }
            return this.libavoidStream;
        }
        throw new IllegalStateException("Libavoid server has not been initialized.");
    }

    public Map<String, String> readOutputData() {
        HashMap<String, String> data = new HashMap<String, String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.output()));
        ParseState state = ParseState.TYPE;
        boolean parseMore = true;
        StringBuilder error = null;
        block7: while (parseMore) {
            String line = null;
            try {
                line = reader.readLine();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (line == null) {
                return null;
            }
            if (line.startsWith("DEBUG")) {
                System.out.println(line);
                continue;
            }
            switch (state) {
                case TYPE: {
                    if (line.equals("LAYOUT")) {
                        state = ParseState.DATA;
                        break;
                    }
                    if (!line.equals("ERROR")) break;
                    state = ParseState.ERROR;
                    error = new StringBuilder();
                    break;
                }
                case DATA: {
                    if (line.equals("DONE")) {
                        parseMore = false;
                        break;
                    }
                    String[] tokens = line.split("=");
                    if (tokens.length != 2 || tokens[0].length() <= 0) continue block7;
                    data.put(tokens[0], tokens[1]);
                    break;
                }
                case ERROR: {
                    if (line.equals("DONE")) {
                        this.cleanup(Cleanup.STOP);
                        throw new LibavoidServerException(error.toString());
                    }
                    if (error.length() > 0) {
                        error.append('\n');
                    }
                    error.append(line);
                }
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void cleanup(Cleanup c) {
        StringBuilder error = null;
        if (this.process != null) {
            InputStream errorStream = this.process.getErrorStream();
            try {
                if (c == Cleanup.ERROR) {
                    int exitValue;
                    int ch;
                    Thread.sleep(500L);
                    error = new StringBuilder();
                    do {
                        if ((ch = errorStream.read()) < 0) continue;
                        error.append((char)ch);
                    } while (error.length() < 512 && ch >= 0);
                    if (error.length() == 0 && (exitValue = this.process.exitValue()) != 0) {
                        this.exitValueError(exitValue, error);
                    }
                }
                while (errorStream.available() > 0) {
                    errorStream.read();
                }
            }
            catch (Exception ch) {
                // empty catch block
            }
            if (c == Cleanup.ERROR || c == Cleanup.STOP) {
                try {
                    this.process.getOutputStream().close();
                    this.process.getInputStream().close();
                }
                catch (IOException ch) {
                    // empty catch block
                }
                this.process.destroy();
                this.process = null;
                if (this.tempFile != null) {
                    this.tempFile.delete();
                    this.tempFile = null;
                }
            }
        }
        Object object = this.nextJob;
        synchronized (object) {
            this.libavoidStream = null;
            if (this.watchdog != null) {
                Watchdog myWatchdog = this.watchdog;
                if (c == Cleanup.ERROR || c == Cleanup.STOP) {
                    this.watchdog = null;
                }
                myWatchdog.interrupt();
            }
        }
        if (error != null && error.length() > 0) {
            throw new LibavoidServerException("Libavoid error: " + error.toString());
        }
    }

    private void exitValueError(int exitValue, StringBuilder error) {
        error.append("Process terminated with exit value ").append(exitValue);
        if (exitValue > 128) {
            switch (exitValue - 128) {
                case 2: {
                    error.append(" (interrupted)");
                    break;
                }
                case 3: {
                    error.append(" (quit)");
                    break;
                }
                case 4: {
                    error.append(" (illegal instruction)");
                    break;
                }
                case 6: {
                    error.append(" (aborted)");
                    break;
                }
                case 8: {
                    error.append(" (floating point error)");
                    break;
                }
                case 9: {
                    error.append(" (killed)");
                    break;
                }
                case 11: {
                    error.append(" (segmentation fault)");
                    break;
                }
                case 13: {
                    error.append(" (broken pipe)");
                    break;
                }
                case 15: {
                    error.append(" (terminated)");
                }
            }
        }
        error.append('.');
    }

    public static enum Cleanup {
        NORMAL,
        ERROR,
        STOP;

    }

    private static enum OS {
        LINUX32,
        LINUX64,
        WIN32,
        WIN64,
        OSX32,
        OSX64,
        SOLARIS,
        UNKNOWN;

    }

    private static enum ParseState {
        TYPE,
        DATA,
        ERROR;

    }

    private class Watchdog
    extends Thread {
        private Watchdog() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            do {
                block14: {
                    var1_2 = LibavoidServer.this.nextJob;
                    synchronized (var1_2) {
                        while (true) lbl-1000:
                        // 3 sources

                        {
                            if (LibavoidServer.this.libavoidStream != null) {
                                break block14;
                            }
                            try {
                                LibavoidServer.this.nextJob.wait();
                            }
                            catch (InterruptedException ex) {
                                if (LibavoidServer.this.watchdog != this) ** break;
                                continue;
                                return;
                            }
                            break;
                        }
                        ** GOTO lbl-1000
                    }
                }
                interrupted = false;
                try {
                    Thread.sleep(LibavoidServer.this.processTimeout);
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                }
                if (interrupted) continue;
                var2_3 = LibavoidServer.this.nextJob;
                synchronized (var2_3) {
                    myProcess = LibavoidServer.this.process;
                    if (myProcess != null) {
                        LibavoidServer.this.libavoidStream = null;
                        myProcess.destroy();
                    }
                }
            } while (LibavoidServer.this.watchdog == this);
        }
    }
}

