/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.common.polyomino.structures;

import org.eclipse.elk.alg.common.polyomino.structures.Direction;
import org.eclipse.elk.alg.common.polyomino.structures.Polyomino;
import org.eclipse.elk.alg.common.polyomino.structures.TwoBitGrid;
import org.eclipse.elk.alg.common.utils.UniqueTriple;
import org.eclipse.elk.core.util.Quadruple;

public class PlanarGrid
extends TwoBitGrid {
    private int xCenter;
    private int yCenter;

    PlanarGrid() {
        super(0, 0);
        this.xCenter = 0;
        this.yCenter = 0;
    }

    public PlanarGrid(int width, int height) {
        super(width, height);
        this.xCenter = width - 1 >> 1;
        this.yCenter = height - 1 >> 1;
    }

    public boolean isEmptyCenterBased(int x, int y) throws IndexOutOfBoundsException {
        try {
            return this.isEmpty(x + this.xCenter, y + this.yCenter);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(e.getLocalizedMessage() + " Given center based coordinates were (" + x + ", " + y + ").");
        }
    }

    public boolean isBlockedCenterBased(int x, int y) throws IndexOutOfBoundsException {
        try {
            return this.isBlocked(x + this.xCenter, y + this.yCenter);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(e.getLocalizedMessage() + " Given center based coordinates were (" + x + ", " + y + ").");
        }
    }

    public boolean isWeaklyBlockedCenterBased(int x, int y) throws IndexOutOfBoundsException {
        try {
            return this.isWeaklyBlocked(x + this.xCenter, y + this.yCenter);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(e.getLocalizedMessage() + " Given center based coordinates were (" + x + ", " + y + ").");
        }
    }

    public boolean inBoundsCenterBased(int x, int y) {
        int xt = x;
        int yt = y;
        return this.inBounds(xt += this.xCenter, yt += this.yCenter);
    }

    public <G extends PlanarGrid> boolean intersectsWithCenterBased(G other, int xOffset, int yOffset) {
        int x = 0;
        while (x < other.getWidth()) {
            int xTranslated = x - other.getCenterX() + xOffset;
            int y = 0;
            while (y < other.getHeight()) {
                int yTranslated = y - other.getCenterY() + yOffset;
                if (this.inBoundsCenterBased(xTranslated, yTranslated) && (!other.isEmpty(x, y) && this.isBlockedCenterBased(xTranslated, yTranslated) || other.isBlocked(x, y) && !this.isEmptyCenterBased(xTranslated, yTranslated))) {
                    return true;
                }
                ++y;
            }
            ++x;
        }
        return false;
    }

    public <G extends PlanarGrid> boolean intersectsWithCenterBased(Polyomino other, int xOffset, int yOffset) {
        if (this.intersectsWithCenterBased((G)other, xOffset, yOffset)) {
            return true;
        }
        for (UniqueTriple<Direction, Integer, Integer> ext : other.getPolyominoExtensions()) {
            boolean intersects = false;
            int leftX = this.getCenterX() - other.getCenterX() + xOffset;
            int rightX = leftX + other.getWidth();
            int topY = this.getCenterY() - other.getCenterY() + yOffset;
            int bottomY = topY + other.getHeight();
            switch (ext.getFirst()) {
                case NORTH: {
                    intersects = this.weaklyIntersectsArea(leftX + ext.getSecond(), 0, leftX + ext.getThird(), topY - 1);
                    break;
                }
                case EAST: {
                    intersects = this.weaklyIntersectsArea(rightX, topY + ext.getSecond(), this.getWidth() - 1, topY + ext.getThird());
                    break;
                }
                case SOUTH: {
                    intersects = this.weaklyIntersectsArea(leftX + ext.getSecond(), bottomY, leftX + ext.getThird(), this.getHeight() - 1);
                    break;
                }
                default: {
                    intersects = this.weaklyIntersectsArea(0, topY + ext.getSecond(), leftX - 1, topY + ext.getThird());
                }
            }
            if (!intersects) continue;
            return true;
        }
        return false;
    }

    public <G extends PlanarGrid> void addFilledCellsFrom(G other, int xOffset, int yOffset) throws IndexOutOfBoundsException {
        int x = 0;
        while (x < other.getWidth()) {
            int xTranslated = x - other.getCenterX() + xOffset;
            int y = 0;
            while (y < other.getHeight()) {
                int yTranslated = y - other.getCenterY() + yOffset;
                if (other.isBlocked(x, y)) {
                    if (!this.isWeaklyBlockedCenterBased(xTranslated, yTranslated)) {
                        this.setBlockedCenterBased(xTranslated, yTranslated);
                    }
                } else if (other.isWeaklyBlocked(x, y) && !this.isBlockedCenterBased(xTranslated, yTranslated)) {
                    this.setWeaklyBlockedCenterBased(xTranslated, yTranslated);
                }
                ++y;
            }
            ++x;
        }
    }

    public void addFilledCellsFrom(Polyomino other, int xOffset, int yOffset) throws IndexOutOfBoundsException {
        this.addFilledCellsFrom((PlanarGrid)other, xOffset, yOffset);
        other.setX(this.xCenter - other.getCenterX() + xOffset);
        other.setY(this.yCenter - other.getCenterY() + yOffset);
        for (UniqueTriple<Direction, Integer, Integer> ext : other.getPolyominoExtensions()) {
            switch (ext.getFirst()) {
                case NORTH: {
                    this.weaklyBlockArea(other.getX() + ext.getSecond(), 0, other.getX() + ext.getThird(), other.getY() - 1);
                    break;
                }
                case EAST: {
                    this.weaklyBlockArea(other.getX() + other.getWidth(), other.getY() + ext.getSecond(), this.getWidth() - 1, other.getY() + ext.getThird());
                    break;
                }
                case SOUTH: {
                    this.weaklyBlockArea(other.getX() + ext.getSecond(), other.getY() + other.getHeight(), other.getX() + ext.getThird(), this.getHeight() - 1);
                    break;
                }
                default: {
                    this.weaklyBlockArea(0, other.getY() + ext.getSecond(), other.getX() - 1, other.getY() + ext.getThird());
                }
            }
        }
    }

    public Quadruple<Integer, Integer, Integer, Integer> getFilledBounds() {
        int gridWidth = this.getWidth();
        int gridHeight = this.getHeight();
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        int xi = 0;
        while (xi < gridWidth) {
            int yi = 0;
            while (yi < gridHeight) {
                if (this.isBlocked(xi, yi)) {
                    minX = Math.min(minX, xi);
                    maxX = Math.max(maxX, xi);
                    minY = Math.min(minY, yi);
                    maxY = Math.max(maxY, yi);
                }
                ++yi;
            }
            ++xi;
        }
        int width = maxX - minX + 1;
        int height = maxY - minY + 1;
        return new Quadruple((Object)minX, (Object)minY, (Object)width, (Object)height);
    }

    public void weaklyBlockArea(int xUpperLeft, int yUpperleft, int xBottomRight, int yBottomRight) {
        int yi = yUpperleft;
        while (yi <= yBottomRight) {
            int xi = xUpperLeft;
            while (xi <= xBottomRight) {
                if (!this.isBlocked(xi, yi)) {
                    this.setWeaklyBlocked(xi, yi);
                }
                ++xi;
            }
            ++yi;
        }
    }

    public boolean weaklyIntersectsArea(int xUpperLeft, int yUpperleft, int xBottomRight, int yBottomRight) {
        int yi = yUpperleft;
        while (yi <= yBottomRight) {
            int xi = xUpperLeft;
            while (xi <= xBottomRight) {
                if (this.isBlocked(xi, yi)) {
                    return true;
                }
                ++xi;
            }
            ++yi;
        }
        return false;
    }

    public int getCenterX() {
        return this.xCenter;
    }

    public int getCenterY() {
        return this.yCenter;
    }

    @Override
    public void reinitialize(int width, int height) {
        super.reinitialize(width, height);
        this.xCenter = width - 1 >> 1;
        this.yCenter = height - 1 >> 1;
    }

    void setBlockedCenterBased(int x, int y) throws IndexOutOfBoundsException {
        try {
            this.setBlocked(x + this.xCenter, y + this.yCenter);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(e.getLocalizedMessage() + " Given center based coordinates were (" + x + ", " + y + ").");
        }
    }

    void setEmptyCenterBased(int x, int y) throws IndexOutOfBoundsException {
        try {
            this.setEmpty(x + this.xCenter, y + this.yCenter);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(e.getLocalizedMessage() + " Given center based coordinates were (" + x + ", " + y + ").");
        }
    }

    void setWeaklyBlockedCenterBased(int x, int y) throws IndexOutOfBoundsException {
        try {
            this.setWeaklyBlocked(x + this.xCenter, y + this.yCenter);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(e.getLocalizedMessage() + " Given center based coordinates were (" + x + ", " + y + ").");
        }
    }
}

