/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.portfolio.genchain.extension;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.egf.model.pattern.Substitution;
import org.eclipse.egf.pattern.EGFPatternPlugin;
import org.eclipse.egf.portfolio.genchain.Activator;
import org.eclipse.egf.portfolio.genchain.Messages;
import org.eclipse.egf.portfolio.genchain.extension.ExtensionProperties;
import org.eclipse.egf.portfolio.genchain.generationChain.EcoreElement;
import org.eclipse.emf.ecore.EAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExtensionHelper
implements ExtensionProperties {
    private static final String EXTENSION_ID = "org.eclipse.egf.portfolio.genchain.elements";
    private static final List<String> EMPTY_LIST = new ArrayList<String>();
    protected final List<Substitution> EMPTY_SUBSTITUTION = new ArrayList<Substitution>();
    protected final Map<EAttribute, String> properties = new HashMap<EAttribute, String>();
    private String id;

    public abstract EcoreElement createEcoreElement(Map<String, String> var1);

    public abstract String getLabel();

    public List<String> getConflictingExtensions() {
        return EMPTY_LIST;
    }

    public final Map<EAttribute, String> getDefaultProperties(Map<String, String> context) {
        if (this.properties.isEmpty()) {
            this.computeDefaultProperties(context);
        }
        return this.properties;
    }

    protected void computeDefaultProperties(Map<String, String> context) {
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<Substitution> getSubstitutions() {
        return this.EMPTY_SUBSTITUTION;
    }

    public static Map<String, ExtensionHelper> getExtensionsAsMap() {
        HashMap<String, ExtensionHelper> result = new HashMap<String, ExtensionHelper>();
        for (ExtensionHelper helper : ExtensionHelper.getExtensions()) {
            result.put(helper.getId(), helper);
        }
        return result;
    }

    public static List<ExtensionHelper> getExtensions() {
        ArrayList<ExtensionHelper> result = new ArrayList<ExtensionHelper>();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                ExtensionHelper pe = (ExtensionHelper)element.createExecutableExtension("class");
                String id = element.getAttribute("id");
                if (id == null) {
                    Activator.getDefault().logError(Messages.bind((String)Messages.Extension_load_error1, (Object)element.getAttribute("class")));
                } else {
                    pe.setId(id);
                    result.add(pe);
                }
            }
            catch (CoreException e) {
                EGFPatternPlugin.getDefault().logError((Throwable)e);
            }
            ++n2;
        }
        return result;
    }

    public static List<Substitution> getAllSubstitutions() {
        ArrayList<Substitution> all = new ArrayList<Substitution>();
        for (ExtensionHelper eh : ExtensionHelper.getExtensions()) {
            all.addAll(eh.getSubstitutions());
        }
        return all;
    }
}

