/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.compare;

import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.ICompareInputLabelProvider;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.ContentMergeViewer;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.MergeSourceViewer;
import org.eclipse.compare.internal.ViewerDescriptor;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.core.exception.EGerritException;
import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.egerrit.internal.model.FileInfo;
import org.eclipse.egerrit.internal.model.RevisionInfo;
import org.eclipse.egerrit.internal.model.impl.StringToFileInfoImpl;
import org.eclipse.egerrit.internal.ui.compare.CommentAnnotationPainter;
import org.eclipse.egerrit.internal.ui.compare.CommentableCompareItem;
import org.eclipse.egerrit.internal.ui.compare.CompareItemFactory;
import org.eclipse.egerrit.internal.ui.compare.CompareUpperSection;
import org.eclipse.egerrit.internal.ui.compare.EditionLimiter;
import org.eclipse.egerrit.internal.ui.compare.EmptyTypedElement;
import org.eclipse.egerrit.internal.ui.compare.GerritCommentAnnotation;
import org.eclipse.egerrit.internal.ui.compare.GerritCompareInputLabelProvider;
import org.eclipse.egerrit.internal.ui.compare.GerritDiffNode;
import org.eclipse.egerrit.internal.ui.compare.OpenWorkspaceFile;
import org.eclipse.egerrit.internal.ui.compare.OrphanedFileInfo;
import org.eclipse.egerrit.internal.ui.compare.PatchSetCompareItem;
import org.eclipse.egerrit.internal.ui.compare.UICompareUtils;
import org.eclipse.egerrit.internal.ui.editors.OpenCompareEditor;
import org.eclipse.egerrit.internal.ui.editors.QueryHelpers;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.emf.common.util.WeakInterningHashSet;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.team.internal.ui.synchronize.LocalResourceTypedElement;
import org.eclipse.team.ui.synchronize.SaveableCompareEditorInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GerritMultipleInput
extends SaveableCompareEditorInput {
    private static Logger logger = LoggerFactory.getLogger(GerritMultipleInput.class);
    static final String WORKSPACE = "WORKSPACE";
    public static final String BASE = "BASE";
    private GerritDiffNode root;
    private ChangeInfo changeInfo;
    private FileInfo fileToReveal;
    DiffNode nodeToReveal;
    private String leftSide;
    private String rightSide;
    GerritClient gerritClient;
    private byte problemSavingChanges = (byte)-1;
    private Runnable postSaveListener;
    private LocalResourceTypedElement cachedElement;
    private WeakInterningHashSet<SourceViewer> decoratedViewers = new WeakInterningHashSet(3);
    private CompareUpperSection upperSection;

    public GerritMultipleInput(String leftSide, String rightSide, ChangeInfo changeInfo, GerritClient gerrit, FileInfo toReveal) {
        super(GerritMultipleInput.initConfiguration(), null);
        Assert.isNotNull((Object)leftSide);
        Assert.isNotNull((Object)rightSide);
        Assert.isNotNull((Object)changeInfo);
        this.leftSide = leftSide;
        this.rightSide = rightSide;
        this.changeInfo = changeInfo;
        this.fileToReveal = toReveal;
        this.gerritClient = gerrit;
        this.root = new GerritDiffNode(0){

            @Override
            public String getName() {
                return GerritMultipleInput.this.getName();
            }

            public boolean hasChildren() {
                return true;
            }

            @Override
            public void addPropertyChangeListener(PropertyChangeListener listener) {
            }

            @Override
            public void removePropertyChangeListener(PropertyChangeListener listener) {
            }
        };
    }

    private static CompareConfiguration initConfiguration() {
        CompareConfiguration config = new CompareConfiguration();
        config.setDefaultLabelProvider((ICompareInputLabelProvider)new GerritCompareInputLabelProvider());
        return config;
    }

    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.resetRoot();
        this.nodeToReveal = null;
        if (this.leftSide.equals(this.rightSide)) {
            return this.root;
        }
        if (this.leftSide.equals(BASE) && this.rightSide.equals(WORKSPACE) || this.leftSide.equals(WORKSPACE) && this.rightSide.equals(BASE)) {
            this.compareWorkspaceWithBase(monitor);
        } else if (this.leftSide.equals(BASE) || this.rightSide.equals(BASE)) {
            this.compareRevisionWithBase(monitor);
        } else if (this.leftSide.equals(WORKSPACE) || this.rightSide.equals(WORKSPACE)) {
            this.compareRevisionWithWorkspace(monitor);
        } else {
            this.compareRevisions(monitor);
        }
        return this.root;
    }

    private void compareWorkspaceWithBase(IProgressMonitor monitor) {
        this.loadRevision(this.changeInfo.getRevision().getId());
        RevisionInfo rightRevision = (RevisionInfo)this.changeInfo.getRevisions().get((Object)this.changeInfo.getRevision().getId());
        for (FileInfo rightFile : rightRevision.getFiles().values()) {
            GerritDiffNode node = this.createBaseWorkspaceNode(monitor, rightFile);
            this.root.add((IDiffElement)node);
            this.setElementToReveal(node, rightFile);
        }
    }

    void switchInputs(String left, String right) {
        try {
            if (left == null && this.rightSide.equals(right)) {
                return;
            }
            if (right == null && this.leftSide.equals(left)) {
                return;
            }
            Object selectedElement = this.getSelectedEdition();
            if (selectedElement != null) {
                this.fileToReveal = ((GerritDiffNode)((Object)selectedElement)).getFileInfo();
            }
            if (left != null) {
                this.leftSide = left;
            }
            if (right != null) {
                this.rightSide = right;
            }
            this.prepareInput((IProgressMonitor)new NullProgressMonitor());
            this.upperSection.setInput((Object)this.root);
        }
        catch (InterruptedException | InvocationTargetException e) {
            logger.error("Problem while switching input to " + left + " " + right, (Throwable)e);
        }
    }

    private void resetRoot() {
        IDiffElement[] children;
        IDiffElement[] iDiffElementArray = children = this.root.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IDiffElement child = iDiffElementArray[n2];
            this.root.remove(child);
            ++n2;
        }
    }

    private void compareRevisions(IProgressMonitor monitor) {
        this.loadRevision(this.leftSide);
        this.loadRevision(this.rightSide);
        Map<String, FileInfo> files = this.loadRevisionDiff(this.rightSide, this.leftSide);
        for (Map.Entry<String, FileInfo> file : files.entrySet()) {
            GerritDiffNode node = this.createRevisionRevisionNode(monitor, (RevisionInfo)this.changeInfo.getRevisions().get((Object)this.leftSide), (RevisionInfo)this.changeInfo.getRevisions().get((Object)this.rightSide), file.getValue(), file.getKey());
            if (node == null) continue;
            this.root.add((IDiffElement)node);
            this.setElementToReveal(node, node.getFileInfo());
        }
    }

    private Map<String, FileInfo> loadRevisionDiff(String referenceRevision, String base) {
        HashMap files = null;
        try {
            files = (HashMap)this.gerritClient.getFilesModifiedSince(this.changeInfo.getId(), referenceRevision, base).call();
        }
        catch (EGerritException e) {
            logger.debug("An exception occurred while getting the diff between revision " + referenceRevision + " and " + base, (Throwable)e);
            files = new HashMap();
        }
        return files;
    }

    private GerritDiffNode createRevisionRevisionNode(IProgressMonitor monitor, RevisionInfo leftRevision, RevisionInfo rightRevision, FileInfo fileToShow, String filePathToShow) {
        int differenceKind = this.getDifferenceFlag(fileToShow);
        GerritDiffNode node = new GerritDiffNode(differenceKind);
        node.setDiffFileInfo(fileToShow);
        ITypedElement leftFile = null;
        ITypedElement rightFile = null;
        switch (differenceKind) {
            case 17: {
                node.setFileInfo((FileInfo)leftRevision.getFiles().get((Object)filePathToShow));
                FileInfo potentialRight = (FileInfo)rightRevision.getFiles().get((Object)filePathToShow);
                if (potentialRight == null) {
                    leftFile = new CompareItemFactory(this.gerritClient).createCompareItemFromRevision(filePathToShow, this.changeInfo.getId(), (FileInfo)leftRevision.getFiles().get((Object)filePathToShow), monitor);
                    rightFile = new EmptyTypedElement(filePathToShow);
                    break;
                }
                leftFile = new CompareItemFactory(this.gerritClient).createCompareItemFromRevision(filePathToShow, this.changeInfo.getId(), (FileInfo)leftRevision.getFiles().get((Object)filePathToShow), monitor);
                rightFile = new CompareItemFactory(this.gerritClient).createCompareItemFromRevision(filePathToShow, this.changeInfo.getId(), (FileInfo)rightRevision.getFiles().get((Object)filePathToShow), monitor);
                break;
            }
            case 128: 
            case 256: {
                String baseCommitId;
                OrphanedFileInfo o;
                if (leftRevision.getFiles().get((Object)filePathToShow) != null) {
                    leftFile = new CompareItemFactory(this.gerritClient).createCompareItemFromRevision(filePathToShow, this.changeInfo.getId(), (FileInfo)leftRevision.getFiles().get((Object)filePathToShow), monitor);
                    node.setFileInfo((FileInfo)leftRevision.getFiles().get((Object)filePathToShow));
                } else {
                    o = new OrphanedFileInfo();
                    o.setFilePath(filePathToShow);
                    o.setRevisionInfo(leftRevision);
                    baseCommitId = this.getBaseCommitId((FileInfo)o);
                    leftFile = baseCommitId != null ? new CompareItemFactory(this.gerritClient).createCompareItemFromCommit(leftRevision, (FileInfo)o, filePathToShow, leftRevision.get_number(), monitor) : new EmptyTypedElement(fileToShow.getOld_path());
                    node.setFileInfo((FileInfo)o);
                }
                if (rightRevision.getFiles().get((Object)fileToShow.getOld_path()) != null) {
                    rightFile = new CompareItemFactory(this.gerritClient).createCompareItemFromRevision(fileToShow.getOld_path(), this.changeInfo.getId(), (FileInfo)rightRevision.getFiles().get((Object)fileToShow.getOld_path()), monitor);
                    break;
                }
                o = new OrphanedFileInfo();
                o.setFilePath(fileToShow.getOld_path());
                o.setOld_path(fileToShow.getOld_path());
                o.setRevisionInfo(rightRevision);
                o.setStatus(fileToShow.getStatus());
                o.setReviewed(fileToShow.isReviewed());
                baseCommitId = this.getBaseCommitId((FileInfo)o);
                if (baseCommitId != null) {
                    rightFile = new CompareItemFactory(this.gerritClient).createCompareItemFromCommit(rightRevision, (FileInfo)o, fileToShow.getOld_path(), rightRevision.get_number(), monitor);
                    break;
                }
                rightFile = new EmptyTypedElement(fileToShow.getOld_path());
                break;
            }
            case 67: {
                leftFile = leftRevision.getFiles().get((Object)filePathToShow) == null ? new CompareItemFactory(this.gerritClient).createCompareItemFromCommit(leftRevision, (FileInfo)rightRevision.getFiles().get((Object)filePathToShow), null, leftRevision.get_number(), monitor) : new CompareItemFactory(this.gerritClient).createCompareItemFromRevision(filePathToShow, this.changeInfo.getId(), (FileInfo)leftRevision.getFiles().get((Object)filePathToShow), monitor);
                if (rightRevision.getFiles().get((Object)filePathToShow) == null) {
                    rightFile = new CompareItemFactory(this.gerritClient).createCompareItemFromCommit(rightRevision, (FileInfo)leftRevision.getFiles().get((Object)filePathToShow), null, rightRevision.get_number(), monitor);
                    node.setFileInfo((FileInfo)leftRevision.getFiles().get((Object)filePathToShow));
                    break;
                }
                rightFile = new CompareItemFactory(this.gerritClient).createCompareItemFromRevision(filePathToShow, this.changeInfo.getId(), (FileInfo)rightRevision.getFiles().get((Object)filePathToShow), monitor);
                node.setFileInfo((FileInfo)rightRevision.getFiles().get((Object)filePathToShow));
                break;
            }
            case 34: {
                leftFile = new EmptyTypedElement(filePathToShow);
                rightFile = new CompareItemFactory(this.gerritClient).createCompareItemFromRevision(filePathToShow, this.changeInfo.getId(), (FileInfo)rightRevision.getFiles().get((Object)filePathToShow), monitor);
                node.setFileInfo((FileInfo)rightRevision.getFiles().get((Object)filePathToShow));
                break;
            }
            default: {
                return null;
            }
        }
        node.setLeft(leftFile);
        node.setRight(rightFile);
        return node;
    }

    private String getBaseCommitId(FileInfo fileInfo) {
        return fileInfo.getRevision().getBaseCommit();
    }

    /*
     * Exception decompiling
     */
    private int getDifferenceFlag(FileInfo file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[8] lbl48 : CaseStatement: default:\u000a, @NONE, blocks:[8] lbl48 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void compareRevisionWithWorkspace(IProgressMonitor monitor) {
        boolean workspaceOnRight = this.rightSide.equals(WORKSPACE);
        this.loadRevision(workspaceOnRight ? this.leftSide : this.rightSide);
        RevisionInfo filesToShow = (RevisionInfo)this.changeInfo.getRevisions().get((Object)(workspaceOnRight ? this.leftSide : this.rightSide));
        for (FileInfo file : filesToShow.getFiles().values()) {
            GerritDiffNode node = this.createWorkspaceRevisionNode(monitor, file);
            this.root.add((IDiffElement)node);
            this.setElementToReveal(node, file);
        }
    }

    private void loadRevision(String revision) {
        QueryHelpers.loadFiles(this.gerritClient, (RevisionInfo)this.changeInfo.getRevisions().get((Object)revision));
        CompletableFuture.runAsync(() -> QueryHelpers.loadRevisionDetails(this.gerritClient, (RevisionInfo)this.changeInfo.getRevisions().get((Object)revision)));
    }

    private GerritDiffNode createWorkspaceRevisionNode(IProgressMonitor monitor, FileInfo file) {
        boolean workspaceOnRight = this.rightSide.equals(WORKSPACE);
        String fileName = file.getPath();
        GerritDiffNode node = new GerritDiffNode(this.getDifferenceFlag(file));
        node.setFileInfo(file);
        PatchSetCompareItem revisionFile = new CompareItemFactory(this.gerritClient).createCompareItemFromRevision(fileName, this.changeInfo.getId(), file, monitor);
        IFile workspaceFile = new OpenCompareEditor(this.gerritClient, this.changeInfo).getCorrespondingWorkspaceFile(file);
        if (workspaceFile == null) {
            workspaceFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path("missing/" + fileName));
        }
        ITypedElement workspaceNode = GerritMultipleInput.createFileElement((IFile)workspaceFile);
        if (workspaceOnRight) {
            node.setRight(workspaceNode);
            node.setLeft(revisionFile);
        } else {
            node.setRight(revisionFile);
            node.setLeft(workspaceNode);
        }
        return node;
    }

    private void compareRevisionWithBase(IProgressMonitor monitor) {
        String revisionToCompareAgainst = this.leftSide.equals(BASE) ? this.rightSide : this.leftSide;
        this.loadRevision(revisionToCompareAgainst);
        RevisionInfo rightRevision = (RevisionInfo)this.changeInfo.getRevisions().get((Object)revisionToCompareAgainst);
        for (FileInfo rightFile : rightRevision.getFiles().values()) {
            GerritDiffNode node = this.createBaseRevisionNode(monitor, revisionToCompareAgainst, rightFile);
            this.root.add((IDiffElement)node);
            this.setElementToReveal(node, rightFile);
        }
    }

    private GerritDiffNode createBaseWorkspaceNode(IProgressMonitor monitor, FileInfo file) {
        String fileName = file.getPath();
        GerritDiffNode node = new GerritDiffNode(this.getDifferenceFlag(file));
        node.setFileInfo(file);
        IFile workspaceFile = new OpenCompareEditor(this.gerritClient, this.changeInfo).getCorrespondingWorkspaceFile(file);
        if (workspaceFile == null) {
            workspaceFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path("missing/" + fileName));
        }
        ITypedElement workspaceElement = GerritMultipleInput.createFileElement((IFile)workspaceFile);
        String baseCommitId = this.getBaseCommitId(file);
        ITypedElement baseElement = null;
        baseElement = baseCommitId != null ? new CompareItemFactory(this.gerritClient).createCompareItemFromBase(this.changeInfo.getRevision(), file, fileName, monitor) : new EmptyTypedElement("");
        if (this.rightSide.equals(WORKSPACE)) {
            node.setRight(workspaceElement);
            node.setLeft(baseElement);
        } else {
            node.setRight(baseElement);
            node.setLeft(workspaceElement);
        }
        return node;
    }

    private GerritDiffNode createBaseRevisionNode(IProgressMonitor monitor, String revisionToCompareAgainst, FileInfo file) {
        String fileName = file.getPath();
        GerritDiffNode node = new GerritDiffNode(this.getDifferenceFlag(file));
        node.setFileInfo(file);
        PatchSetCompareItem revisionElement = new CompareItemFactory(this.gerritClient).createCompareItemFromRevision(fileName, this.changeInfo.getId(), file, monitor);
        String baseCommitId = this.getBaseCommitId(file);
        ITypedElement baseElement = null;
        baseElement = baseCommitId != null ? new CompareItemFactory(this.gerritClient).createCompareItemFromBase((RevisionInfo)this.changeInfo.getRevisions().get((Object)revisionToCompareAgainst), file, fileName, monitor) : new EmptyTypedElement("");
        if (this.leftSide.equals(BASE)) {
            node.setLeft(baseElement);
            node.setRight(revisionElement);
        } else {
            node.setLeft(revisionElement);
            node.setRight(baseElement);
        }
        return node;
    }

    private void setElementToReveal(GerritDiffNode node, FileInfo file) {
        if (this.fileToReveal == null) {
            return;
        }
        if (file.getPath().equals(this.fileToReveal.getPath())) {
            this.nodeToReveal = node;
            this.preloadNode(node);
        }
    }

    private void preloadNode(GerritDiffNode node) {
        if (node.getLeft() instanceof IStreamContentAccessor) {
            try {
                ((IStreamContentAccessor)node.getLeft()).getContents();
            }
            catch (CoreException e) {
                logger.debug("Problem preloading left", (Throwable)e);
            }
        }
        if (node.getRight() instanceof IStreamContentAccessor) {
            try {
                ((IStreamContentAccessor)node.getRight()).getContents();
            }
            catch (CoreException e) {
                logger.debug("Problem preloading right", (Throwable)e);
            }
        }
    }

    public String getTitle() {
        return NLS.bind((String)Messages.CompareEditorTitle, (Object[])new Object[]{this.changeInfo.get_number(), this.changeInfo.getSubject(), this.getComparisonTitle()});
    }

    private String getComparisonTitle() {
        if (UICompareUtils.isMirroredOn((CompareEditorInput)this)) {
            return String.valueOf(this.getUserReadableString(this.rightSide)) + " / " + this.getUserReadableString(this.leftSide);
        }
        return String.valueOf(this.getUserReadableString(this.leftSide)) + " / " + this.getUserReadableString(this.rightSide);
    }

    private String getUserReadableString(String string) {
        if (string.equals(BASE) || string.equals(WORKSPACE)) {
            return string;
        }
        return String.valueOf(Messages.Patchset) + ((RevisionInfo)this.changeInfo.getRevisions().get((Object)string)).get_number();
    }

    public Viewer findContentViewer(Viewer oldViewer, ICompareInput input, Composite parent) {
        Viewer newViewer = super.findContentViewer(oldViewer, input, parent);
        if (newViewer != null && newViewer.getClass().getName().contains("PhpMergeViewer")) {
            ViewerDescriptor[] vds = CompareUIPlugin.getDefault().findContentViewerDescriptor(oldViewer, (Object)input, null);
            this.setContentViewerDescriptor(vds[vds.length - 1]);
            newViewer = super.findContentViewer(oldViewer, input, parent);
        }
        this.purgeCache();
        if (input instanceof GerritDiffNode) {
            GerritDiffNode node = (GerritDiffNode)input;
            if (node.getLeft() instanceof CommentableCompareItem) {
                ((CommentableCompareItem)node.getLeft()).reset();
            }
            if (node.getRight() instanceof CommentableCompareItem) {
                ((CommentableCompareItem)node.getRight()).reset();
            }
            if (node.getLeft() instanceof LocalResourceTypedElement) {
                this.addToCache((LocalResourceTypedElement)node.getLeft());
            }
            if (node.getRight() instanceof LocalResourceTypedElement) {
                this.addToCache((LocalResourceTypedElement)node.getRight());
            }
        }
        if (oldViewer == newViewer) {
            return newViewer;
        }
        this.setupCommentColorer(newViewer, 0);
        this.setupCommentColorer(newViewer, 1);
        UICompareUtils.insertAnnotationNavigationCommands((IToolBarManager)CompareViewerPane.getToolBarManager((Composite)parent));
        return newViewer;
    }

    private void addToCache(LocalResourceTypedElement typedElement) {
        try {
            this.cachedElement = typedElement;
            FileBuffers.getTextFileBufferManager().connect(this.cachedElement.getResource().getFullPath(), LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private void purgeCache() {
        if (this.cachedElement != null) {
            try {
                FileBuffers.getTextFileBufferManager().disconnect(this.cachedElement.getResource().getFullPath(), LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    public Viewer findStructureViewer(Viewer oldViewer, ICompareInput input, Composite parent) {
        if (input instanceof GerritDiffNode) {
            this.nodeToReveal = (GerritDiffNode)input;
        }
        return super.findStructureViewer(oldViewer, input, parent);
    }

    private void setupCommentColorer(Viewer contentViewer, final int side) {
        if (!(contentViewer instanceof TextMergeViewer)) {
            return;
        }
        final TextMergeViewer textMergeViewer = (TextMergeViewer)contentViewer;
        try {
            Class<TextMergeViewer> clazz = TextMergeViewer.class;
            Field declaredField = clazz.getDeclaredField(side == 0 ? "fLeft" : "fRight");
            declaredField.setAccessible(true);
            MergeSourceViewer rightSourceViewer = (MergeSourceViewer)declaredField.get(textMergeViewer);
            Field sourceViewerField = MergeSourceViewer.class.getDeclaredField("fSourceViewer");
            sourceViewerField.setAccessible(true);
            SourceViewer sourceViewer = (SourceViewer)sourceViewerField.get(rightSourceViewer);
            if (this.decoratedViewers.contains((Object)sourceViewer)) {
                return;
            }
            this.decoratedViewers.add((Object)sourceViewer);
            sourceViewer.addTextInputListener(new ITextInputListener(sourceViewer){
                final SourceViewer sv;
                AnnotationPainter commentPainter;
                EditionLimiter editionLimiter;
                VerifyListener blockEdition;
                {
                    this.sv = sourceViewer;
                }

                public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
                    this.sv.setEditable(true);
                    if (newInput instanceof CommentableCompareItem) {
                        this.commentPainter = this.initializeCommentColoring((ISourceViewer)this.sv);
                        this.editionLimiter = new EditionLimiter((TextViewer)this.sv);
                        this.sv.addTextPresentationListener((ITextPresentationListener)this.commentPainter);
                        this.sv.addPainter((IPainter)this.commentPainter);
                        this.sv.getTextWidget().addVerifyListener((VerifyListener)this.editionLimiter);
                        this.setDirty(this.isDirty((CommentableCompareItem)newInput), side);
                    } else {
                        if (newInput == null) {
                            return;
                        }
                        if (side == 0) {
                            if (!UICompareUtils.isMirroredOn((CompareEditorInput)GerritMultipleInput.this) && GerritMultipleInput.this.leftSide.equals(GerritMultipleInput.WORKSPACE)) {
                                return;
                            }
                            if (UICompareUtils.isMirroredOn((CompareEditorInput)GerritMultipleInput.this) && GerritMultipleInput.this.rightSide.equals(GerritMultipleInput.WORKSPACE)) {
                                return;
                            }
                        } else {
                            if (!UICompareUtils.isMirroredOn((CompareEditorInput)GerritMultipleInput.this) && GerritMultipleInput.this.rightSide.equals(GerritMultipleInput.WORKSPACE)) {
                                return;
                            }
                            if (UICompareUtils.isMirroredOn((CompareEditorInput)GerritMultipleInput.this) && GerritMultipleInput.this.leftSide.equals(GerritMultipleInput.WORKSPACE)) {
                                return;
                            }
                        }
                        this.blockEdition = new VerifyListener(){
                            boolean messageShown = false;

                            public void verifyText(VerifyEvent e) {
                                e.doit = false;
                                if (!this.messageShown) {
                                    MessageDialog.openInformation(null, (String)Messages.UnsupportedInput_Title, (String)Messages.UnsupportedInput_Text);
                                    this.messageShown = true;
                                }
                            }
                        };
                        this.sv.getTextWidget().addVerifyListener(this.blockEdition);
                    }
                }

                public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
                    if (oldInput instanceof CommentableCompareItem) {
                        if (this.commentPainter != null) {
                            this.sv.removePainter((IPainter)this.commentPainter);
                            this.sv.removeTextPresentationListener((ITextPresentationListener)this.commentPainter);
                        }
                        if (this.editionLimiter != null) {
                            this.sv.getTextWidget().removeVerifyListener((VerifyListener)this.editionLimiter);
                        }
                    } else if (this.blockEdition != null) {
                        this.sv.getTextWidget().removeVerifyListener(this.blockEdition);
                    }
                }

                private AnnotationPainter initializeCommentColoring(ISourceViewer viewer) {
                    return new CommentAnnotationPainter(viewer, null);
                }

                private boolean isDirty(CommentableCompareItem doc) {
                    Iterator iterator = doc.getEditableComments().getAnnotationIterator();
                    while (iterator.hasNext()) {
                        GerritCommentAnnotation annotation = (GerritCommentAnnotation)((Object)iterator.next());
                        if (annotation.getComment() != null) continue;
                        return true;
                    }
                    return false;
                }

                private void setDirty(boolean dirty, int side2) {
                    try {
                        Class<ContentMergeViewer> clazz = ContentMergeViewer.class;
                        Method declaredMethod = clazz.getDeclaredMethod(side2 == 0 ? "setLeftDirty" : "setRightDirty", Boolean.TYPE);
                        declaredMethod.setAccessible(true);
                        declaredMethod.invoke((Object)textMergeViewer, dirty);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                        // empty catch block
                    }
                }
            });
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException t) {
            logger.error("Problem while setting up coloration of comments", (Throwable)t);
        }
    }

    public void saveChanges(IProgressMonitor monitor) throws CoreException {
        try {
            super.saveChanges(monitor);
            this.forceSaveWorkspaceFile(monitor);
        }
        catch (RuntimeException ex) {
            if (CommentableCompareItem.class.getName().equals(ex.getMessage())) {
                String leftHash = Integer.toString(((GerritDiffNode)((Object)this.getSelectedEdition())).getLeft().hashCode());
                if (ex.getCause().getMessage().equals(leftHash)) {
                    this.problemSavingChanges = 0;
                    this.setLeftDirty(true);
                } else {
                    this.problemSavingChanges = 1;
                    this.setRightDirty(true);
                }
                throw new CoreException((IStatus)new Status(4, "org.eclipse.egerrit.ui", Messages.GerritMultipleInput_11));
            }
            throw ex;
        }
        if (this.postSaveListener != null) {
            this.postSaveListener.run();
        }
    }

    private void forceSaveWorkspaceFile(IProgressMonitor monitor) throws CoreException {
        if (this.getSelectedEdition() != null) {
            ITypedElement forceright;
            ITypedElement forceLeft = ((GerritDiffNode)((Object)this.getSelectedEdition())).getLeft();
            if (forceLeft instanceof LocalResourceTypedElement) {
                ((LocalResourceTypedElement)forceLeft).commit(monitor);
            }
            if ((forceright = ((GerritDiffNode)((Object)this.getSelectedEdition())).getRight()) instanceof LocalResourceTypedElement) {
                ((LocalResourceTypedElement)forceright).commit(monitor);
            }
        }
    }

    public void setDirty(boolean dirty) {
        if (this.problemSavingChanges == 0) {
            super.setDirty(true);
            this.problemSavingChanges = (byte)-1;
            this.setLeftDirty(true);
        } else if (this.problemSavingChanges == 1) {
            super.setDirty(true);
            this.problemSavingChanges = (byte)-1;
            this.setRightDirty(true);
        } else {
            super.setDirty(dirty);
        }
    }

    public String getName() {
        if (this.fileToReveal != null && (StringToFileInfoImpl)this.fileToReveal.eContainer() != null) {
            return ((StringToFileInfoImpl)this.fileToReveal.eContainer()).getKey();
        }
        return "";
    }

    public void fireInputChange() {
        GerritDiffNode savedElement = (GerritDiffNode)((Object)this.getSelectedEdition());
        NullProgressMonitor pm = new NullProgressMonitor();
        GerritDiffNode newEntry = null;
        if (this.leftSide.equals(BASE) && this.rightSide.equals(WORKSPACE) || this.leftSide.equals(WORKSPACE) && this.rightSide.equals(BASE)) {
            newEntry = this.createBaseWorkspaceNode((IProgressMonitor)pm, savedElement.getFileInfo());
        } else if (this.leftSide.equals(BASE) || this.rightSide.equals(BASE)) {
            newEntry = this.createBaseRevisionNode((IProgressMonitor)pm, this.leftSide.equals(BASE) ? this.rightSide : this.leftSide, savedElement.getFileInfo());
        } else if (this.leftSide.equals(WORKSPACE) || this.rightSide.equals(WORKSPACE)) {
            newEntry = this.createWorkspaceRevisionNode((IProgressMonitor)pm, savedElement.getFileInfo());
        } else {
            this.loadRevision(this.leftSide);
            this.loadRevision(this.rightSide);
            newEntry = this.createRevisionRevisionNode((IProgressMonitor)pm, (RevisionInfo)this.changeInfo.getRevisions().get((Object)this.leftSide), (RevisionInfo)this.changeInfo.getRevisions().get((Object)this.rightSide), savedElement.getDiffFileInfo(), savedElement.getFileInfo().getPath());
        }
        if (newEntry != null) {
            savedElement.setRight(newEntry.getRight());
            savedElement.setLeft(newEntry.getLeft());
        }
        savedElement.fireChange();
    }

    protected ICompareInput prepareCompareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        return null;
    }

    protected CompareViewerPane createStructureInputPane(Composite parent) {
        this.upperSection = new CompareUpperSection(parent, 0x800800, true, this);
        return this.upperSection;
    }

    public ChangeInfo getChangeInfo() {
        return this.changeInfo;
    }

    public String getLeftSide() {
        return this.leftSide;
    }

    public String getRightSide() {
        return this.rightSide;
    }

    public CompareUpperSection getUpperSection() {
        return this.upperSection;
    }

    protected void handleDispose() {
        this.purgeCache();
        super.handleDispose();
    }

    public void registerContextMenu(MenuManager menu, ISelectionProvider selectionProvider) {
        super.registerContextMenu(menu, selectionProvider);
        this.registerOpenWorkspaceVersion(menu, selectionProvider);
    }

    private void registerOpenWorkspaceVersion(MenuManager menu, ISelectionProvider selectionProvider) {
        menu.addMenuListener(manager -> {
            if (!(selectionProvider instanceof SourceViewer) && !(this.getSelectedEdition() instanceof GerritDiffNode)) {
                return;
            }
            manager.insertAfter("file", (IAction)new OpenWorkspaceFile((SourceViewer)selectionProvider, (GerritDiffNode)((Object)((Object)this.getSelectedEdition())), this.gerritClient));
        });
    }
}

