/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.dashboard.ui.views;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.egerrit.internal.dashboard.ui.utils.UIUtils;
import org.eclipse.egerrit.internal.dashboard.ui.views.GerritTableView;
import org.eclipse.egerrit.internal.dashboard.ui.views.Messages;
import org.eclipse.egerrit.internal.model.ApprovalInfo;
import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.egerrit.internal.model.ChangeMessageInfo;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VoteHandler
implements Listener,
MouseListener {
    private static Logger logger = LoggerFactory.getLogger(VoteHandler.class);
    private static final String URL_REG_EXP = "(?:^|[\\W])((http|https|ftp|file):\\/\\/|[A-Za-z][\\.|\\/])(([\\w\\-]+[\\.|\\/]){1,}?([\\w\\-.~]+\\/?)*[\\p{Alnum}.,%_=?&#\\-+()\\[\\]\\*$~@!:/{};']*)";
    private static final Pattern URLpattern = Pattern.compile("(?:^|[\\W])((http|https|ftp|file):\\/\\/|[A-Za-z][\\.|\\/])(([\\w\\-]+[\\.|\\/]){1,}?([\\w\\-.~]+\\/?)*[\\p{Alnum}.,%_=?&#\\-+()\\[\\]\\*$~@!:/{};']*)");
    private static final String OPEN_URL_FOR_VERIFY_KEY = "openURLFromVerify";
    private TableViewer table;
    private GerritTableView view;
    private Shell shell;

    VoteHandler(Shell shell, GerritTableView view, TableViewer table) {
        this.table = table;
        this.view = view;
        this.shell = shell;
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        Event event = new Event();
        event.x = e.x;
        event.y = e.y;
        String requestedLabel = this.getRequestedLabel(event);
        ChangeInfo review = this.fromEventToChangeInfo(event);
        if (review == null) {
            return;
        }
        Optional<Object> messageToShow = this.selectInformationFromMessage(review, requestedLabel, m -> {
            Matcher matcher = URLpattern.matcher(((ChangeMessageInfo)m).getMessage());
            if (matcher.find()) {
                return matcher.group();
            }
            return null;
        });
        if (messageToShow.isPresent()) {
            String uriToServer = (String)messageToShow.get();
            if (UIUtils.showConfirmDialog(OPEN_URL_FOR_VERIFY_KEY, this.shell, Messages.GerritTableView_openExternalPage, NLS.bind((String)Messages.GerritTableView_confirmOpenExternalPage, (Object)uriToServer)) == 1) {
                return;
            }
            try {
                IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().createBrowser("org.eclipse.egerrit.browser");
                browser.openURL(new URL(uriToServer));
            }
            catch (MalformedURLException | PartInitException e1) {
                logger.debug("Error opening URL :" + e1.toString());
            }
        }
    }

    public void mouseUp(MouseEvent e) {
    }

    public void handleEvent(Event event) {
        String labelRequested = this.getRequestedLabel(event);
        if (labelRequested == null) {
            return;
        }
        ChangeInfo review = this.fromEventToChangeInfo(event);
        if (review == null) {
            return;
        }
        Optional<Object> messageToShow = this.selectInformationFromMessage(review, labelRequested, Function.identity());
        if (messageToShow.isPresent()) {
            ToolTip tooltip = new ToolTip(this.shell, 0);
            String authorName = ((ChangeMessageInfo)messageToShow.get()).getAuthor().getName();
            tooltip.setMessage(String.valueOf(((ChangeMessageInfo)messageToShow.get()).getMessage()) + "\nby " + authorName);
            tooltip.setVisible(true);
            tooltip.setAutoHide(true);
        }
    }

    private String getRequestedLabel(Event event) {
        ViewerCell viewerCell = this.table.getCell(new Point(event.x, event.y));
        if (viewerCell != null) {
            return this.view.getReviewTable().getColumnLabel(viewerCell.getColumnIndex());
        }
        return null;
    }

    private ChangeInfo fromEventToChangeInfo(Event event) {
        Object element;
        ViewerCell viewerCell = this.table.getCell(new Point(event.x, event.y));
        if (viewerCell != null && (element = viewerCell.getViewerRow().getItem().getData()) instanceof ChangeInfo) {
            return (ChangeInfo)element;
        }
        return null;
    }

    private Optional<Object> selectInformationFromMessage(ChangeInfo review, String label, Function mapper) {
        ApprovalInfo vote = review.getMostRelevantVote(label);
        Optional<Object> messageToShow = review.getMessages().stream().filter(m -> m.getDate().equals(vote.getDate())).map(mapper).filter(m -> m != null).findFirst();
        return messageToShow;
    }

    void connect() {
        this.table.getTable().addListener(32, (Listener)this);
        this.table.getTable().addMouseListener((MouseListener)this);
    }
}

