/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.compare;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.egerrit.internal.ui.compare.CommentableCompareItem;
import org.eclipse.egerrit.internal.ui.compare.GerritCommentAnnotation;
import org.eclipse.egerrit.internal.ui.compare.GerritMultipleInput;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

class CommentAnnotationPainter
extends AnnotationPainter {
    private Map<Integer, Color> authorToColor = new HashMap<Integer, Color>();
    private final Color COLOR_ORANGE = new Color((Device)Display.getCurrent(), 242, 145, 10);
    private final Color COLOR_PURPLE = new Color((Device)Display.getCurrent(), 242, 10, 242);
    private final Color[] colors = new Color[]{Display.getCurrent().getSystemColor(13), this.COLOR_ORANGE, this.COLOR_PURPLE, Display.getCurrent().getSystemColor(5)};
    private int nextColorIdx = 0;
    private ISourceViewer viewer;
    private GerritMultipleInput input;

    public CommentAnnotationPainter(ISourceViewer sourceViewer, IAnnotationAccess access, GerritMultipleInput input) {
        super(sourceViewer, access);
        this.viewer = sourceViewer;
        this.input = input;
        Object strategyID = new Object();
        AnnotationPainter.HighlightingStrategy paintingStrategy = new AnnotationPainter.HighlightingStrategy();
        this.addTextStyleStrategy(strategyID, (AnnotationPainter.ITextStyleStrategy)paintingStrategy);
        this.addAnnotationType(GerritCommentAnnotation.TYPE, strategyID);
        this.addHighlightAnnotationType(strategyID);
    }

    protected IAnnotationModel findAnnotationModel(ISourceViewer sourceViewer) {
        if (sourceViewer.getDocument() instanceof CommentableCompareItem) {
            return ((CommentableCompareItem)sourceViewer.getDocument()).getEditableComments();
        }
        return null;
    }

    public void applyTextPresentation(TextPresentation tp) {
        IRegion activeRegion = tp.getExtent();
        AnnotationModel comments = ((CommentableCompareItem)this.viewer.getDocument()).getEditableComments();
        Iterator it = comments.getAnnotationIterator();
        while (it.hasNext()) {
            Color selectedColor;
            GerritCommentAnnotation object = (GerritCommentAnnotation)((Object)it.next());
            Position positingExistingComment = comments.getPosition((Annotation)object);
            if (activeRegion.getOffset() + activeRegion.getLength() < positingExistingComment.getOffset() || positingExistingComment.getOffset() + positingExistingComment.getLength() <= activeRegion.getOffset()) continue;
            if (object.getComment() == null || object.getComment().getAuthor() == null) {
                selectedColor = Display.getCurrent().getSystemColor(7);
            } else {
                Color colorForAuthor = this.authorToColor.get(object.getComment().getAuthor().get_account_id());
                if (colorForAuthor == null) {
                    colorForAuthor = this.getNextColor();
                    this.authorToColor.put(object.getComment().getAuthor().get_account_id(), colorForAuthor);
                }
                selectedColor = colorForAuthor;
            }
            StyleRange range = new StyleRange(positingExistingComment.getOffset(), positingExistingComment.getLength(), Display.getCurrent().getSystemColor(2), selectedColor);
            this.setAnnotationTypeColor(GerritCommentAnnotation.TYPE, selectedColor);
            tp.mergeStyleRange(range);
        }
    }

    private Color getNextColor() {
        Color selectedColor = this.colors[this.nextColorIdx];
        this.nextColorIdx = this.nextColorIdx == 3 ? 0 : ++this.nextColorIdx;
        return selectedColor;
    }

    public void dispose() {
        super.dispose();
        this.COLOR_ORANGE.dispose();
        this.COLOR_PURPLE.dispose();
    }
}

