/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.editors;

import java.io.IOException;
import java.net.URISyntaxException;
import org.eclipse.egerrit.internal.core.EGerritCorePlugin;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.ui.utils.GerritToGitMapping;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.URIish;

public class FindLocalRepository {
    private Repository repository = null;

    public FindLocalRepository(GerritClient gerrit, String projectName) {
        GerritToGitMapping gerritToGitMap = null;
        try {
            gerritToGitMap = new GerritToGitMapping(new URIish(gerrit.getRepository().getURIBuilder(false).toString()), projectName);
        }
        catch (URISyntaxException e2) {
            EGerritCorePlugin.logError((String)(String.valueOf(gerrit.getRepository().formatGerritVersion()) + e2.getMessage()));
            return;
        }
        try {
            this.repository = gerritToGitMap.find();
        }
        catch (IOException e2) {
            EGerritCorePlugin.logError((String)(String.valueOf(gerrit.getRepository().formatGerritVersion()) + e2.getMessage()));
        }
    }

    public Repository getRepository() {
        return this.repository;
    }
}

