/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.dashboard.ui.completion;

import java.util.ArrayList;
import org.eclipse.egerrit.internal.core.EGerritCorePlugin;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.core.GerritRepository;
import org.eclipse.egerrit.internal.core.command.SuggestAccountCommand;
import org.eclipse.egerrit.internal.core.exception.EGerritException;
import org.eclipse.egerrit.internal.dashboard.ui.completion.ParamCompleter;
import org.eclipse.egerrit.internal.dashboard.ui.completion.SearchContentProposal;
import org.eclipse.egerrit.internal.dashboard.ui.utils.UIUtils;
import org.eclipse.egerrit.internal.model.AccountInfo;

public class AccountCompleter
extends ParamCompleter {
    public AccountCompleter() {
        super(new String[]{"owner:", "reviewer:", "commentby:", "reviewedby:", "author:", "committer:", "from:"});
    }

    @Override
    public SearchContentProposal[] requestCompletionList(String lastWord, String query, GerritClient client) {
        ArrayList<SearchContentProposal> proposals = new ArrayList<SearchContentProposal>();
        GerritRepository currentRepository = client.getRepository();
        if ("self".startsWith(lastWord) && !currentRepository.getServerInfo().isAnonymous()) {
            proposals.add(new SearchContentProposal(String.valueOf(query.substring(0, query.length() - lastWord.length())) + "self", "self"));
        }
        if (lastWord.length() >= 3) {
            SuggestAccountCommand command = client.suggestAccount();
            command.setMaxNumberOfResults(20);
            command.setQuery(lastWord);
            AccountInfo[] res = null;
            try {
                res = (AccountInfo[])command.call();
            }
            catch (EGerritException e) {
                EGerritCorePlugin.logError((String)(String.valueOf(client.getRepository().formatGerritVersion()) + e.getMessage()));
            }
            if (res != null) {
                AccountInfo[] accountInfoArray = res;
                int n = res.length;
                int n2 = 0;
                while (n2 < n) {
                    AccountInfo info = accountInfoArray[n2];
                    String idString = String.valueOf(info.getName()) + " <" + info.getEmail() + ">";
                    proposals.add(new SearchContentProposal(String.valueOf(query.substring(0, query.length() - lastWord.length())) + UIUtils.quoteIfNeeded(idString), idString));
                    ++n2;
                }
            }
        }
        return proposals.toArray(new SearchContentProposal[proposals.size()]);
    }
}

