/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.core.command;

import java.lang.reflect.Type;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.eclipse.egerrit.internal.core.GerritRepository;
import org.eclipse.egerrit.internal.core.command.AuthentificationRequired;
import org.eclipse.egerrit.internal.core.command.BaseCommandChangeWithInput;
import org.eclipse.egerrit.internal.core.exception.EGerritException;
import org.eclipse.egerrit.internal.core.rest.RebaseInput;
import org.eclipse.egerrit.internal.model.ChangeInfo;

public class RebaseCommand
extends BaseCommandChangeWithInput<ChangeInfo, RebaseInput> {
    public RebaseCommand(GerritRepository gerritRepository, String changeId) {
        super(gerritRepository, AuthentificationRequired.YES, (Class<? extends HttpRequestBase>)HttpPost.class, (Type)((Object)ChangeInfo.class), changeId);
        this.setPathFormat("/changes/{change-id}/rebase");
    }

    @Override
    protected boolean handleHttpException(ClientProtocolException exception) throws EGerritException {
        HttpResponseException httpException;
        if (exception instanceof HttpResponseException && (httpException = (HttpResponseException)exception).getStatusCode() == 409) {
            EGerritException gerritException = new EGerritException(exception.getLocalizedMessage());
            gerritException.setCode(1);
            throw gerritException;
        }
        return false;
    }
}

