/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.css.cssext.ui.adapter;

import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.core.log.LoggerCreator;
import org.eclipse.fx.ide.css.cssext.ui.adapter.CssFile;
import org.eclipse.fx.ide.css.cssext.ui.adapter.CssFolder;
import org.eclipse.fx.ide.css.cssext.ui.adapter.CssProject;
import org.eclipse.fx.ide.css.cssext.ui.adapter.ICssResource;

public class CssAdapterFactory
implements IAdapterFactory {
    private Logger logger;
    private Map<Object, ICssResource> adapterCache = new WeakHashMap<Object, ICssResource>();

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = LoggerCreator.createLogger(CssAdapterFactory.class);
        }
        return this.logger;
    }

    private ICssResource createAdapter(Object adaptableObject) {
        this.getLogger().debug("=> creating adapter");
        if (adaptableObject instanceof IProject) {
            this.getLogger().debug(" IProject-> CssProject");
            return new CssProject((IResource)adaptableObject);
        }
        IFile adapter = (IFile)Platform.getAdapterManager().getAdapter(adaptableObject, IFile.class);
        if (adapter != null) {
            this.getLogger().debug(" IFile -> CssFile");
            return new CssFile((IResource)adaptableObject);
        }
        this.getLogger().debug("  ? -> CssFolder");
        return new CssFolder((IResource)adaptableObject);
    }

    private ICssResource getOrCreateAdapter(Object adaptableObject) {
        if (this.adapterCache.containsKey(adaptableObject)) {
            this.getLogger().debug("=> result from cache");
            return this.adapterCache.get(adaptableObject);
        }
        ICssResource newAdapter = this.createAdapter(adaptableObject);
        this.adapterCache.put(adaptableObject, newAdapter);
        return newAdapter;
    }

    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        this.getLogger().debug("getAdapter(" + String.valueOf(adaptableObject) + ") " + adaptableObject.getClass().getName());
        if (adapterType == ICssResource.class) {
            return (T)this.getOrCreateAdapter(adaptableObject);
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{ICssResource.class};
    }
}

